/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EmptySetNode
extends PlanNode {
    private static final Logger LOG = LogManager.getLogger(EmptySetNode.class);

    public EmptySetNode(PlanNodeId id, ArrayList<TupleId> tupleIds) {
        super(id, tupleIds, "EMPTYSET");
        Preconditions.checkArgument((tupleIds.size() > 0 ? 1 : 0) != 0);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        this.avgRowSize = 0.0f;
        this.cardinality = 0L;
        this.numNodes = 1;
        if (LOG.isDebugEnabled()) {
            LOG.debug("stats EmptySet:" + this.id + ", cardinality: " + this.cardinality);
        }
    }

    @Override
    public void init(Analyzer analyzer) {
        Preconditions.checkState((boolean)this.conjuncts.isEmpty());
        for (TupleId id : this.tupleIds) {
            analyzer.getTupleDesc(id).setIsMaterialized(true);
        }
        this.computeTupleStatAndMemLayout(analyzer);
        this.computeStats(analyzer);
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.EMPTY_SET_NODE;
    }
}

