/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.doris.analysis.AggregateInfo;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.InsertStmt;
import org.apache.doris.analysis.JoinOperator;
import org.apache.doris.analysis.QueryStmt;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.ColocateTableIndex;
import org.apache.doris.catalog.Column;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.OlapTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.AggregationNode;
import org.apache.doris.planner.AnalyticEvalNode;
import org.apache.doris.planner.AssertNumRowsNode;
import org.apache.doris.planner.CrossJoinNode;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.EmptySetNode;
import org.apache.doris.planner.ExchangeNode;
import org.apache.doris.planner.HashJoinNode;
import org.apache.doris.planner.JoinCostEvaluation;
import org.apache.doris.planner.MergeNode;
import org.apache.doris.planner.MysqlScanNode;
import org.apache.doris.planner.OdbcScanNode;
import org.apache.doris.planner.OlapScanNode;
import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlannerContext;
import org.apache.doris.planner.RepeatNode;
import org.apache.doris.planner.ScanNode;
import org.apache.doris.planner.SchemaScanNode;
import org.apache.doris.planner.SelectNode;
import org.apache.doris.planner.SetOperationNode;
import org.apache.doris.planner.SortNode;
import org.apache.doris.planner.TableFunctionNode;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.thrift.TPartitionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DistributedPlanner {
    private static final Logger LOG = LogManager.getLogger(DistributedPlanner.class);
    private final PlannerContext ctx_;

    public DistributedPlanner(PlannerContext ctx) {
        this.ctx_ = ctx;
    }

    public ArrayList<PlanFragment> createPlanFragments(PlanNode singleNodePlan) throws UserException, AnalysisException {
        Preconditions.checkState((!this.ctx_.isSingleNodeExec() ? 1 : 0) != 0);
        QueryStmt queryStmt = this.ctx_.getQueryStmt();
        ArrayList fragments = Lists.newArrayList();
        boolean isPartitioned = false;
        if (this.ctx_.isInsert() && !singleNodePlan.hasLimit()) {
            Preconditions.checkState((!queryStmt.hasOffset() ? 1 : 0) != 0);
            isPartitioned = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("create plan fragments");
        }
        this.createPlanFragments(singleNodePlan, isPartitioned, fragments);
        return fragments;
    }

    private boolean isFragmentPartitioned(PlanFragment fragment) {
        return fragment.isPartitioned() && fragment.getPlanRoot().getNumInstances() > 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    PlanFragment createInsertFragment(PlanFragment inputFragment, InsertStmt stmt, ArrayList<PlanFragment> fragments) throws UserException {
        Table targetTable = stmt.getTargetTable();
        Boolean isRepart = stmt.isRepartition();
        boolean needRepartition = false;
        boolean needMerge = false;
        if (this.isFragmentPartitioned(inputFragment)) {
            if (targetTable.isPartitioned()) {
                if (stmt.getDataPartition().getType() == TPartitionType.RANDOM) {
                    return inputFragment;
                }
                if (isRepart != null && !isRepart.booleanValue()) {
                    needMerge = true;
                } else {
                    needRepartition = true;
                }
            } else {
                needMerge = true;
            }
        } else {
            if (!targetTable.isPartitioned()) return inputFragment;
            if (isRepart == null || !isRepart.booleanValue()) return inputFragment;
            needRepartition = true;
        }
        if (needMerge) {
            PlanFragment newInputFragment = this.createMergeFragment(inputFragment);
            fragments.add(newInputFragment);
            return newInputFragment;
        }
        Preconditions.checkState((boolean)needRepartition);
        ExchangeNode exchNode = new ExchangeNode(this.ctx_.getNextNodeId(), inputFragment.getPlanRoot(), false);
        exchNode.setNumInstances(inputFragment.getPlanRoot().getNumInstances());
        exchNode.init(this.ctx_.getRootAnalyzer());
        DataPartition dataPartition = stmt.getDataPartition();
        PlanFragment fragment = new PlanFragment(this.ctx_.getNextFragmentId(), exchNode, dataPartition);
        inputFragment.setDestination(exchNode);
        inputFragment.setOutputPartition(dataPartition);
        fragments.add(fragment);
        return fragment;
    }

    private PlanFragment createPlanFragments(PlanNode root, boolean isPartitioned, ArrayList<PlanFragment> fragments) throws UserException {
        ArrayList childFragments = Lists.newArrayList();
        for (PlanNode child : root.getChildren()) {
            boolean childIsPartitioned = !child.hasLimit();
            childFragments.add(this.createPlanFragments(child, childIsPartitioned, fragments));
        }
        PlanFragment result = null;
        if (root instanceof ScanNode) {
            result = this.createScanFragment(root);
            fragments.add(result);
        } else if (root instanceof TableFunctionNode) {
            result = this.createTableFunctionFragment(root, (PlanFragment)childFragments.get(0));
        } else if (root instanceof HashJoinNode) {
            Preconditions.checkState((childFragments.size() == 2 ? 1 : 0) != 0);
            result = this.createHashJoinFragment((HashJoinNode)root, (PlanFragment)childFragments.get(1), (PlanFragment)childFragments.get(0), fragments);
        } else if (root instanceof CrossJoinNode) {
            result = this.createCrossJoinFragment((CrossJoinNode)root, (PlanFragment)childFragments.get(1), (PlanFragment)childFragments.get(0));
        } else if (root instanceof SelectNode) {
            result = this.createSelectNodeFragment((SelectNode)root, childFragments);
        } else if (root instanceof SetOperationNode) {
            result = this.createSetOperationNodeFragment((SetOperationNode)root, childFragments, fragments);
        } else if (root instanceof MergeNode) {
            result = this.createMergeNodeFragment((MergeNode)root, childFragments, fragments);
        } else if (root instanceof AggregationNode) {
            result = this.createAggregationFragment((AggregationNode)root, (PlanFragment)childFragments.get(0), fragments);
        } else if (root instanceof SortNode) {
            result = ((SortNode)root).isAnalyticSort() ? this.createAnalyticFragment((SortNode)root, (PlanFragment)childFragments.get(0), fragments) : this.createOrderByFragment((SortNode)root, (PlanFragment)childFragments.get(0));
        } else if (root instanceof AnalyticEvalNode) {
            result = this.createAnalyticFragment(root, (PlanFragment)childFragments.get(0), fragments);
        } else if (root instanceof EmptySetNode) {
            result = new PlanFragment(this.ctx_.getNextFragmentId(), root, DataPartition.UNPARTITIONED);
        } else if (root instanceof RepeatNode) {
            result = this.createRepeatNodeFragment((RepeatNode)root, (PlanFragment)childFragments.get(0), fragments);
        } else if (root instanceof AssertNumRowsNode) {
            result = this.createAssertFragment(root, (PlanFragment)childFragments.get(0));
        } else {
            throw new UserException("Cannot create plan fragment for this node type: " + root.getExplainString());
        }
        fragments.remove(result);
        fragments.add(result);
        if (!isPartitioned && result.isPartitioned() && result.getPlanRoot().getNumInstances() > 1) {
            result = this.createMergeFragment(result);
            fragments.add(result);
        }
        return result;
    }

    private PlanFragment createMergeFragment(PlanFragment inputFragment) throws UserException {
        Preconditions.checkState((boolean)inputFragment.isPartitioned());
        ExchangeNode mergePlan = new ExchangeNode(this.ctx_.getNextNodeId(), inputFragment.getPlanRoot(), false);
        mergePlan.setNumInstances(inputFragment.getPlanRoot().getNumInstances());
        mergePlan.init(this.ctx_.getRootAnalyzer());
        Preconditions.checkState((boolean)mergePlan.hasValidStats());
        PlanFragment fragment = new PlanFragment(this.ctx_.getNextFragmentId(), mergePlan, DataPartition.UNPARTITIONED);
        inputFragment.setDestination(mergePlan);
        return fragment;
    }

    private PlanFragment createScanFragment(PlanNode node) throws UserException {
        if (node instanceof MysqlScanNode || node instanceof OdbcScanNode) {
            return new PlanFragment(this.ctx_.getNextFragmentId(), node, DataPartition.UNPARTITIONED);
        }
        if (node instanceof SchemaScanNode) {
            return new PlanFragment(this.ctx_.getNextFragmentId(), node, DataPartition.UNPARTITIONED);
        }
        if (node instanceof OlapScanNode) {
            OlapScanNode olapScanNode = (OlapScanNode)node;
            return new PlanFragment(this.ctx_.getNextFragmentId(), node, olapScanNode.constructInputPartitionByDistributionInfo(), DataPartition.RANDOM);
        }
        return new PlanFragment(this.ctx_.getNextFragmentId(), node, DataPartition.RANDOM);
    }

    private PlanFragment createTableFunctionFragment(PlanNode node, PlanFragment childFragment) {
        Preconditions.checkState((boolean)(node instanceof TableFunctionNode));
        node.setChild(0, childFragment.getPlanRoot());
        node.setNumInstances(childFragment.getPlanRoot().getNumInstances());
        childFragment.addPlanRoot(node);
        return childFragment;
    }

    private PlanFragment createHashJoinFragment(HashJoinNode node, PlanFragment rightChildFragment, PlanFragment leftChildFragment, ArrayList<PlanFragment> fragments) throws UserException {
        ArrayList reason = Lists.newArrayList();
        if (this.canColocateJoin(node, leftChildFragment, rightChildFragment, reason)) {
            node.setColocate(true, "");
            node.setChild(0, leftChildFragment.getPlanRoot());
            node.setChild(1, rightChildFragment.getPlanRoot());
            leftChildFragment.setPlanRoot(node);
            fragments.remove(rightChildFragment);
            leftChildFragment.setHasColocatePlanNode(true);
            return leftChildFragment;
        }
        node.setColocate(false, (String)reason.get(0));
        ArrayList rhsPartitionxprs = Lists.newArrayList();
        if (this.canBucketShuffleJoin(node, leftChildFragment, (List<Expr>)rhsPartitionxprs)) {
            node.setDistributionMode(HashJoinNode.DistributionMode.BUCKET_SHUFFLE);
            DataPartition rhsJoinPartition = new DataPartition(TPartitionType.BUCKET_SHFFULE_HASH_PARTITIONED, rhsPartitionxprs);
            ExchangeNode rhsExchange = new ExchangeNode(this.ctx_.getNextNodeId(), rightChildFragment.getPlanRoot(), false);
            rhsExchange.setNumInstances(rightChildFragment.getPlanRoot().getNumInstances());
            rhsExchange.init(this.ctx_.getRootAnalyzer());
            node.setChild(0, leftChildFragment.getPlanRoot());
            node.setChild(1, rhsExchange);
            leftChildFragment.setPlanRoot(node);
            rightChildFragment.setDestination(rhsExchange);
            rightChildFragment.setOutputPartition(rhsJoinPartition);
            return leftChildFragment;
        }
        JoinCostEvaluation joinCostEvaluation = new JoinCostEvaluation(node, rightChildFragment, leftChildFragment);
        boolean doBroadcast = node.getJoinOp() != JoinOperator.RIGHT_OUTER_JOIN && node.getJoinOp() != JoinOperator.FULL_OUTER_JOIN ? (node.getInnerRef().isBroadcastJoin() ? true : !node.getInnerRef().isPartitionJoin() && joinCostEvaluation.isBroadcastCostSmaller() && joinCostEvaluation.constructHashTableSpace() <= this.ctx_.getRootAnalyzer().getAutoBroadcastJoinThreshold()) : false;
        if (doBroadcast) {
            node.setDistributionMode(HashJoinNode.DistributionMode.BROADCAST);
            node.setChild(0, leftChildFragment.getPlanRoot());
            this.connectChildFragment(node, 1, leftChildFragment, rightChildFragment);
            leftChildFragment.setPlanRoot(node);
            return leftChildFragment;
        }
        node.setDistributionMode(HashJoinNode.DistributionMode.PARTITIONED);
        List<BinaryPredicate> eqJoinConjuncts = node.getEqJoinConjuncts();
        ArrayList lhsJoinExprs = Lists.newArrayList();
        ArrayList rhsJoinExprs = Lists.newArrayList();
        for (BinaryPredicate eqJoinPredicate : eqJoinConjuncts) {
            lhsJoinExprs.add(((Expr)eqJoinPredicate.getChild(0)).clone(null));
            rhsJoinExprs.add(((Expr)eqJoinPredicate.getChild(1)).clone(null));
        }
        DataPartition lhsJoinPartition = new DataPartition(TPartitionType.HASH_PARTITIONED, Expr.cloneList(lhsJoinExprs, null));
        ExchangeNode lhsExchange = new ExchangeNode(this.ctx_.getNextNodeId(), leftChildFragment.getPlanRoot(), false);
        lhsExchange.setNumInstances(leftChildFragment.getPlanRoot().getNumInstances());
        lhsExchange.init(this.ctx_.getRootAnalyzer());
        DataPartition rhsJoinPartition = new DataPartition(TPartitionType.HASH_PARTITIONED, rhsJoinExprs);
        ExchangeNode rhsExchange = new ExchangeNode(this.ctx_.getNextNodeId(), rightChildFragment.getPlanRoot(), false);
        rhsExchange.setNumInstances(rightChildFragment.getPlanRoot().getNumInstances());
        rhsExchange.init(this.ctx_.getRootAnalyzer());
        node.setChild(0, lhsExchange);
        node.setChild(1, rhsExchange);
        PlanFragment joinFragment = new PlanFragment(this.ctx_.getNextFragmentId(), node, lhsJoinPartition);
        leftChildFragment.setDestination(lhsExchange);
        leftChildFragment.setOutputPartition(lhsJoinPartition);
        rightChildFragment.setDestination(rhsExchange);
        rightChildFragment.setOutputPartition(rhsJoinPartition);
        return joinFragment;
    }

    private boolean canColocateJoin(HashJoinNode node, PlanFragment leftChildFragment, PlanFragment rightChildFragment, List<String> cannotReason) {
        if (ConnectContext.get().getSessionVariable().isDisableColocatePlan()) {
            cannotReason.add("Session disabled");
            return false;
        }
        if (node.getInnerRef().hasJoinHints()) {
            cannotReason.add("Has join hint");
            return false;
        }
        HashMap scanNodeWithJoinConjuncts = Maps.newHashMap();
        for (BinaryPredicate eqJoinPredicate : node.getEqJoinConjuncts()) {
            OlapScanNode leftScanNode = this.genSrcScanNode((Expr)eqJoinPredicate.getChild(0), leftChildFragment, cannotReason);
            if (leftScanNode == null) {
                return false;
            }
            OlapScanNode rightScanNode = this.genSrcScanNode((Expr)eqJoinPredicate.getChild(1), rightChildFragment, cannotReason);
            if (rightScanNode == null) {
                return false;
            }
            Pair<OlapScanNode, OlapScanNode> eqPair = new Pair<OlapScanNode, OlapScanNode>(leftScanNode, rightScanNode);
            List predicateList = (List)scanNodeWithJoinConjuncts.get(eqPair);
            if (predicateList == null) {
                predicateList = Lists.newArrayList();
                scanNodeWithJoinConjuncts.put(eqPair, predicateList);
            }
            predicateList.add(eqJoinPredicate);
        }
        return this.dataDistributionMatchEqPredicate(scanNodeWithJoinConjuncts, cannotReason);
    }

    private OlapScanNode genSrcScanNode(Expr expr, PlanFragment planFragment, List<String> cannotReason) {
        SlotRef slotRef = expr.getSrcSlotRef();
        if (slotRef == null) {
            cannotReason.add("Src column hash been transformed by expr");
            return null;
        }
        ScanNode scanNode = planFragment.getPlanRoot().getScanNodeInOneFragmentBySlotRef(slotRef);
        if (scanNode == null) {
            cannotReason.add("The src data has been redistributed");
            return null;
        }
        if (scanNode instanceof OlapScanNode) {
            return (OlapScanNode)scanNode;
        }
        cannotReason.add("Only olap table support colocate plan");
        return null;
    }

    private boolean dataDistributionMatchEqPredicate(Map<Pair<OlapScanNode, OlapScanNode>, List<BinaryPredicate>> scanNodeWithJoinConjuncts, List<String> cannotReason) {
        for (Map.Entry<Pair<OlapScanNode, OlapScanNode>, List<BinaryPredicate>> entry : scanNodeWithJoinConjuncts.entrySet()) {
            OlapScanNode leftScanNode = (OlapScanNode)entry.getKey().first;
            OlapScanNode rightScanNode = (OlapScanNode)entry.getKey().second;
            List<BinaryPredicate> eqPredicates = entry.getValue();
            if (this.dataDistributionMatchEqPredicate(eqPredicates, leftScanNode, rightScanNode, cannotReason)) continue;
            return false;
        }
        return true;
    }

    private boolean dataDistributionMatchEqPredicate(List<BinaryPredicate> eqJoinPredicates, OlapScanNode leftRoot, OlapScanNode rightRoot, List<String> cannotReason) {
        boolean noNeedCheckColocateGroup;
        OlapTable leftTable = leftRoot.getOlapTable();
        OlapTable rightTable = rightRoot.getOlapTable();
        Collection<Long> leftPartitions = leftRoot.getSelectedPartitionIds();
        Collection<Long> rightPartitions = rightRoot.getSelectedPartitionIds();
        boolean bl = noNeedCheckColocateGroup = leftTable.getId() == rightTable.getId() && leftPartitions.equals(rightPartitions) && leftPartitions.size() <= 1;
        if (!noNeedCheckColocateGroup) {
            ColocateTableIndex colocateIndex = Catalog.getCurrentColocateIndex();
            if (!colocateIndex.isSameGroup(leftTable.getId(), rightTable.getId())) {
                cannotReason.add("Tables are not in the same group");
                return false;
            }
            ColocateTableIndex.GroupId groupId = colocateIndex.getGroup(leftTable.getId());
            if (colocateIndex.isGroupUnstable(groupId)) {
                cannotReason.add("Colocate group is not stable");
                return false;
            }
        }
        DistributionInfo leftDistribution = leftTable.getDefaultDistributionInfo();
        DistributionInfo rightDistribution = rightTable.getDefaultDistributionInfo();
        if (leftDistribution instanceof HashDistributionInfo && rightDistribution instanceof HashDistributionInfo) {
            List<Column> leftDistributeColumns = ((HashDistributionInfo)leftDistribution).getDistributionColumns();
            List<Column> rightDistributeColumns = ((HashDistributionInfo)rightDistribution).getDistributionColumns();
            ArrayList<Column> leftJoinColumns = new ArrayList<Column>();
            ArrayList<Column> rightJoinColumns = new ArrayList<Column>();
            for (BinaryPredicate eqJoinPredicate : eqJoinPredicates) {
                int rightColumnIndex;
                SlotRef lhsSlotRef = ((Expr)eqJoinPredicate.getChild(0)).getSrcSlotRef();
                SlotRef rhsSlotRef = ((Expr)eqJoinPredicate.getChild(1)).getSrcSlotRef();
                Preconditions.checkState((lhsSlotRef != null ? 1 : 0) != 0);
                Preconditions.checkState((rhsSlotRef != null ? 1 : 0) != 0);
                Column leftColumn = lhsSlotRef.getDesc().getColumn();
                Column rightColumn = rhsSlotRef.getDesc().getColumn();
                int leftColumnIndex = leftDistributeColumns.indexOf(leftColumn);
                if (leftColumnIndex != (rightColumnIndex = rightDistributeColumns.indexOf(rightColumn)) || leftColumnIndex == -1) continue;
                leftJoinColumns.add(leftColumn);
                rightJoinColumns.add(rightColumn);
            }
            if (leftJoinColumns.containsAll(leftDistributeColumns) && rightJoinColumns.containsAll(rightDistributeColumns)) {
                return true;
            }
        }
        cannotReason.add("Inconsistent distribution of table and querie");
        return false;
    }

    private boolean canBucketShuffleJoin(HashJoinNode node, PlanFragment leftChildFragment, List<Expr> rhsHashExprs) {
        if (!ConnectContext.get().getSessionVariable().isEnableBucketShuffleJoin()) {
            return false;
        }
        if (node.getInnerRef().hasJoinHints()) {
            return false;
        }
        PlanNode leftRoot = leftChildFragment.getPlanRoot();
        if (leftRoot instanceof OlapScanNode) {
            return this.canBucketShuffleJoin(node, leftRoot, rhsHashExprs);
        }
        if (leftRoot instanceof HashJoinNode) {
            while (leftRoot instanceof HashJoinNode) {
                leftRoot = (PlanNode)leftRoot.getChild(0);
            }
            if (leftRoot instanceof OlapScanNode) {
                return this.canBucketShuffleJoin(node, leftRoot, rhsHashExprs);
            }
        }
        return false;
    }

    private boolean canBucketShuffleJoin(HashJoinNode node, PlanNode leftRoot, List<Expr> rhsJoinExprs) {
        DistributionInfo leftDistribution;
        OlapScanNode leftScanNode = (OlapScanNode)leftRoot;
        OlapTable leftTable = leftScanNode.getOlapTable();
        if (leftScanNode.getSelectedPartitionIds().size() != 1) {
            ColocateTableIndex colocateIndex = Catalog.getCurrentColocateIndex();
            if (!leftTable.isColocateTable() || colocateIndex.isGroupUnstable(colocateIndex.getGroup(leftTable.getId()))) {
                return false;
            }
        }
        if ((leftDistribution = leftScanNode.getOlapTable().getDefaultDistributionInfo()) instanceof HashDistributionInfo) {
            List<Column> leftDistributeColumns = ((HashDistributionInfo)leftDistribution).getDistributionColumns();
            List leftDistributeColumnNames = leftDistributeColumns.stream().map(col -> leftTable.getName() + "." + col.getName()).collect(Collectors.toList());
            ArrayList<String> leftJoinColumnNames = new ArrayList<String>();
            ArrayList<Expr> rightExprs = new ArrayList<Expr>();
            List<BinaryPredicate> eqJoinConjuncts = node.getEqJoinConjuncts();
            for (BinaryPredicate eqJoinPredicate : eqJoinConjuncts) {
                SlotRef leftSlot;
                Expr lhsJoinExpr = (Expr)eqJoinPredicate.getChild(0);
                Expr rhsJoinExpr = (Expr)eqJoinPredicate.getChild(1);
                if (lhsJoinExpr.unwrapSlotRef() == null || rhsJoinExpr.unwrapSlotRef() == null || !((leftSlot = lhsJoinExpr.unwrapSlotRef()).getTable() instanceof OlapTable)) continue;
                leftJoinColumnNames.add(leftSlot.getTable().getName() + "." + leftSlot.getColumnName());
                rightExprs.add(rhsJoinExpr);
            }
            for (int i = 0; i < leftDistributeColumnNames.size(); ++i) {
                String distributeColumnName = (String)leftDistributeColumnNames.get(i);
                boolean findRhsExprs = false;
                for (int j = 0; j < leftJoinColumnNames.size(); ++j) {
                    if (!((String)leftJoinColumnNames.get(j)).equals(distributeColumnName) || !((Expr)rightExprs.get(j)).getType().equals(leftDistributeColumns.get(i).getType())) continue;
                    rhsJoinExprs.add((Expr)rightExprs.get(j));
                    findRhsExprs = true;
                    break;
                }
                if (findRhsExprs) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private PlanFragment createCrossJoinFragment(CrossJoinNode node, PlanFragment rightChildFragment, PlanFragment leftChildFragment) throws UserException {
        rightChildFragment.getPlanRoot().setCompactData(false);
        node.setChild(0, leftChildFragment.getPlanRoot());
        this.connectChildFragment(node, 1, leftChildFragment, rightChildFragment);
        leftChildFragment.setPlanRoot(node);
        return leftChildFragment;
    }

    private PlanFragment createMergeNodeFragment(MergeNode mergeNode, ArrayList<PlanFragment> childFragments, ArrayList<PlanFragment> fragments) throws UserException {
        PlanFragment childFragment;
        Preconditions.checkState((mergeNode.getChildren().size() == childFragments.size() ? 1 : 0) != 0);
        if (mergeNode.getChildren().isEmpty()) {
            Preconditions.checkState((!mergeNode.getConstExprLists().isEmpty() ? 1 : 0) != 0);
            return new PlanFragment(this.ctx_.getNextFragmentId(), mergeNode, DataPartition.UNPARTITIONED);
        }
        ExchangeNode exchNode = new ExchangeNode(this.ctx_.getNextNodeId(), (PlanNode)mergeNode, true);
        exchNode.setNumInstances(1);
        exchNode.init(this.ctx_.getRootAnalyzer());
        PlanFragment parentFragment = new PlanFragment(this.ctx_.getNextFragmentId(), exchNode, DataPartition.UNPARTITIONED);
        Preconditions.checkState((mergeNode.getTupleIds().size() == 1 ? 1 : 0) != 0);
        for (int i = 0; i < childFragments.size(); ++i) {
            childFragment = childFragments.get(i);
            MergeNode childMergeNode = new MergeNode(this.ctx_.getNextNodeId(), mergeNode);
            ArrayList<Expr> resultExprs = Expr.cloneList(mergeNode.getResultExprLists().get(i), null);
            childMergeNode.addChild(childFragment.getPlanRoot(), resultExprs);
            childFragment.setPlanRoot(childMergeNode);
            childFragment.setDestination(exchNode);
        }
        if (!mergeNode.getConstExprLists().isEmpty()) {
            MergeNode childMergeNode = new MergeNode(this.ctx_.getNextNodeId(), mergeNode);
            childMergeNode.init(this.ctx_.getRootAnalyzer());
            childMergeNode.getConstExprLists().addAll(mergeNode.getConstExprLists());
            mergeNode.getConstExprLists().clear();
            childFragment = new PlanFragment(this.ctx_.getNextFragmentId(), childMergeNode, DataPartition.UNPARTITIONED);
            childFragment.setPlanRoot(childMergeNode);
            childFragment.setDestination(exchNode);
            childFragments.add(childFragment);
            fragments.add(childFragment);
        }
        return parentFragment;
    }

    private PlanFragment createSetOperationNodeFragment(SetOperationNode setOperationNode, ArrayList<PlanFragment> childFragments, ArrayList<PlanFragment> fragments) throws UserException {
        Preconditions.checkState((setOperationNode.getChildren().size() == childFragments.size() ? 1 : 0) != 0);
        if (setOperationNode.getChildren().isEmpty()) {
            return new PlanFragment(this.ctx_.getNextFragmentId(), setOperationNode, DataPartition.UNPARTITIONED);
        }
        Preconditions.checkState((!childFragments.isEmpty() ? 1 : 0) != 0);
        int numUnpartitionedChildFragments = 0;
        for (int i = 0; i < childFragments.size(); ++i) {
            if (childFragments.get(i).isPartitioned()) continue;
            ++numUnpartitionedChildFragments;
        }
        setOperationNode.clearChildren();
        if (numUnpartitionedChildFragments == childFragments.size()) {
            PlanFragment setOperationFragment = new PlanFragment(this.ctx_.getNextFragmentId(), setOperationNode, DataPartition.UNPARTITIONED);
            for (int i = 0; i < childFragments.size(); ++i) {
                setOperationNode.addChild(childFragments.get(i).getPlanRoot());
                setOperationFragment.setFragmentInPlanTree((PlanNode)setOperationNode.getChild(i));
                setOperationFragment.addChildren(childFragments.get(i).getChildren());
            }
            setOperationNode.init(this.ctx_.getRootAnalyzer());
            fragments.removeAll(childFragments);
            return setOperationFragment;
        }
        PlanFragment setOperationFragment = new PlanFragment(this.ctx_.getNextFragmentId(), setOperationNode, new DataPartition(TPartitionType.HASH_PARTITIONED, setOperationNode.getMaterializedResultExprLists_().get(0)));
        for (int i = 0; i < childFragments.size(); ++i) {
            PlanFragment childFragment = childFragments.get(i);
            setOperationNode.addChild(null);
            this.connectChildFragment(setOperationNode, i, setOperationFragment, childFragment);
            childFragment.setOutputPartition(DataPartition.hashPartitioned(setOperationNode.getMaterializedResultExprLists_().get(i)));
        }
        return setOperationFragment;
    }

    private PlanFragment createSelectNodeFragment(SelectNode selectNode, ArrayList<PlanFragment> childFragments) {
        Preconditions.checkState((selectNode.getChildren().size() == childFragments.size() ? 1 : 0) != 0);
        PlanFragment childFragment = childFragments.get(0);
        selectNode.setChild(0, childFragment.getPlanRoot());
        childFragment.setPlanRoot(selectNode);
        return childFragment;
    }

    private void connectChildFragment(PlanNode node, int childIdx, PlanFragment parentFragment, PlanFragment childFragment) throws UserException {
        ExchangeNode exchangeNode = new ExchangeNode(this.ctx_.getNextNodeId(), childFragment.getPlanRoot(), false);
        exchangeNode.setNumInstances(childFragment.getPlanRoot().getNumInstances());
        exchangeNode.init(this.ctx_.getRootAnalyzer());
        exchangeNode.setFragment(parentFragment);
        node.setChild(childIdx, exchangeNode);
        childFragment.setDestination(exchangeNode);
    }

    private PlanFragment createParentFragment(PlanFragment childFragment, DataPartition parentPartition) throws UserException {
        ExchangeNode exchangeNode = new ExchangeNode(this.ctx_.getNextNodeId(), childFragment.getPlanRoot(), false);
        exchangeNode.setNumInstances(childFragment.getPlanRoot().getNumInstances());
        exchangeNode.init(this.ctx_.getRootAnalyzer());
        PlanFragment parentFragment = new PlanFragment(this.ctx_.getNextFragmentId(), exchangeNode, parentPartition);
        childFragment.setDestination(exchangeNode);
        childFragment.setOutputPartition(parentPartition);
        return parentFragment;
    }

    private PlanFragment createAggregationFragment(AggregationNode node, PlanFragment childFragment, ArrayList<PlanFragment> fragments) throws UserException {
        boolean isDistinct;
        if (!childFragment.isPartitioned()) {
            childFragment.addPlanRoot(node);
            return childFragment;
        }
        if (node.getAggInfo().isDistinctAgg()) {
            childFragment.addPlanRoot(node);
            return childFragment;
        }
        if (childFragment.getPlanRoot().getNumInstances() <= 1) {
            childFragment.addPlanRoot(node);
            return childFragment;
        }
        boolean bl = isDistinct = node.getChild(0) instanceof AggregationNode && ((AggregationNode)node.getChild(0)).getAggInfo().isDistinctAgg();
        if (isDistinct) {
            return this.createPhase2DistinctAggregationFragment(node, childFragment, fragments);
        }
        if (this.canColocateAgg(node.getAggInfo(), childFragment.getDataPartition())) {
            childFragment.addPlanRoot(node);
            childFragment.setHasColocatePlanNode(true);
            return childFragment;
        }
        return this.createMergeAggregationFragment(node, childFragment);
    }

    private boolean canColocateAgg(AggregateInfo aggregateInfo, DataPartition childFragmentDataPartition) {
        if (ConnectContext.get().getSessionVariable().isDisableColocatePlan()) {
            LOG.debug("Agg node is not colocate in:" + ConnectContext.get().queryId() + ", reason:" + "Session disabled");
            return false;
        }
        List<Expr> aggPartitionExprs = aggregateInfo.getInputPartitionExprs();
        return this.dataPartitionMatchAggInfo(childFragmentDataPartition, aggPartitionExprs);
    }

    private boolean dataPartitionMatchAggInfo(DataPartition dataPartition, List<Expr> aggPartitionExprs) {
        TPartitionType partitionType = dataPartition.getType();
        if (partitionType != TPartitionType.HASH_PARTITIONED) {
            return false;
        }
        List<Expr> dataPartitionExprs = dataPartition.getPartitionExprs();
        for (Expr dataPartitionExpr : dataPartitionExprs) {
            boolean match = false;
            for (Expr aggPartitionExpr : aggPartitionExprs) {
                if (!aggPartitionExpr.comeFrom(dataPartitionExpr)) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private PlanFragment createRepeatNodeFragment(RepeatNode repeatNode, PlanFragment childFragment, ArrayList<PlanFragment> fragments) throws UserException {
        repeatNode.setNumInstances(childFragment.getPlanRoot().getNumInstances());
        childFragment.addPlanRoot(repeatNode);
        childFragment.updateDataPartition(DataPartition.RANDOM);
        return childFragment;
    }

    private PlanFragment createMergeAggregationFragment(AggregationNode node, PlanFragment childFragment) throws UserException {
        Preconditions.checkArgument((boolean)childFragment.isPartitioned());
        ArrayList<Expr> groupingExprs = node.getAggInfo().getGroupingExprs();
        boolean hasGrouping = !groupingExprs.isEmpty();
        DataPartition parentPartition = null;
        if (hasGrouping) {
            List<Expr> partitionExprs = node.getAggInfo().getPartitionExprs();
            if (partitionExprs == null) {
                partitionExprs = groupingExprs;
            }
            partitionExprs = Expr.substituteList(partitionExprs, node.getAggInfo().getIntermediateSmap(), this.ctx_.getRootAnalyzer(), false);
            parentPartition = DataPartition.hashPartitioned(partitionExprs);
        } else {
            parentPartition = DataPartition.UNPARTITIONED;
        }
        childFragment.addPlanRoot(node);
        node.setIntermediateTuple();
        node.setIsPreagg(this.ctx_);
        long limit = node.getLimit();
        node.unsetLimit();
        node.unsetNeedsFinalize();
        PlanFragment mergeFragment = this.createParentFragment(childFragment, parentPartition);
        AggregationNode mergeAggNode = new AggregationNode(this.ctx_.getNextNodeId(), mergeFragment.getPlanRoot(), node.getAggInfo().getMergeAggInfo());
        mergeAggNode.init(this.ctx_.getRootAnalyzer());
        mergeAggNode.setLimit(limit);
        if (!hasGrouping) {
            // empty if block
        }
        node.transferConjuncts(mergeAggNode);
        node.computeStats(this.ctx_.getRootAnalyzer());
        mergeFragment.getPlanRoot().computeStats(this.ctx_.getRootAnalyzer());
        mergeAggNode.computeStats(this.ctx_.getRootAnalyzer());
        mergeFragment.addPlanRoot(mergeAggNode);
        return mergeFragment;
    }

    private PlanFragment createPhase2DistinctAggregationFragment(AggregationNode node, PlanFragment childFragment, ArrayList<PlanFragment> fragments) throws UserException {
        ArrayList<Expr> groupingExprs = node.getAggInfo().getGroupingExprs();
        boolean hasGrouping = !groupingExprs.isEmpty();
        Preconditions.checkState((node.getChild(0) == childFragment.getPlanRoot() ? 1 : 0) != 0);
        AggregateInfo firstPhaseAggInfo = ((AggregationNode)node.getChild(0)).getAggInfo();
        ArrayList<Expr> partitionExprs = null;
        boolean isMultiDistinct = node.getAggInfo().isMultiDistinct();
        if (hasGrouping) {
            partitionExprs = Expr.substituteList(groupingExprs, firstPhaseAggInfo.getOutputToIntermediateSmap(), this.ctx_.getRootAnalyzer(), false);
        } else if (!isMultiDistinct) {
            partitionExprs = Expr.substituteList(firstPhaseAggInfo.getGroupingExprs(), firstPhaseAggInfo.getIntermediateSmap(), this.ctx_.getRootAnalyzer(), false);
        }
        PlanFragment mergeFragment = null;
        boolean childHasCompatPartition = false;
        if (childHasCompatPartition) {
            childFragment.addPlanRoot(node);
            mergeFragment = childFragment;
        } else {
            DataPartition mergePartition = partitionExprs == null ? DataPartition.UNPARTITIONED : DataPartition.hashPartitioned(partitionExprs);
            AggregationNode preaggNode = (AggregationNode)node.getChild(0);
            preaggNode.setIsPreagg(this.ctx_);
            mergeFragment = this.createParentFragment(childFragment, mergePartition);
            AggregateInfo phase1MergeAggInfo = firstPhaseAggInfo.getMergeAggInfo();
            AggregationNode phase1MergeAggNode = new AggregationNode(this.ctx_.getNextNodeId(), (PlanNode)preaggNode, phase1MergeAggInfo);
            phase1MergeAggNode.init(this.ctx_.getRootAnalyzer());
            phase1MergeAggNode.unsetNeedsFinalize();
            phase1MergeAggNode.setIntermediateTuple();
            mergeFragment.addPlanRoot(phase1MergeAggNode);
            mergeFragment.addPlanRoot(node);
        }
        if (!hasGrouping && !isMultiDistinct) {
            if (mergeFragment != childFragment) {
                fragments.add(mergeFragment);
            }
            node.unsetNeedsFinalize();
            node.setIntermediateTuple();
            long limit = node.getLimit();
            node.unsetLimit();
            mergeFragment = this.createParentFragment(mergeFragment, DataPartition.UNPARTITIONED);
            AggregateInfo phase2MergeAggInfo = node.getAggInfo().getMergeAggInfo();
            AggregationNode phase2MergeAggNode = new AggregationNode(this.ctx_.getNextNodeId(), (PlanNode)node, phase2MergeAggInfo);
            phase2MergeAggNode.init(this.ctx_.getRootAnalyzer());
            node.transferConjuncts(phase2MergeAggNode);
            phase2MergeAggNode.setLimit(limit);
            mergeFragment.addPlanRoot(phase2MergeAggNode);
        }
        return mergeFragment;
    }

    private PlanFragment createAnalyticFragment(PlanNode node, PlanFragment childFragment, List<PlanFragment> fragments) throws UserException, AnalysisException {
        Preconditions.checkState((node instanceof SortNode || node instanceof AnalyticEvalNode ? 1 : 0) != 0);
        if (node instanceof AnalyticEvalNode) {
            AnalyticEvalNode analyticNode = (AnalyticEvalNode)node;
            if (analyticNode.getPartitionExprs().isEmpty() && analyticNode.getOrderByElements().isEmpty()) {
                PlanFragment fragment = childFragment;
                if (childFragment.isPartitioned()) {
                    fragment = this.createParentFragment(childFragment, DataPartition.UNPARTITIONED);
                }
                fragment.addPlanRoot(analyticNode);
                return fragment;
            }
            analyticNode.setNumInstances(childFragment.getPlanRoot().getNumInstances());
            childFragment.addPlanRoot(analyticNode);
            return childFragment;
        }
        SortNode sortNode = (SortNode)node;
        Preconditions.checkState((boolean)sortNode.isAnalyticSort());
        PlanFragment analyticFragment = childFragment;
        if (sortNode.getInputPartition() != null) {
            sortNode.getInputPartition().substitute(childFragment.getPlanRoot().getOutputSmap(), this.ctx_.getRootAnalyzer());
            DataPartition sortPartition = sortNode.getInputPartition();
            if (!childFragment.getDataPartition().equals(sortPartition)) {
                analyticFragment = this.createParentFragment(childFragment, sortNode.getInputPartition());
            }
        }
        analyticFragment.addPlanRoot(sortNode);
        return analyticFragment;
    }

    private PlanFragment createOrderByFragment(SortNode node, PlanFragment childFragment) throws UserException {
        node.setChild(0, childFragment.getPlanRoot());
        childFragment.addPlanRoot(node);
        if (!childFragment.isPartitioned()) {
            return childFragment;
        }
        boolean hasLimit = node.hasLimit();
        long limit = node.getLimit();
        long offset = node.getOffset();
        PlanFragment mergeFragment = this.createParentFragment(childFragment, DataPartition.UNPARTITIONED);
        ExchangeNode exchNode = (ExchangeNode)mergeFragment.getPlanRoot();
        exchNode.unsetLimit();
        if (hasLimit) {
            exchNode.setLimit(limit);
        }
        exchNode.setMergeInfo(node.getSortInfo(), offset);
        SortNode childSortNode = (SortNode)childFragment.getPlanRoot();
        Preconditions.checkState((node == childSortNode ? 1 : 0) != 0);
        if (hasLimit) {
            childSortNode.unsetLimit();
            childSortNode.setLimit(limit + offset);
        }
        childSortNode.setOffset(0L);
        childSortNode.computeStats(this.ctx_.getRootAnalyzer());
        exchNode.computeStats(this.ctx_.getRootAnalyzer());
        return mergeFragment;
    }

    private PlanFragment createAssertFragment(PlanNode assertRowCountNode, PlanFragment inputFragment) throws UserException {
        Preconditions.checkState((boolean)(assertRowCountNode instanceof AssertNumRowsNode));
        if (!inputFragment.isPartitioned()) {
            inputFragment.addPlanRoot(assertRowCountNode);
            return inputFragment;
        }
        PlanFragment mergeFragment = this.createParentFragment(inputFragment, DataPartition.UNPARTITIONED);
        ExchangeNode exchNode = (ExchangeNode)mergeFragment.getPlanRoot();
        mergeFragment.addPlanRoot(assertRowCountNode);
        exchNode.computeStats(this.ctx_.getRootAnalyzer());
        assertRowCountNode.computeStats(this.ctx_.getRootAnalyzer());
        return mergeFragment;
    }
}

