/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.DataSink;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TDataSink;
import org.apache.doris.thrift.TDataSinkType;
import org.apache.doris.thrift.TDataStreamSink;
import org.apache.doris.thrift.TExplainLevel;

public class DataStreamSink
extends DataSink {
    private final PlanNodeId exchNodeId;
    private DataPartition outputPartition;

    public DataStreamSink(PlanNodeId exchNodeId) {
        this.exchNodeId = exchNodeId;
    }

    @Override
    public PlanNodeId getExchNodeId() {
        return this.exchNodeId;
    }

    @Override
    public DataPartition getOutputPartition() {
        return this.outputPartition;
    }

    public void setPartition(DataPartition partition) {
        this.outputPartition = partition;
    }

    @Override
    public String getExplainString(String prefix, TExplainLevel explainLevel) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(prefix + "STREAM DATA SINK\n");
        strBuilder.append(prefix + "  EXCHANGE ID: " + this.exchNodeId + "\n");
        if (this.outputPartition != null) {
            strBuilder.append(prefix + "  " + this.outputPartition.getExplainString(explainLevel));
        }
        return strBuilder.toString();
    }

    @Override
    protected TDataSink toThrift() {
        TDataSink result = new TDataSink(TDataSinkType.DATA_STREAM_SINK);
        TDataStreamSink tStreamSink = new TDataStreamSink(this.exchNodeId.asInt(), this.outputPartition.toThrift());
        result.setStreamSink(tStreamSink);
        return result;
    }
}

