/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import org.apache.doris.catalog.MysqlTable;
import org.apache.doris.catalog.OdbcTable;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.MysqlTableSink;
import org.apache.doris.planner.OdbcTableSink;
import org.apache.doris.planner.PlanFragment;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TDataSink;
import org.apache.doris.thrift.TExplainLevel;

public abstract class DataSink {
    protected PlanFragment fragment_;

    public abstract String getExplainString(String var1, TExplainLevel var2);

    protected abstract TDataSink toThrift();

    public void setFragment(PlanFragment fragment) {
        this.fragment_ = fragment;
    }

    public PlanFragment getFragment() {
        return this.fragment_;
    }

    public abstract PlanNodeId getExchNodeId();

    public abstract DataPartition getOutputPartition();

    public static DataSink createDataSink(Table table) throws AnalysisException {
        if (table instanceof MysqlTable) {
            return new MysqlTableSink((MysqlTable)table);
        }
        if (table instanceof OdbcTable) {
            return new OdbcTableSink((OdbcTable)table);
        }
        throw new AnalysisException("Unknown table type " + (Object)((Object)table.getType()));
    }
}

