/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.thrift.TDataPartition;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TPartitionType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DataPartition {
    private static final Logger LOG = LogManager.getLogger(DataPartition.class);
    public static final DataPartition UNPARTITIONED = new DataPartition(TPartitionType.UNPARTITIONED);
    public static final DataPartition RANDOM = new DataPartition(TPartitionType.RANDOM);
    private final TPartitionType type;
    private ImmutableList<Expr> partitionExprs = ImmutableList.of();

    public DataPartition(TPartitionType type, List<Expr> exprs) {
        Preconditions.checkNotNull(exprs);
        Preconditions.checkState((!exprs.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((type == TPartitionType.HASH_PARTITIONED || type == TPartitionType.RANGE_PARTITIONED || type == TPartitionType.BUCKET_SHFFULE_HASH_PARTITIONED ? 1 : 0) != 0);
        this.type = type;
        this.partitionExprs = ImmutableList.copyOf(exprs);
    }

    public void substitute(ExprSubstitutionMap smap, Analyzer analyzer) throws AnalysisException {
        ArrayList<Expr> list = Expr.trySubstituteList(this.partitionExprs, smap, analyzer, false);
        this.partitionExprs = ImmutableList.copyOf(list);
    }

    public DataPartition(TPartitionType type) {
        Preconditions.checkState((type == TPartitionType.UNPARTITIONED || type == TPartitionType.RANDOM ? 1 : 0) != 0);
        this.type = type;
        this.partitionExprs = ImmutableList.of();
    }

    public static DataPartition hashPartitioned(List<Expr> exprs) {
        return new DataPartition(TPartitionType.HASH_PARTITIONED, exprs);
    }

    public boolean isPartitioned() {
        return this.type != TPartitionType.UNPARTITIONED;
    }

    public boolean isBucketShuffleHashPartition() {
        return this.type == TPartitionType.BUCKET_SHFFULE_HASH_PARTITIONED;
    }

    public TPartitionType getType() {
        return this.type;
    }

    public List<Expr> getPartitionExprs() {
        return this.partitionExprs;
    }

    public TDataPartition toThrift() {
        TDataPartition result = new TDataPartition(this.type);
        if (this.partitionExprs != null) {
            result.setPartitionExprs(Expr.treesToThrift(this.partitionExprs));
        }
        return result;
    }

    public boolean isCompatible(DataPartition s) {
        return true;
    }

    public String getExplainString(TExplainLevel explainLevel) {
        StringBuilder str = new StringBuilder();
        str.append(this.type.toString());
        if (explainLevel == TExplainLevel.BRIEF) {
            return str.toString();
        }
        if (!this.partitionExprs.isEmpty()) {
            ArrayList strings = Lists.newArrayList();
            for (Expr expr : this.partitionExprs) {
                strings.add(expr.toSql());
            }
            str.append(": " + Joiner.on((String)", ").join((Iterable)strings));
        }
        str.append("\n");
        return str.toString();
    }
}

