/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.MoreObjects;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.TableRef;
import org.apache.doris.common.CheckedMath;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CrossJoinNode
extends PlanNode {
    private static final Logger LOG = LogManager.getLogger(CrossJoinNode.class);
    private static final long DEFAULT_PER_HOST_MEM = 0x80000000L;
    private final TableRef innerRef_;

    public CrossJoinNode(PlanNodeId id, PlanNode outer, PlanNode inner, TableRef innerRef) {
        super(id, "CROSS JOIN");
        this.innerRef_ = innerRef;
        this.tupleIds.addAll(outer.getTupleIds());
        this.tupleIds.addAll(inner.getTupleIds());
        this.tblRefIds.addAll(outer.getTblRefIds());
        this.tblRefIds.addAll(inner.getTblRefIds());
        this.children.add(outer);
        this.children.add(inner);
        this.nullableTupleIds.addAll(outer.getNullableTupleIds());
        this.nullableTupleIds.addAll(inner.getNullableTupleIds());
    }

    public TableRef getInnerRef() {
        return this.innerRef_;
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        this.assignedConjuncts = analyzer.getAssignedConjuncts();
        this.computeStats(analyzer);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        if (!analyzer.safeIsEnableJoinReorderBasedCost()) {
            return;
        }
        if (((PlanNode)this.getChild((int)0)).cardinality == -1L || ((PlanNode)this.getChild((int)1)).cardinality == -1L) {
            this.cardinality = -1L;
        } else {
            this.cardinality = CheckedMath.checkedMultiply(((PlanNode)this.getChild((int)0)).cardinality, ((PlanNode)this.getChild((int)1)).cardinality);
            this.applyConjunctsSelectivity();
            this.capCardinalityAtLimit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("stats CrossJoin: cardinality={}", (Object)Long.toString(this.cardinality));
        }
    }

    @Override
    protected void computeOldCardinality() {
        if (((PlanNode)this.getChild((int)0)).cardinality == -1L || ((PlanNode)this.getChild((int)1)).cardinality == -1L) {
            this.cardinality = -1L;
        } else {
            this.cardinality = ((PlanNode)this.getChild((int)0)).cardinality * ((PlanNode)this.getChild((int)1)).cardinality;
            if (this.computeOldSelectivity() != -1.0) {
                this.cardinality = Math.round((double)this.cardinality * this.computeOldSelectivity());
            }
        }
        LOG.debug("stats CrossJoin: cardinality={}", (Object)Long.toString(this.cardinality));
    }

    @Override
    protected String debugString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)super.debugString()).toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.CROSS_JOIN_NODE;
    }

    @Override
    public String getNodeExplainString(String detailPrefix, TExplainLevel detailLevel) {
        if (detailLevel == TExplainLevel.BRIEF) {
            return "";
        }
        StringBuilder output = new StringBuilder().append(detailPrefix + "cross join:\n");
        if (!this.conjuncts.isEmpty()) {
            output.append(detailPrefix + "predicates: ").append(this.getExplainString(this.conjuncts) + "\n");
        } else {
            output.append(detailPrefix + "predicates is NULL.");
        }
        output.append(detailPrefix).append(String.format("cardinality=%s", this.cardinality)).append("\n");
        return output.toString();
    }

    @Override
    public int getNumInstances() {
        return Math.max(((PlanNode)this.children.get(0)).getNumInstances(), ((PlanNode)this.children.get(1)).getNumInstances());
    }
}

