/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.List;
import java.util.Optional;
import org.apache.doris.planner.ColumnBound;

public class ColumnRange {
    private boolean hasConjunctiveIsNull;
    private boolean hasDisjunctiveIsNull;
    private RangeSet<ColumnBound> rangeSet;

    private ColumnRange() {
    }

    public void intersect(List<Range<ColumnBound>> disjunctiveRanges) {
        if (disjunctiveRanges != null && !disjunctiveRanges.isEmpty()) {
            if (this.rangeSet == null) {
                this.rangeSet = TreeRangeSet.create();
                disjunctiveRanges.forEach(arg_0 -> this.rangeSet.add(arg_0));
            } else {
                TreeRangeSet merged = TreeRangeSet.create();
                disjunctiveRanges.forEach(arg_0 -> this.lambda$intersect$0((RangeSet)merged, arg_0));
                this.rangeSet = merged;
            }
        }
    }

    public Optional<RangeSet<ColumnBound>> getRangeSet() {
        if (this.rangeSet == null) {
            return Optional.empty();
        }
        return Optional.of(this.rangeSet);
    }

    public static ColumnRange create() {
        return new ColumnRange();
    }

    public boolean hasConjunctiveIsNull() {
        return this.hasConjunctiveIsNull;
    }

    public ColumnRange setHasConjunctiveIsNull(boolean hasConjunctiveIsNull) {
        this.hasConjunctiveIsNull = hasConjunctiveIsNull;
        return this;
    }

    public boolean hasDisjunctiveIsNull() {
        return this.hasDisjunctiveIsNull;
    }

    public ColumnRange setHasDisjunctiveIsNull(boolean hasDisjunctiveIsNull) {
        this.hasDisjunctiveIsNull = hasDisjunctiveIsNull;
        return this;
    }

    public boolean hasFilter() {
        return this.hasConjunctiveIsNull || this.hasDisjunctiveIsNull || this.rangeSet != null;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("hasConjunctiveIsNull", this.hasConjunctiveIsNull).add("hasDisjunctiveIsNull", this.hasDisjunctiveIsNull).add("rangeSet", this.rangeSet).toString();
    }

    private /* synthetic */ void lambda$intersect$0(RangeSet merged, Range range) {
        merged.addAll(this.rangeSet.subRangeSet(range));
    }
}

