/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import org.apache.doris.analysis.LiteralExpr;
import org.apache.doris.catalog.PartitionKey;

public class ColumnBound
implements Comparable<ColumnBound> {
    private final LiteralExpr value;

    private ColumnBound(LiteralExpr value) {
        this.value = value;
    }

    @Override
    public int compareTo(ColumnBound o) {
        return PartitionKey.compareLiteralExpr(this.value, o.value);
    }

    public static ColumnBound of(LiteralExpr expr) {
        return new ColumnBound(expr);
    }

    public LiteralExpr getValue() {
        return this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", (Object)PartitionKey.toString(Lists.newArrayList((Object[])new LiteralExpr[]{this.value}))).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnBound that = (ColumnBound)o;
        return Objects.equal((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }
}

