/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BrokerDesc;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ImportColumnDesc;
import org.apache.doris.analysis.IntLiteral;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.StorageBackend;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.BrokerTable;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.FsBroker;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.Config;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.BrokerUtil;
import org.apache.doris.load.BrokerFileGroup;
import org.apache.doris.load.Load;
import org.apache.doris.load.loadv2.LoadTask;
import org.apache.doris.mysql.privilege.UserProperty;
import org.apache.doris.planner.LoadScanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.qe.ConnectContext;
import org.apache.doris.system.Backend;
import org.apache.doris.system.BeSelectionPolicy;
import org.apache.doris.task.LoadTaskInfo;
import org.apache.doris.thrift.TBrokerFileStatus;
import org.apache.doris.thrift.TBrokerRangeDesc;
import org.apache.doris.thrift.TBrokerScanRange;
import org.apache.doris.thrift.TBrokerScanRangeParams;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TFileFormatType;
import org.apache.doris.thrift.THdfsParams;
import org.apache.doris.thrift.TNetworkAddress;
import org.apache.doris.thrift.TScanRange;
import org.apache.doris.thrift.TScanRangeLocation;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BrokerScanNode
extends LoadScanNode {
    private static final Logger LOG = LogManager.getLogger(BrokerScanNode.class);
    private static final TBrokerFileStatusComparator T_BROKER_FILE_STATUS_COMPARATOR = new TBrokerFileStatusComparator();
    private final Random random = new Random(System.currentTimeMillis());
    private List<TScanRangeLocations> locationsList;
    private long totalBytes;
    private long bytesPerInstance;
    private long loadJobId = -1L;
    private long txnId = -1L;
    protected Table targetTable;
    protected BrokerDesc brokerDesc;
    protected List<BrokerFileGroup> fileGroups;
    private boolean strictMode = false;
    private int loadParallelism = 1;
    private UserIdentity userIdentity;
    protected List<List<TBrokerFileStatus>> fileStatusesList;
    protected int filesAdded;
    private List<Backend> backends;
    private int nextBe = 0;
    private Analyzer analyzer;
    private List<ParamCreateContext> paramCreateContexts;

    public BrokerScanNode(PlanNodeId id, TupleDescriptor destTupleDesc, String planNodeName, List<List<TBrokerFileStatus>> fileStatusesList, int filesAdded) {
        super(id, destTupleDesc, planNodeName);
        this.fileStatusesList = fileStatusesList;
        this.filesAdded = filesAdded;
        if (ConnectContext.get() != null) {
            this.userIdentity = ConnectContext.get().getCurrentUserIdentity();
        }
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        this.analyzer = analyzer;
        if (this.desc.getTable() != null) {
            this.initFileGroup();
        }
        this.assignBackends();
        this.getFileStatusAndCalcInstance();
        this.paramCreateContexts = Lists.newArrayList();
        for (BrokerFileGroup fileGroup : this.fileGroups) {
            ParamCreateContext context = new ParamCreateContext();
            context.fileGroup = fileGroup;
            context.timezone = analyzer.getTimezone();
            this.initParams(context);
            this.paramCreateContexts.add(context);
        }
    }

    protected void initFileGroup() throws UserException {
        BrokerTable brokerTable = (BrokerTable)this.desc.getTable();
        try {
            this.fileGroups = Lists.newArrayList((Object[])new BrokerFileGroup[]{new BrokerFileGroup(brokerTable)});
        }
        catch (AnalysisException e) {
            throw new UserException(e.getMessage());
        }
        this.brokerDesc = new BrokerDesc(brokerTable.getBrokerName(), brokerTable.getBrokerProperties());
        this.targetTable = brokerTable;
    }

    protected boolean isLoad() {
        return this.desc.getTable() == null;
    }

    public void setLoadInfo(long loadJobId, long txnId, Table targetTable, BrokerDesc brokerDesc, List<BrokerFileGroup> fileGroups, boolean strictMode, int loadParallelism, UserIdentity userIdentity) {
        this.loadJobId = loadJobId;
        this.txnId = txnId;
        this.targetTable = targetTable;
        this.brokerDesc = brokerDesc;
        this.fileGroups = fileGroups;
        this.strictMode = strictMode;
        this.loadParallelism = loadParallelism;
        this.userIdentity = userIdentity;
    }

    private void initParams(ParamCreateContext context) throws UserException {
        TBrokerScanRangeParams params;
        context.params = params = new TBrokerScanRangeParams();
        BrokerFileGroup fileGroup = context.fileGroup;
        params.setColumnSeparator(fileGroup.getValueSeparator().getBytes(Charset.forName("UTF-8"))[0]);
        params.setLineDelimiter(fileGroup.getLineDelimiter().getBytes(Charset.forName("UTF-8"))[0]);
        params.setColumnSeparatorStr(fileGroup.getValueSeparator());
        params.setLineDelimiterStr(fileGroup.getLineDelimiter());
        params.setColumnSeparatorLength(fileGroup.getValueSeparator().getBytes(Charset.forName("UTF-8")).length);
        params.setLineDelimiterLength(fileGroup.getLineDelimiter().getBytes(Charset.forName("UTF-8")).length);
        params.setStrictMode(this.strictMode);
        params.setProperties(this.brokerDesc.getProperties());
        this.deleteCondition = fileGroup.getDeleteCondition();
        this.mergeType = fileGroup.getMergeType();
        this.initColumns(context);
        this.initAndSetPrecedingFilter(fileGroup.getPrecedingFilterExpr(), context.srcTupleDescriptor, this.analyzer);
        this.initAndSetWhereExpr(fileGroup.getWhereExpr(), this.desc, this.analyzer);
    }

    private void initColumns(ParamCreateContext context) throws UserException {
        context.srcTupleDescriptor = this.analyzer.getDescTbl().createTupleDescriptor();
        context.slotDescByName = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        context.exprMap = Maps.newTreeMap((Comparator)String.CASE_INSENSITIVE_ORDER);
        LoadTaskInfo.ImportColumnDescs columnDescs = new LoadTaskInfo.ImportColumnDescs();
        if (this.isLoad()) {
            columnDescs.descs = context.fileGroup.getColumnExprList();
            if (this.mergeType == LoadTask.MergeType.MERGE) {
                columnDescs.descs.add(ImportColumnDesc.newDeleteSignImportColumnDesc(this.deleteCondition));
            } else if (this.mergeType == LoadTask.MergeType.DELETE) {
                columnDescs.descs.add(ImportColumnDesc.newDeleteSignImportColumnDesc(new IntLiteral(1L)));
            }
            if (context.fileGroup.hasSequenceCol()) {
                columnDescs.descs.add(new ImportColumnDesc("__DORIS_SEQUENCE_COL__", new SlotRef(null, context.fileGroup.getSequenceCol())));
            }
        }
        Load.initColumns(this.targetTable, columnDescs, context.fileGroup.getColumnToHadoopFunction(), context.exprMap, this.analyzer, context.srcTupleDescriptor, context.slotDescByName, context.params);
    }

    private TScanRangeLocations newLocations(TBrokerScanRangeParams params, BrokerDesc brokerDesc) throws UserException {
        Backend selectedBackend;
        if (brokerDesc.isMultiLoadBroker()) {
            if (!brokerDesc.getProperties().containsKey("__DORIS_MULTI_LOAD_BROKER_BACKEND__")) {
                throw new DdlException("backend not found for multi load.");
            }
            String backendId = brokerDesc.getProperties().get("__DORIS_MULTI_LOAD_BROKER_BACKEND__");
            selectedBackend = Catalog.getCurrentSystemInfo().getBackend(Long.valueOf(backendId));
            if (selectedBackend == null) {
                throw new DdlException("backend " + backendId + " not found for multi load.");
            }
        } else {
            selectedBackend = this.backends.get(this.nextBe++);
            this.nextBe %= this.backends.size();
        }
        TBrokerScanRange brokerScanRange = new TBrokerScanRange();
        brokerScanRange.setParams(params);
        if (brokerDesc.getStorageType() == StorageBackend.StorageType.BROKER) {
            FsBroker broker = null;
            try {
                broker = Catalog.getCurrentCatalog().getBrokerMgr().getBroker(brokerDesc.getName(), selectedBackend.getHost());
            }
            catch (AnalysisException e) {
                throw new UserException(e.getMessage());
            }
            brokerScanRange.addToBrokerAddresses(new TNetworkAddress(broker.ip, broker.port));
        } else {
            brokerScanRange.setBrokerAddresses(new ArrayList());
        }
        TScanRange scanRange = new TScanRange();
        scanRange.setBrokerScanRange(brokerScanRange);
        TScanRangeLocations locations = new TScanRangeLocations();
        locations.setScanRange(scanRange);
        TScanRangeLocation location = new TScanRangeLocation();
        location.setBackendId(selectedBackend.getId());
        location.setServer(new TNetworkAddress(selectedBackend.getHost(), selectedBackend.getBePort()));
        locations.addToLocations(location);
        return locations;
    }

    private TBrokerScanRange brokerScanRange(TScanRangeLocations locations) {
        return locations.scan_range.broker_scan_range;
    }

    private void getFileStatusAndCalcInstance() throws UserException {
        if (this.fileStatusesList == null || this.filesAdded == -1) {
            this.fileStatusesList = Lists.newArrayList();
            this.filesAdded = 0;
            this.getFileStatus();
        }
        Preconditions.checkState((this.fileStatusesList.size() == this.fileGroups.size() ? 1 : 0) != 0);
        if (this.isLoad() && this.filesAdded == 0) {
            throw new UserException("No source file in this table(" + this.targetTable.getName() + ").");
        }
        this.totalBytes = 0L;
        for (List<TBrokerFileStatus> fileStatuses : this.fileStatusesList) {
            if (!this.brokerDesc.isMultiLoadBroker()) {
                Collections.sort(fileStatuses, T_BROKER_FILE_STATUS_COMPARATOR);
            }
            for (TBrokerFileStatus fileStatus : fileStatuses) {
                this.totalBytes += fileStatus.size;
            }
        }
        this.numInstances = 1;
        if (!this.brokerDesc.isMultiLoadBroker()) {
            this.numInstances = (int)(this.totalBytes / Config.min_bytes_per_broker_scanner);
            int totalLoadParallelism = this.loadParallelism * this.backends.size();
            this.numInstances = Math.min(totalLoadParallelism, this.numInstances);
            this.numInstances = Math.min(this.numInstances, Config.max_broker_concurrency);
            this.numInstances = Math.max(1, this.numInstances);
        }
        this.bytesPerInstance = this.totalBytes / (long)this.numInstances + 1L;
        if (this.bytesPerInstance > Config.max_bytes_per_broker_scanner) {
            throw new UserException("Scan bytes per broker scanner exceed limit: " + Config.max_bytes_per_broker_scanner);
        }
        LOG.info("number instance of broker scan node is: {}, bytes per instance: {}", (Object)this.numInstances, (Object)this.bytesPerInstance);
    }

    protected void getFileStatus() throws UserException {
        for (BrokerFileGroup fileGroup : this.fileGroups) {
            boolean isBinaryFileFormat = fileGroup.isBinaryFileFormat();
            List<Object> fileStatuses = Lists.newArrayList();
            for (int i = 0; i < fileGroup.getFilePaths().size(); ++i) {
                if (this.brokerDesc.isMultiLoadBroker()) {
                    TBrokerFileStatus tBrokerFileStatus = new TBrokerFileStatus(fileGroup.getFilePaths().get(i), false, fileGroup.getFileSize().get(i).longValue(), false);
                    fileStatuses.add(tBrokerFileStatus);
                    continue;
                }
                BrokerUtil.parseFile(fileGroup.getFilePaths().get(i), this.brokerDesc, (List<TBrokerFileStatus>)fileStatuses);
            }
            fileStatuses = fileStatuses.stream().filter(f -> f.getSize() > 0L || !isBinaryFileFormat).collect(Collectors.toList());
            this.fileStatusesList.add((List<TBrokerFileStatus>)fileStatuses);
            this.filesAdded += fileStatuses.size();
            for (TBrokerFileStatus tBrokerFileStatus : fileStatuses) {
                LOG.info("Add file status is {}", (Object)tBrokerFileStatus);
            }
        }
    }

    private void assignBackends() throws UserException {
        Set<Object> tags = Sets.newHashSet();
        if (this.userIdentity != null) {
            tags = Catalog.getCurrentCatalog().getAuth().getResourceTags(this.userIdentity.getQualifiedUser());
            if (tags == UserProperty.INVALID_RESOURCE_TAGS) {
                throw new UserException("No valid resource tag for user: " + this.userIdentity.getQualifiedUser());
            }
        } else {
            LOG.debug("user info in BrokerScanNode should not be null, add log to observer");
        }
        this.backends = Lists.newArrayList();
        BeSelectionPolicy policy = new BeSelectionPolicy.Builder().needQueryAvailable().needLoadAvailable().addTags(tags).build();
        for (Backend be : Catalog.getCurrentSystemInfo().getIdToBackend().values()) {
            if (!policy.isMatch(be)) continue;
            this.backends.add(be);
        }
        if (this.backends.isEmpty()) {
            throw new UserException("No available backends");
        }
        Collections.shuffle(this.backends, this.random);
    }

    private TFileFormatType formatType(String fileFormat, String path) throws UserException {
        if (fileFormat != null) {
            if (fileFormat.toLowerCase().equals("parquet")) {
                return TFileFormatType.FORMAT_PARQUET;
            }
            if (fileFormat.toLowerCase().equals("orc")) {
                return TFileFormatType.FORMAT_ORC;
            }
            if (fileFormat.toLowerCase().equals("json")) {
                return TFileFormatType.FORMAT_JSON;
            }
            if (fileFormat.toLowerCase().equals(FeConstants.csv) || fileFormat.toLowerCase().equals(FeConstants.text)) {
                return TFileFormatType.FORMAT_CSV_PLAIN;
            }
            throw new UserException("Not supported file format: " + fileFormat);
        }
        String lowerCasePath = path.toLowerCase();
        if (lowerCasePath.endsWith(".parquet") || lowerCasePath.endsWith(".parq")) {
            return TFileFormatType.FORMAT_PARQUET;
        }
        if (lowerCasePath.endsWith(".gz")) {
            return TFileFormatType.FORMAT_CSV_GZ;
        }
        if (lowerCasePath.endsWith(".bz2")) {
            return TFileFormatType.FORMAT_CSV_BZ2;
        }
        if (lowerCasePath.endsWith(".lz4")) {
            return TFileFormatType.FORMAT_CSV_LZ4FRAME;
        }
        if (lowerCasePath.endsWith(".lzo")) {
            return TFileFormatType.FORMAT_CSV_LZOP;
        }
        if (lowerCasePath.endsWith(".deflate")) {
            return TFileFormatType.FORMAT_CSV_DEFLATE;
        }
        return TFileFormatType.FORMAT_CSV_PLAIN;
    }

    public String getHostUri() throws UserException {
        return "";
    }

    private void processFileGroup(ParamCreateContext context, List<TBrokerFileStatus> fileStatuses) throws UserException {
        if (fileStatuses == null || fileStatuses.isEmpty()) {
            return;
        }
        THdfsParams tHdfsParams = new THdfsParams();
        String fsName = this.getHostUri();
        tHdfsParams.setFsName(fsName);
        TScanRangeLocations curLocations = this.newLocations(context.params, this.brokerDesc);
        long curInstanceBytes = 0L;
        long curFileOffset = 0L;
        int i = 0;
        while (i < fileStatuses.size()) {
            TBrokerFileStatus fileStatus = fileStatuses.get(i);
            long leftBytes = fileStatus.size - curFileOffset;
            long tmpBytes = curInstanceBytes + leftBytes;
            TFileFormatType formatType = this.formatType(context.fileGroup.getFileFormat(), fileStatus.path);
            List<String> columnsFromPath = BrokerUtil.parseColumnsFromPath(fileStatus.path, context.fileGroup.getColumnsFromPath());
            int numberOfColumnsFromFile = context.slotDescByName.size() - columnsFromPath.size();
            if (tmpBytes > this.bytesPerInstance) {
                if (formatType == TFileFormatType.FORMAT_CSV_PLAIN && fileStatus.isSplitable || formatType == TFileFormatType.FORMAT_JSON) {
                    long rangeBytes = this.bytesPerInstance - curInstanceBytes;
                    TBrokerRangeDesc rangeDesc = this.createBrokerRangeDesc(curFileOffset, fileStatus, formatType, rangeBytes, columnsFromPath, numberOfColumnsFromFile, this.brokerDesc);
                    if (formatType == TFileFormatType.FORMAT_JSON) {
                        rangeDesc.setStripOuterArray(context.fileGroup.isStripOuterArray());
                        rangeDesc.setJsonpaths(context.fileGroup.getJsonPaths());
                        rangeDesc.setJsonRoot(context.fileGroup.getJsonRoot());
                        rangeDesc.setFuzzyParse(context.fileGroup.isFuzzyParse());
                        rangeDesc.setNumAsString(context.fileGroup.isNumAsString());
                        rangeDesc.setReadJsonByLine(context.fileGroup.isReadJsonByLine());
                    }
                    this.brokerScanRange(curLocations).addToRanges(rangeDesc);
                    curFileOffset += rangeBytes;
                } else {
                    TBrokerRangeDesc rangeDesc = this.createBrokerRangeDesc(curFileOffset, fileStatus, formatType, leftBytes, columnsFromPath, numberOfColumnsFromFile, this.brokerDesc);
                    if (rangeDesc.hdfs_params != null && rangeDesc.hdfs_params.getFsName() == null) {
                        rangeDesc.hdfs_params.setFsName(fsName);
                    } else if (rangeDesc.hdfs_params == null) {
                        rangeDesc.setHdfsParams(tHdfsParams);
                    }
                    rangeDesc.setReadByColumnDef(true);
                    this.brokerScanRange(curLocations).addToRanges(rangeDesc);
                    curFileOffset = 0L;
                    ++i;
                }
                this.locationsList.add(curLocations);
                curLocations = this.newLocations(context.params, this.brokerDesc);
                curInstanceBytes = 0L;
                continue;
            }
            TBrokerRangeDesc rangeDesc = this.createBrokerRangeDesc(curFileOffset, fileStatus, formatType, leftBytes, columnsFromPath, numberOfColumnsFromFile, this.brokerDesc);
            if (formatType == TFileFormatType.FORMAT_JSON) {
                rangeDesc.setStripOuterArray(context.fileGroup.isStripOuterArray());
                rangeDesc.setJsonpaths(context.fileGroup.getJsonPaths());
                rangeDesc.setJsonRoot(context.fileGroup.getJsonRoot());
                rangeDesc.setFuzzyParse(context.fileGroup.isFuzzyParse());
                rangeDesc.setNumAsString(context.fileGroup.isNumAsString());
                rangeDesc.setReadJsonByLine(context.fileGroup.isReadJsonByLine());
            }
            if (rangeDesc.hdfs_params != null && rangeDesc.hdfs_params.getFsName() == null) {
                rangeDesc.hdfs_params.setFsName(fsName);
            } else if (rangeDesc.hdfs_params == null) {
                rangeDesc.setHdfsParams(tHdfsParams);
            }
            rangeDesc.setReadByColumnDef(true);
            this.brokerScanRange(curLocations).addToRanges(rangeDesc);
            curFileOffset = 0L;
            curInstanceBytes += leftBytes;
            ++i;
        }
        if (this.brokerScanRange(curLocations).isSetRanges()) {
            this.locationsList.add(curLocations);
        }
    }

    private TBrokerRangeDesc createBrokerRangeDesc(long curFileOffset, TBrokerFileStatus fileStatus, TFileFormatType formatType, long rangeBytes, List<String> columnsFromPath, int numberOfColumnsFromFile, BrokerDesc brokerDesc) {
        TBrokerRangeDesc rangeDesc = new TBrokerRangeDesc();
        rangeDesc.setFileType(brokerDesc.getFileType());
        rangeDesc.setFormatType(formatType);
        rangeDesc.setPath(fileStatus.path);
        rangeDesc.setSplittable(fileStatus.isSplitable);
        rangeDesc.setStartOffset(curFileOffset);
        rangeDesc.setSize(rangeBytes);
        rangeDesc.setFileSize(fileStatus.size);
        rangeDesc.setNumOfColumnsFromFile(numberOfColumnsFromFile);
        rangeDesc.setColumnsFromPath(columnsFromPath);
        switch (brokerDesc.getFileType()) {
            case FILE_HDFS: {
                BrokerUtil.generateHdfsParam(brokerDesc.getProperties(), rangeDesc);
            }
        }
        return rangeDesc;
    }

    @Override
    public void finalize(Analyzer analyzer) throws UserException {
        this.locationsList = Lists.newArrayList();
        for (int i = 0; i < this.fileGroups.size(); ++i) {
            List<TBrokerFileStatus> fileStatuses = this.fileStatusesList.get(i);
            if (fileStatuses.isEmpty()) continue;
            ParamCreateContext context = this.paramCreateContexts.get(i);
            try {
                this.finalizeParams(context.slotDescByName, context.exprMap, context.params, context.srcTupleDescriptor, this.strictMode, context.fileGroup.isNegative(), analyzer);
            }
            catch (AnalysisException e) {
                throw new UserException(e.getMessage());
            }
            this.processFileGroup(context, fileStatuses);
        }
        if (LOG.isDebugEnabled()) {
            for (TScanRangeLocations locations : this.locationsList) {
                LOG.debug("Scan range is {}", (Object)locations);
            }
        }
        if (this.loadJobId != -1L) {
            LOG.info("broker load job {} with txn {} has {} scan range: {}", (Object)this.loadJobId, (Object)this.txnId, (Object)this.locationsList.size(), (Object)(this.brokerDesc.isMultiLoadBroker() ? "local" : this.locationsList.stream().map(loc -> ((TScanRangeLocation)loc.locations.get((int)0)).backend_id).toArray()));
        }
    }

    @Override
    public List<TScanRangeLocations> getScanRangeLocations(long maxScanRangeLength) {
        return this.locationsList;
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        if (!this.isLoad()) {
            BrokerTable brokerTable = (BrokerTable)this.targetTable;
            output.append(prefix).append("TABLE: ").append(brokerTable.getName()).append("\n");
            if (detailLevel != TExplainLevel.BRIEF) {
                output.append(prefix).append("PATH: ").append(Joiner.on((String)",").join(brokerTable.getPaths())).append("\",\n");
            }
        }
        output.append(prefix).append("BROKER: ").append(this.brokerDesc.getName()).append("\n");
        return output.toString();
    }

    private static class ParamCreateContext {
        public BrokerFileGroup fileGroup;
        public TBrokerScanRangeParams params;
        public TupleDescriptor srcTupleDescriptor;
        public Map<String, Expr> exprMap;
        public Map<String, SlotDescriptor> slotDescByName;
        public String timezone;

        private ParamCreateContext() {
        }
    }

    public static class TBrokerFileStatusComparator
    implements Comparator<TBrokerFileStatus> {
        @Override
        public int compare(TBrokerFileStatus o1, TBrokerFileStatus o2) {
            if (o1.size < o2.size) {
                return -1;
            }
            if (o1.size > o2.size) {
                return 1;
            }
            return 0;
        }
    }
}

