/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.AssertNumRowsElement;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TAssertNumRowsNode;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AssertNumRowsNode
extends PlanNode {
    private static final Logger LOG = LogManager.getLogger(AssertNumRowsNode.class);
    private long desiredNumOfRows;
    private String subqueryString;
    private AssertNumRowsElement.Assertion assertion;

    public AssertNumRowsNode(PlanNodeId id, PlanNode input, AssertNumRowsElement assertNumRowsElement) {
        super(id, "ASSERT NUMBER OF ROWS");
        this.desiredNumOfRows = assertNumRowsElement.getDesiredNumOfRows();
        this.subqueryString = assertNumRowsElement.getSubqueryString();
        this.assertion = assertNumRowsElement.getAssertion();
        this.children.add(input);
        this.tupleIds.addAll(input.getTupleIds());
        this.tblRefIds.addAll(input.getTblRefIds());
        this.nullableTupleIds.addAll(input.getNullableTupleIds());
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        super.init(analyzer);
        super.computeStats(analyzer);
        if (analyzer.safeIsEnableJoinReorderBasedCost()) {
            this.cardinality = 1L;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("stats AssertNumRows: cardinality={}", (Object)this.cardinality);
        }
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        if (detailLevel == TExplainLevel.BRIEF) {
            return "";
        }
        StringBuilder output = new StringBuilder().append(prefix + "assert number of rows: ").append((Object)this.assertion).append(" ").append(this.desiredNumOfRows).append("\n");
        return output.toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.ASSERT_NUM_ROWS_NODE;
        msg.assert_num_rows_node = new TAssertNumRowsNode();
        msg.assert_num_rows_node.setDesiredNumRows(this.desiredNumOfRows);
        msg.assert_num_rows_node.setSubqueryString(this.subqueryString);
        msg.assert_num_rows_node.setAssertion(this.assertion.toThrift());
    }
}

