/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.doris.analysis.AnalyticExpr;
import org.apache.doris.analysis.AnalyticInfo;
import org.apache.doris.analysis.AnalyticWindow;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.BinaryPredicate;
import org.apache.doris.analysis.BoolLiteral;
import org.apache.doris.analysis.CompoundPredicate;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.IsNullPredicate;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.SlotDescriptor;
import org.apache.doris.analysis.SlotRef;
import org.apache.doris.analysis.SortInfo;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.analysis.TupleIsNullPredicate;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.AnalyticEvalNode;
import org.apache.doris.planner.DataPartition;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlannerContext;
import org.apache.doris.planner.SortNode;
import org.apache.doris.thrift.TPartitionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticPlanner {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticPlanner.class);
    private final AnalyticInfo analyticInfo;
    private final Analyzer analyzer;
    private final PlannerContext ctx_;

    public AnalyticPlanner(AnalyticInfo analyticInfo, Analyzer analyzer, PlannerContext ctx) {
        this.analyticInfo = analyticInfo;
        this.analyzer = analyzer;
        this.ctx_ = ctx;
    }

    public PlanNode createSingleNodePlan(PlanNode root, List<Expr> groupingExprs, List<Expr> inputPartitionExprs) throws AnalysisException, UserException {
        List<WindowGroup> windowGroups = this.collectWindowGroups();
        for (int i = 0; i < windowGroups.size(); ++i) {
            windowGroups.get(i).init(this.analyzer, "wg-" + i);
        }
        List<SortGroup> sortGroups = this.collectSortGroups(windowGroups);
        this.mergeSortGroups(sortGroups);
        for (SortGroup g : sortGroups) {
            g.init();
        }
        List<PartitionGroup> partitionGroups = this.collectPartitionGroups(sortGroups);
        this.mergePartitionGroups(partitionGroups, root.getNumNodes());
        this.orderGroups(partitionGroups);
        if (groupingExprs != null) {
            Preconditions.checkNotNull(inputPartitionExprs);
            this.computeInputPartitionExprs(partitionGroups, groupingExprs, root.getNumNodes(), inputPartitionExprs);
        }
        PlanNode newRoot = root;
        for (PartitionGroup partitionGroup : partitionGroups) {
            for (int i = 0; i < partitionGroup.sortGroups.size(); ++i) {
                newRoot = this.createSortGroupPlan(newRoot, partitionGroup.sortGroups.get(i), i == 0 ? partitionGroup.partitionByExprs : null);
            }
        }
        return newRoot;
    }

    private void mergeSortGroups(List<SortGroup> sortGroups) {
        boolean hasMerged = false;
        block0: do {
            hasMerged = false;
            for (SortGroup sg1 : sortGroups) {
                for (SortGroup sg2 : sortGroups) {
                    if (sg1 == sg2 || !sg1.isPrefixOf(sg2)) continue;
                    sg1.absorb(sg2);
                    sortGroups.remove(sg2);
                    hasMerged = true;
                    break;
                }
                if (!hasMerged) continue;
                continue block0;
            }
        } while (hasMerged);
    }

    private void mergePartitionGroups(List<PartitionGroup> partitionGroups, int numNodes) {
        boolean hasMerged = false;
        block0: do {
            hasMerged = false;
            for (PartitionGroup pg1 : partitionGroups) {
                for (PartitionGroup pg2 : partitionGroups) {
                    long ndv;
                    if (pg1 == pg2 || (ndv = Expr.getNumDistinctValues(Expr.intersect(pg1.partitionByExprs, pg2.partitionByExprs))) == -1L || ndv < 1L || ndv < (long)numNodes) continue;
                    pg1.merge(pg2);
                    partitionGroups.remove(pg2);
                    hasMerged = true;
                    break;
                }
                if (!hasMerged) continue;
                continue block0;
            }
        } while (hasMerged);
    }

    private void computeInputPartitionExprs(List<PartitionGroup> partitionGroups, List<Expr> groupingExprs, int numNodes, List<Expr> inputPartitionExprs) throws AnalysisException {
        inputPartitionExprs.clear();
        long maxNdv = 0L;
        PartitionGroup maxPg = null;
        ArrayList maxGroupingExprs = null;
        for (PartitionGroup pg : partitionGroups) {
            ArrayList l1 = Lists.newArrayList();
            ArrayList l2 = Lists.newArrayList();
            Expr.intersect(this.analyzer, pg.partitionByExprs, groupingExprs, null, l1, l2);
            long ndv = Expr.getNumDistinctValues(l1);
            if (ndv < 1L || ndv < (long)numNodes || ndv < maxNdv) continue;
            maxPg = pg;
            maxPg.partitionByExprs = l1;
            maxGroupingExprs = l2;
            maxNdv = ndv;
        }
        if (maxNdv > (long)numNodes) {
            Preconditions.checkNotNull(maxPg);
            partitionGroups.remove(maxPg);
            partitionGroups.add(0, maxPg);
            inputPartitionExprs.addAll(maxGroupingExprs);
        }
    }

    private void orderGroups(List<PartitionGroup> partitionGroups) {
        PartitionGroup nonPartitioning = null;
        for (PartitionGroup pg : partitionGroups) {
            if (!pg.partitionByExprs.isEmpty()) continue;
            nonPartitioning = pg;
            break;
        }
        if (nonPartitioning != null) {
            partitionGroups.remove(nonPartitioning);
        }
        Collections.sort(partitionGroups, new Comparator<PartitionGroup>(){

            @Override
            public int compare(PartitionGroup pg1, PartitionGroup pg2) {
                Preconditions.checkState((pg1.totalOutputTupleSize > 0 ? 1 : 0) != 0);
                Preconditions.checkState((pg2.totalOutputTupleSize > 0 ? 1 : 0) != 0);
                int diff = pg1.totalOutputTupleSize - pg2.totalOutputTupleSize;
                return diff < 0 ? -1 : (diff > 0 ? 1 : 0);
            }
        });
        if (nonPartitioning != null) {
            partitionGroups.add(nonPartitioning);
        }
        for (PartitionGroup pg : partitionGroups) {
            pg.orderSortGroups();
        }
    }

    private SortInfo createSortInfo(PlanNode input, List<Expr> sortExprs, List<Boolean> isAsc, List<Boolean> nullsFirst) throws AnalysisException {
        TupleDescriptor sortTupleDesc = this.analyzer.getDescTbl().createTupleDescriptor("sort-tuple");
        ExprSubstitutionMap sortSmap = new ExprSubstitutionMap();
        ArrayList sortSlotExprs = Lists.newArrayList();
        sortTupleDesc.setIsMaterialized(true);
        for (TupleId tid : input.getTupleIds()) {
            TupleDescriptor tupleDesc = this.analyzer.getTupleDesc(tid);
            for (SlotDescriptor inputSlotDesc : tupleDesc.getSlots()) {
                if (!inputSlotDesc.isMaterialized()) continue;
                SlotDescriptor sortSlotDesc = this.analyzer.getDescTbl().addSlotDescriptor(sortTupleDesc);
                if (inputSlotDesc.getColumn() != null) {
                    sortSlotDesc.setColumn(inputSlotDesc.getColumn());
                } else {
                    sortSlotDesc.setType(inputSlotDesc.getType());
                }
                sortSlotDesc.setIsMaterialized(true);
                sortSlotDesc.setIsNullable(inputSlotDesc.getIsNullable());
                sortSmap.put(new SlotRef(inputSlotDesc), new SlotRef(sortSlotDesc));
                sortSlotExprs.add(new SlotRef(inputSlotDesc));
            }
        }
        ExprSubstitutionMap inputSmap = input.getOutputSmap();
        if (inputSmap != null) {
            ArrayList tupleIsNullPredsToMaterialize = Lists.newArrayList();
            for (int i = 0; i < inputSmap.size(); ++i) {
                Expr rhsExpr = inputSmap.getRhs().get(i);
                if (!rhsExpr.isBoundByTupleIds(input.getTupleIds())) continue;
                rhsExpr.collect(TupleIsNullPredicate.class, tupleIsNullPredsToMaterialize);
            }
            Expr.removeDuplicates(tupleIsNullPredsToMaterialize);
            for (Expr tupleIsNullPred : tupleIsNullPredsToMaterialize) {
                SlotDescriptor sortSlotDesc = this.analyzer.addSlotDescriptor(sortTupleDesc);
                sortSlotDesc.setType(tupleIsNullPred.getType());
                sortSlotDesc.setIsMaterialized(true);
                sortSlotDesc.setSourceExpr(tupleIsNullPred);
                sortSlotDesc.setLabel(tupleIsNullPred.toSql());
                sortSlotExprs.add(tupleIsNullPred.clone());
            }
        }
        SortInfo sortInfo = new SortInfo(sortExprs, isAsc, nullsFirst);
        ExprSubstitutionMap smap = sortInfo.createMaterializedOrderExprs(sortTupleDesc, this.analyzer);
        sortSlotExprs.addAll(smap.getLhs());
        sortSmap = ExprSubstitutionMap.combine(sortSmap, smap);
        sortInfo.substituteOrderingExprs(sortSmap, this.analyzer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sortinfo exprs: " + Expr.debugString(sortInfo.getOrderingExprs()));
        }
        sortInfo.setMaterializedTupleInfo(sortTupleDesc, sortSlotExprs);
        return sortInfo;
    }

    private PlanNode createSortGroupPlan(PlanNode root, SortGroup sortGroup, List<Expr> partitionExprs) throws AnalysisException, UserException {
        List<Expr> partitionByExprs = sortGroup.partitionByExprs;
        List<OrderByElement> orderByElements = sortGroup.orderByElements;
        ExprSubstitutionMap sortSmap = null;
        TupleId sortTupleId = null;
        TupleDescriptor bufferedTupleDesc = null;
        ExprSubstitutionMap bufferedSmap = new ExprSubstitutionMap();
        PlanNode newRoot = root;
        if (!partitionByExprs.isEmpty() || !orderByElements.isEmpty()) {
            ArrayList sortExprs = Lists.newArrayList(partitionByExprs);
            ArrayList isAsc = Lists.newArrayList(Collections.nCopies(sortExprs.size(), Boolean.TRUE));
            ArrayList nullsFirst = Lists.newArrayList(Collections.nCopies(sortExprs.size(), Boolean.FALSE));
            for (OrderByElement orderByElement : sortGroup.orderByElements) {
                sortExprs.add(orderByElement.getExpr());
                isAsc.add(orderByElement.getIsAsc());
                nullsFirst.add(orderByElement.getNullsFirstParam());
            }
            SortInfo sortInfo = this.createSortInfo(newRoot, sortExprs, isAsc, nullsFirst);
            SortNode sortNode = new SortNode(this.ctx_.getNextNodeId(), newRoot, sortInfo, false, false, 0L);
            if (!partitionByExprs.isEmpty()) {
                sortNode.setIsAnalyticSort(true);
            }
            if (partitionExprs != null) {
                DataPartition inputPartition = DataPartition.UNPARTITIONED;
                if (!partitionExprs.isEmpty()) {
                    inputPartition = new DataPartition(TPartitionType.HASH_PARTITIONED, partitionExprs);
                }
                sortNode.setInputPartition(inputPartition);
            }
            sortNode.init(this.analyzer);
            newRoot = sortNode;
            sortSmap = sortNode.getOutputSmap();
            sortTupleId = (TupleId)sortNode.tupleIds.get(0);
            bufferedTupleDesc = this.analyzer.getDescTbl().copyTupleDescriptor(sortTupleId, "buffered-tuple");
            LOG.trace("desctbl: " + this.analyzer.getDescTbl().debugString());
            ArrayList<SlotDescriptor> inputSlots = this.analyzer.getTupleDesc(sortTupleId).getSlots();
            ArrayList<SlotDescriptor> bufferedSlots = bufferedTupleDesc.getSlots();
            for (int i = 0; i < inputSlots.size(); ++i) {
                bufferedSmap.put(new SlotRef((SlotDescriptor)inputSlots.get(i)), new SlotRef((SlotDescriptor)bufferedSlots.get(i)));
            }
        }
        for (WindowGroup windowGroup : sortGroup.windowGroups) {
            Expr partitionByEq = null;
            if (!windowGroup.partitionByExprs.isEmpty()) {
                partitionByEq = this.createNullMatchingEquals(Expr.trySubstituteList(windowGroup.partitionByExprs, sortSmap, this.analyzer, false), sortTupleId, bufferedSmap);
                LOG.trace("partitionByEq: " + partitionByEq.debugString());
            }
            Expr orderByEq = null;
            if (!windowGroup.orderByElements.isEmpty()) {
                orderByEq = this.createNullMatchingEquals(OrderByElement.getOrderByExprs(OrderByElement.substitute(windowGroup.orderByElements, sortSmap, this.analyzer)), sortTupleId, bufferedSmap);
                LOG.trace("orderByEq: " + orderByEq.debugString());
            }
            AnalyticEvalNode node = new AnalyticEvalNode(this.ctx_.getNextNodeId(), newRoot, windowGroup.analyticFnCalls, windowGroup.partitionByExprs, windowGroup.orderByElements, windowGroup.window, windowGroup.physicalIntermediateTuple, windowGroup.physicalOutputTuple, windowGroup.logicalToPhysicalSmap, partitionByEq, orderByEq, bufferedTupleDesc);
            node.init(this.analyzer);
            newRoot = node;
        }
        return newRoot;
    }

    private Expr createNullMatchingEquals(List<Expr> exprs, TupleId inputTid, ExprSubstitutionMap bufferedSmap) throws AnalysisException {
        Preconditions.checkState((!exprs.isEmpty() ? 1 : 0) != 0);
        Expr result = this.createNullMatchingEqualsAux(exprs, 0, inputTid, bufferedSmap);
        result.analyze(this.analyzer);
        return result;
    }

    private Expr createNullMatchingEqualsAux(List<Expr> elements, int i, TupleId inputTid, ExprSubstitutionMap bufferedSmap) throws AnalysisException {
        if (i > elements.size() - 1) {
            return new BoolLiteral(true);
        }
        Expr lhs = elements.get(i);
        Preconditions.checkState((boolean)lhs.isBound(inputTid));
        Expr rhs = lhs.trySubstitute(bufferedSmap, this.analyzer, false);
        CompoundPredicate bothNull = new CompoundPredicate(CompoundPredicate.Operator.AND, new IsNullPredicate(lhs, false), new IsNullPredicate(rhs, false));
        CompoundPredicate lhsEqRhsNotNull = new CompoundPredicate(CompoundPredicate.Operator.AND, new CompoundPredicate(CompoundPredicate.Operator.AND, new IsNullPredicate(lhs, true), new IsNullPredicate(rhs, true)), new BinaryPredicate(BinaryPredicate.Operator.EQ, lhs, rhs));
        Expr remainder = this.createNullMatchingEqualsAux(elements, i + 1, inputTid, bufferedSmap);
        return new CompoundPredicate(CompoundPredicate.Operator.AND, new CompoundPredicate(CompoundPredicate.Operator.OR, bothNull, lhsEqRhsNotNull), remainder);
    }

    private List<WindowGroup> collectWindowGroups() {
        ArrayList<Expr> analyticExprs = this.analyticInfo.getAnalyticExprs();
        ArrayList groups = Lists.newArrayList();
        for (int i = 0; i < analyticExprs.size(); ++i) {
            AnalyticExpr analyticExpr = (AnalyticExpr)analyticExprs.get(i);
            if (!this.analyticInfo.getOutputTupleDesc().getSlots().get(i).isMaterialized()) continue;
            boolean match = false;
            for (WindowGroup group : groups) {
                if (!group.isCompatible(analyticExpr)) continue;
                group.add((AnalyticExpr)this.analyticInfo.getAnalyticExprs().get(i), this.analyticInfo.getOutputTupleDesc().getSlots().get(i), this.analyticInfo.getIntermediateTupleDesc().getSlots().get(i));
                match = true;
                break;
            }
            if (match) continue;
            groups.add(new WindowGroup((AnalyticExpr)this.analyticInfo.getAnalyticExprs().get(i), this.analyticInfo.getOutputTupleDesc().getSlots().get(i), this.analyticInfo.getIntermediateTupleDesc().getSlots().get(i)));
        }
        return groups;
    }

    private List<SortGroup> collectSortGroups(List<WindowGroup> windowGroups) {
        ArrayList sortGroups = Lists.newArrayList();
        for (WindowGroup windowGroup : windowGroups) {
            boolean match = false;
            for (SortGroup sortGroup : sortGroups) {
                if (!sortGroup.isCompatible(windowGroup)) continue;
                sortGroup.add(windowGroup);
                match = true;
                break;
            }
            if (match) continue;
            sortGroups.add(new SortGroup(windowGroup));
        }
        return sortGroups;
    }

    private List<PartitionGroup> collectPartitionGroups(List<SortGroup> sortGroups) {
        ArrayList partitionGroups = Lists.newArrayList();
        for (SortGroup sortGroup : sortGroups) {
            boolean match = false;
            for (PartitionGroup partitionGroup : partitionGroups) {
                if (!partitionGroup.isCompatible(sortGroup)) continue;
                partitionGroup.add(sortGroup);
                match = true;
                break;
            }
            if (match) continue;
            partitionGroups.add(new PartitionGroup(sortGroup));
        }
        return partitionGroups;
    }

    private static class PartitionGroup {
        public List<Expr> partitionByExprs;
        public List<SortGroup> sortGroups = Lists.newArrayList();
        public int totalOutputTupleSize = -1;

        public PartitionGroup(SortGroup sortGroup) {
            this.partitionByExprs = sortGroup.partitionByExprs;
            this.sortGroups.add(sortGroup);
            this.totalOutputTupleSize = sortGroup.totalOutputTupleSize;
        }

        public boolean isCompatible(SortGroup sortGroup) {
            return Expr.equalSets(sortGroup.partitionByExprs, this.partitionByExprs);
        }

        public void add(SortGroup sortGroup) {
            Preconditions.checkState((boolean)this.isCompatible(sortGroup));
            this.sortGroups.add(sortGroup);
            this.totalOutputTupleSize += sortGroup.totalOutputTupleSize;
        }

        public void merge(PartitionGroup other) {
            this.partitionByExprs = Expr.intersect(this.partitionByExprs, other.partitionByExprs);
            Preconditions.checkState((Expr.getNumDistinctValues(this.partitionByExprs) >= 0L ? 1 : 0) != 0);
            this.sortGroups.addAll(other.sortGroups);
        }

        public void orderSortGroups() {
            Collections.sort(this.sortGroups, new Comparator<SortGroup>(){

                @Override
                public int compare(SortGroup sg1, SortGroup sg2) {
                    Preconditions.checkState((sg1.totalOutputTupleSize > 0 ? 1 : 0) != 0);
                    Preconditions.checkState((sg2.totalOutputTupleSize > 0 ? 1 : 0) != 0);
                    int diff = sg1.totalOutputTupleSize - sg2.totalOutputTupleSize;
                    return diff < 0 ? -1 : (diff > 0 ? 1 : 0);
                }
            });
            for (SortGroup sortGroup : this.sortGroups) {
                sortGroup.orderWindowGroups();
            }
        }
    }

    private static class SortGroup {
        public List<Expr> partitionByExprs;
        public List<OrderByElement> orderByElements;
        public List<WindowGroup> windowGroups = Lists.newArrayList();
        public int totalOutputTupleSize = -1;
        private static final SizeLt SIZE_LT = new SizeLt();

        public SortGroup(WindowGroup windowGroup) {
            this.partitionByExprs = windowGroup.partitionByExprs;
            this.orderByElements = windowGroup.orderByElements;
            this.windowGroups.add(windowGroup);
        }

        public boolean isCompatible(WindowGroup windowGroup) {
            return Expr.equalSets(windowGroup.partitionByExprs, this.partitionByExprs) && windowGroup.orderByElements.equals(this.orderByElements);
        }

        public void add(WindowGroup windowGroup) {
            Preconditions.checkState((boolean)this.isCompatible(windowGroup));
            this.windowGroups.add(windowGroup);
        }

        public boolean isPrefixOf(SortGroup other) {
            if (other.orderByElements.size() > this.orderByElements.size()) {
                return false;
            }
            if (!Expr.equalSets(this.partitionByExprs, other.partitionByExprs)) {
                return false;
            }
            for (int i = 0; i < other.orderByElements.size(); ++i) {
                OrderByElement ob = this.orderByElements.get(i);
                OrderByElement otherOb = other.orderByElements.get(i);
                if (!ob.getExpr().equals(otherOb.getExpr())) {
                    return false;
                }
                if (ob.getIsAsc() == otherOb.getIsAsc()) continue;
                return false;
            }
            return true;
        }

        public void absorb(SortGroup other) {
            Preconditions.checkState((boolean)this.isPrefixOf(other));
            this.windowGroups.addAll(other.windowGroups);
        }

        public void init() {
            this.totalOutputTupleSize = 0;
            for (WindowGroup g : this.windowGroups) {
                TupleDescriptor outputTuple = g.physicalOutputTuple;
                Preconditions.checkState((boolean)outputTuple.getIsMaterialized());
                Preconditions.checkState((outputTuple.getByteSize() != -1 ? 1 : 0) != 0);
                this.totalOutputTupleSize += outputTuple.getByteSize();
            }
        }

        public void orderWindowGroups() {
            Collections.sort(this.windowGroups, SIZE_LT);
        }

        private static class SizeLt
        implements Comparator<WindowGroup> {
            private SizeLt() {
            }

            @Override
            public int compare(WindowGroup wg1, WindowGroup wg2) {
                Preconditions.checkState((wg1.physicalOutputTuple != null && wg1.physicalOutputTuple.getByteSize() != -1 ? 1 : 0) != 0);
                Preconditions.checkState((wg2.physicalOutputTuple != null && wg2.physicalOutputTuple.getByteSize() != -1 ? 1 : 0) != 0);
                int diff = wg1.physicalOutputTuple.getByteSize() - wg2.physicalOutputTuple.getByteSize();
                return diff < 0 ? -1 : (diff > 0 ? 1 : 0);
            }
        }
    }

    private static class WindowGroup {
        public final List<Expr> partitionByExprs;
        public final List<OrderByElement> orderByElements;
        public final AnalyticWindow window;
        public final List<AnalyticExpr> analyticExprs = Lists.newArrayList();
        public final List<Expr> analyticFnCalls = Lists.newArrayList();
        public final List<SlotDescriptor> logicalOutputSlots = Lists.newArrayList();
        public final List<SlotDescriptor> logicalIntermediateSlots = Lists.newArrayList();
        public TupleDescriptor physicalOutputTuple;
        public TupleDescriptor physicalIntermediateTuple;
        public final ExprSubstitutionMap logicalToPhysicalSmap = new ExprSubstitutionMap();

        public WindowGroup(AnalyticExpr analyticExpr, SlotDescriptor logicalOutputSlot, SlotDescriptor logicalIntermediateSlot) {
            this.partitionByExprs = analyticExpr.getPartitionExprs();
            this.orderByElements = analyticExpr.getOrderByElements();
            this.window = analyticExpr.getWindow();
            this.analyticExprs.add(analyticExpr);
            this.analyticFnCalls.add(analyticExpr.getFnCall());
            this.logicalOutputSlots.add(logicalOutputSlot);
            this.logicalIntermediateSlots.add(logicalIntermediateSlot);
        }

        private static boolean requiresIndependentEval(AnalyticExpr analyticExpr) {
            return analyticExpr.getFnCall().getFnName().getFunction().equals(AnalyticExpr.FIRST_VALUE_REWRITE);
        }

        public boolean isCompatible(AnalyticExpr analyticExpr) {
            if (WindowGroup.requiresIndependentEval(this.analyticExprs.get(0)) || WindowGroup.requiresIndependentEval(analyticExpr)) {
                return false;
            }
            if (!Expr.equalSets(analyticExpr.getPartitionExprs(), this.partitionByExprs)) {
                return false;
            }
            if (!analyticExpr.getOrderByElements().equals(this.orderByElements)) {
                return false;
            }
            if (this.window == null != (analyticExpr.getWindow() == null)) {
                return false;
            }
            if (this.window == null) {
                return true;
            }
            return analyticExpr.getWindow().equals(this.window);
        }

        public void add(AnalyticExpr analyticExpr, SlotDescriptor logicalOutputSlot, SlotDescriptor logicalIntermediateSlot) {
            Preconditions.checkState((boolean)this.isCompatible(analyticExpr));
            this.analyticExprs.add(analyticExpr);
            this.analyticFnCalls.add(analyticExpr.getFnCall());
            this.logicalOutputSlots.add(logicalOutputSlot);
            this.logicalIntermediateSlots.add(logicalIntermediateSlot);
        }

        public void init(Analyzer analyzer, String tupleName) {
            Preconditions.checkState((this.physicalOutputTuple == null ? 1 : 0) != 0);
            Preconditions.checkState((this.physicalIntermediateTuple == null ? 1 : 0) != 0);
            Preconditions.checkState((this.analyticFnCalls.size() == this.analyticExprs.size() ? 1 : 0) != 0);
            boolean requiresIntermediateTuple = AnalyticInfo.requiresIntermediateTuple(this.analyticFnCalls);
            if (requiresIntermediateTuple) {
                this.physicalIntermediateTuple = analyzer.getDescTbl().createTupleDescriptor();
                this.physicalOutputTuple = analyzer.getDescTbl().createTupleDescriptor();
            } else {
                this.physicalIntermediateTuple = this.physicalOutputTuple = analyzer.getDescTbl().createTupleDescriptor();
            }
            Preconditions.checkState((this.analyticExprs.size() == this.logicalIntermediateSlots.size() ? 1 : 0) != 0);
            Preconditions.checkState((this.analyticExprs.size() == this.logicalOutputSlots.size() ? 1 : 0) != 0);
            for (int i = 0; i < this.analyticExprs.size(); ++i) {
                SlotDescriptor logicalOutputSlot = this.logicalOutputSlots.get(i);
                SlotDescriptor physicalOutputSlot = analyzer.getDescTbl().copySlotDescriptor(this.physicalOutputTuple, logicalOutputSlot);
                physicalOutputSlot.setIsMaterialized(true);
                if (requiresIntermediateTuple) {
                    SlotDescriptor logicalIntermediateSlot = this.logicalIntermediateSlots.get(i);
                    SlotDescriptor physicalIntermediateSlot = analyzer.getDescTbl().copySlotDescriptor(this.physicalIntermediateTuple, logicalIntermediateSlot);
                    physicalIntermediateSlot.setIsMaterialized(true);
                }
                this.logicalToPhysicalSmap.put(new SlotRef(logicalOutputSlot), new SlotRef(physicalOutputSlot));
            }
            this.physicalOutputTuple.computeStatAndMemLayout();
        }
    }
}

