/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import org.apache.doris.analysis.AnalyticWindow;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.ExprSubstitutionMap;
import org.apache.doris.analysis.OrderByElement;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.common.UserException;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.thrift.TAnalyticNode;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.doris.thrift.TQueryOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticEvalNode
extends PlanNode {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticEvalNode.class);
    private List<Expr> analyticFnCalls;
    private final List<Expr> partitionExprs;
    private List<Expr> substitutedPartitionExprs;
    private List<OrderByElement> orderByElements;
    private final AnalyticWindow analyticWindow;
    private final TupleDescriptor intermediateTupleDesc;
    private final TupleDescriptor outputTupleDesc;
    private final ExprSubstitutionMap logicalToPhysicalSmap;
    private final Expr partitionByEq;
    private final Expr orderByEq;
    private final TupleDescriptor bufferedTupleDesc;

    public AnalyticEvalNode(PlanNodeId id, PlanNode input, List<Expr> analyticFnCalls, List<Expr> partitionExprs, List<OrderByElement> orderByElements, AnalyticWindow analyticWindow, TupleDescriptor intermediateTupleDesc, TupleDescriptor outputTupleDesc, ExprSubstitutionMap logicalToPhysicalSmap, Expr partitionByEq, Expr orderByEq, TupleDescriptor bufferedTupleDesc) {
        super(id, input.getTupleIds(), "ANALYTIC");
        Preconditions.checkState((!this.tupleIds.contains(outputTupleDesc.getId()) ? 1 : 0) != 0);
        this.tupleIds.add(outputTupleDesc.getId());
        this.analyticFnCalls = analyticFnCalls;
        this.partitionExprs = partitionExprs;
        this.orderByElements = orderByElements;
        this.analyticWindow = analyticWindow;
        this.intermediateTupleDesc = intermediateTupleDesc;
        this.outputTupleDesc = outputTupleDesc;
        this.logicalToPhysicalSmap = logicalToPhysicalSmap;
        this.partitionByEq = partitionByEq;
        this.orderByEq = orderByEq;
        this.bufferedTupleDesc = bufferedTupleDesc;
        this.children.add(input);
        this.nullableTupleIds = Sets.newHashSet(input.getNullableTupleIds());
    }

    public List<Expr> getPartitionExprs() {
        return this.partitionExprs;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        analyzer.getDescTbl().computeStatAndMemLayout();
        this.intermediateTupleDesc.computeStatAndMemLayout();
        this.outputSmap = this.logicalToPhysicalSmap;
        this.createDefaultSmap(analyzer);
        this.computeStats(analyzer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("desctbl: " + analyzer.getDescTbl().debugString());
        }
        ExprSubstitutionMap childSmap = this.getCombinedChildSmap();
        this.analyticFnCalls = Expr.substituteList(this.analyticFnCalls, childSmap, analyzer, false);
        this.substitutedPartitionExprs = Expr.substituteList(this.partitionExprs, childSmap, analyzer, false);
        this.orderByElements = OrderByElement.substitute(this.orderByElements, childSmap, analyzer);
        if (LOG.isDebugEnabled()) {
            LOG.debug("evalnode: " + this.debugString());
        }
    }

    @Override
    protected void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        if (!analyzer.safeIsEnableJoinReorderBasedCost()) {
            return;
        }
        this.cardinality = this.cardinality == -1L ? ((PlanNode)this.getChild((int)0)).cardinality : this.cardinality;
        this.applyConjunctsSelectivity();
        this.capCardinalityAtLimit();
        if (LOG.isDebugEnabled()) {
            LOG.debug("stats AnalyticEval: cardinality={}", (Object)this.cardinality);
        }
    }

    @Override
    protected void computeOldCardinality() {
        this.cardinality = ((PlanNode)this.getChild((int)0)).cardinality;
    }

    @Override
    protected String debugString() {
        ArrayList orderByElementStrs = Lists.newArrayList();
        for (OrderByElement element : this.orderByElements) {
            orderByElementStrs.add(element.toSql());
        }
        return MoreObjects.toStringHelper((Object)this).add("analyticFnCalls", (Object)Expr.debugString(this.analyticFnCalls)).add("partitionExprs", (Object)Expr.debugString(this.partitionExprs)).add("substitutedPartitionExprs", (Object)Expr.debugString(this.substitutedPartitionExprs)).add("orderByElements", (Object)Joiner.on((String)", ").join((Iterable)orderByElementStrs)).add("window", (Object)this.analyticWindow).add("intermediateTid", (Object)this.intermediateTupleDesc.getId()).add("intermediateTid", (Object)this.outputTupleDesc.getId()).add("outputTid", (Object)this.outputTupleDesc.getId()).add("partitionByEq", (Object)(this.partitionByEq != null ? this.partitionByEq.debugString() : "null")).add("orderByEq", (Object)(this.orderByEq != null ? this.orderByEq.debugString() : "null")).addValue((Object)super.debugString()).toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.ANALYTIC_EVAL_NODE;
        msg.analytic_node = new TAnalyticNode();
        msg.analytic_node.setIntermediateTupleId(this.intermediateTupleDesc.getId().asInt());
        msg.analytic_node.setOutputTupleId(this.outputTupleDesc.getId().asInt());
        msg.analytic_node.setPartitionExprs(Expr.treesToThrift(this.substitutedPartitionExprs));
        msg.analytic_node.setOrderByExprs(Expr.treesToThrift(OrderByElement.getOrderByExprs(this.orderByElements)));
        msg.analytic_node.setAnalyticFunctions(Expr.treesToThrift(this.analyticFnCalls));
        if (this.analyticWindow == null) {
            if (!this.orderByElements.isEmpty()) {
                msg.analytic_node.setWindow(AnalyticWindow.DEFAULT_WINDOW.toThrift());
            }
        } else {
            msg.analytic_node.setWindow(this.analyticWindow.toThrift());
        }
        if (this.partitionByEq != null) {
            msg.analytic_node.setPartitionByEq(this.partitionByEq.treeToThrift());
        }
        if (this.orderByEq != null) {
            msg.analytic_node.setOrderByEq(this.orderByEq.treeToThrift());
        }
        if (this.bufferedTupleDesc != null) {
            msg.analytic_node.setBufferedTupleId(this.bufferedTupleDesc.getId().asInt());
        }
    }

    @Override
    public String getNodeExplainString(String prefix, TExplainLevel detailLevel) {
        if (detailLevel == TExplainLevel.BRIEF) {
            return "";
        }
        StringBuilder output = new StringBuilder();
        output.append(prefix + "functions: ");
        ArrayList strings = Lists.newArrayList();
        for (Expr fnCall : this.analyticFnCalls) {
            strings.add("[");
            strings.add(fnCall.toSql());
            strings.add("]");
        }
        output.append(Joiner.on((String)", ").join((Iterable)strings));
        output.append("\n");
        if (!this.partitionExprs.isEmpty()) {
            output.append(prefix + "partition by: ");
            strings.clear();
            for (Expr partitionExpr : this.partitionExprs) {
                strings.add(partitionExpr.toSql());
            }
            output.append(Joiner.on((String)", ").join((Iterable)strings));
            output.append("\n");
        }
        if (!this.orderByElements.isEmpty()) {
            output.append(prefix + "order by: ");
            strings.clear();
            for (OrderByElement element : this.orderByElements) {
                strings.add(element.toSql());
            }
            output.append(Joiner.on((String)", ").join((Iterable)strings));
            output.append("\n");
        }
        if (this.analyticWindow != null) {
            output.append(prefix + "window: ");
            output.append(this.analyticWindow.toSql());
            output.append("\n");
        }
        if (!this.conjuncts.isEmpty()) {
            output.append(prefix + "predicates: " + this.getExplainString(this.conjuncts) + "\n");
        }
        return output.toString();
    }

    public void computeCosts(TQueryOptions queryOptions) {
        Preconditions.checkNotNull((Object)this.fragmentId, (Object)"PlanNode must be placed into a fragment before calling this method.");
        this.cardinality = 0L;
    }
}

