/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.planner;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.doris.analysis.AggregateInfo;
import org.apache.doris.analysis.Analyzer;
import org.apache.doris.analysis.Expr;
import org.apache.doris.analysis.FunctionCallExpr;
import org.apache.doris.analysis.SlotId;
import org.apache.doris.analysis.TupleDescriptor;
import org.apache.doris.analysis.TupleId;
import org.apache.doris.common.NotImplementedException;
import org.apache.doris.common.UserException;
import org.apache.doris.common.util.VectorizedUtil;
import org.apache.doris.planner.PlanNode;
import org.apache.doris.planner.PlanNodeId;
import org.apache.doris.planner.PlannerContext;
import org.apache.doris.thrift.TAggregationNode;
import org.apache.doris.thrift.TExplainLevel;
import org.apache.doris.thrift.TPlanNode;
import org.apache.doris.thrift.TPlanNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AggregationNode
extends PlanNode {
    private static final Logger LOG = LogManager.getLogger(AggregationNode.class);
    private final AggregateInfo aggInfo;
    private boolean needsFinalize;
    private boolean useStreamingPreagg;

    public AggregationNode(PlanNodeId id, PlanNode input, AggregateInfo aggInfo) {
        super(id, aggInfo.getOutputTupleId().asList(), "AGGREGATE");
        this.aggInfo = aggInfo;
        this.children.add(input);
        this.needsFinalize = true;
        this.updateplanNodeName();
    }

    private AggregationNode(PlanNodeId id, AggregationNode src) {
        super(id, src, "AGGREGATE");
        this.aggInfo = src.aggInfo;
        this.needsFinalize = src.needsFinalize;
    }

    public AggregateInfo getAggInfo() {
        return this.aggInfo;
    }

    public void unsetNeedsFinalize() {
        Preconditions.checkState((boolean)this.needsFinalize);
        this.needsFinalize = false;
        this.updateplanNodeName();
    }

    public void setIsPreagg(PlannerContext ctx_) {
        this.useStreamingPreagg = ctx_.getQueryOptions().isSetDisableStreamPreaggregations() && !ctx_.getQueryOptions().disable_stream_preaggregations && this.aggInfo.getGroupingExprs().size() > 0;
    }

    @Override
    public void setCompactData(boolean on) {
        this.compactData = on;
    }

    public void setIntermediateTuple() {
        Preconditions.checkState((!this.tupleIds.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)((TupleId)this.tupleIds.get(0)).equals(this.aggInfo.getOutputTupleId()));
        this.tupleIds.clear();
        this.tupleIds.add(this.aggInfo.getIntermediateTupleId());
    }

    @Override
    public void init(Analyzer analyzer) throws UserException {
        if (((TupleId)this.tupleIds.get(0)).equals(this.aggInfo.getResultTupleId()) && !this.aggInfo.isMerge()) {
            ArrayList bindingPredicates = Lists.newArrayList();
            this.conjuncts.addAll(bindingPredicates);
            this.assignConjuncts(analyzer);
        }
        this.aggInfo.getOutputTupleDesc().computeStatAndMemLayout();
        this.aggInfo.getIntermediateTupleDesc().computeStatAndMemLayout();
        this.computeStats(analyzer);
        this.outputSmap = this.getCombinedChildSmap();
        this.aggInfo.substitute(this.outputSmap, analyzer);
    }

    @Override
    public void computeStats(Analyzer analyzer) {
        super.computeStats(analyzer);
        if (!analyzer.safeIsEnableJoinReorderBasedCost()) {
            return;
        }
        ArrayList<Expr> groupingExprs = this.aggInfo.getGroupingExprs();
        this.cardinality = 1L;
        for (Expr groupingExpr : groupingExprs) {
            long numDistinct = groupingExpr.getNumDistinctValues();
            LOG.debug("grouping expr: " + groupingExpr.toSql() + " #distinct=" + Long.toString(numDistinct));
            if (numDistinct == -1L) {
                this.cardinality = -1L;
                break;
            }
            this.cardinality *= numDistinct;
        }
        if (this.cardinality > 0L) {
            LOG.debug("sel=" + Double.toString(this.computeSelectivity()));
            this.applyConjunctsSelectivity();
        }
        if (this.cardinality < 0L) {
            this.cardinality = -1L;
        }
        this.capCardinalityAtLimit();
        if (LOG.isDebugEnabled()) {
            LOG.debug("stats Agg: cardinality={}", (Object)this.cardinality);
        }
    }

    @Override
    protected void computeOldCardinality() {
        ArrayList<Expr> groupingExprs = this.aggInfo.getGroupingExprs();
        this.cardinality = 1L;
        for (Expr groupingExpr : groupingExprs) {
            long numDistinct = groupingExpr.getNumDistinctValues();
            LOG.debug("grouping expr: " + groupingExpr.toSql() + " #distinct=" + Long.toString(numDistinct));
            if (numDistinct == -1L) {
                this.cardinality = -1L;
                break;
            }
            this.cardinality *= numDistinct;
        }
        LOG.debug("Agg: cardinality=" + Long.toString(this.cardinality));
        if (this.cardinality > 0L) {
            this.cardinality = Math.round((double)this.cardinality * this.computeOldSelectivity());
            LOG.debug("sel=" + Double.toString(this.computeOldSelectivity()));
        }
        if (this.cardinality < 0L) {
            this.cardinality = -1L;
        }
        LOG.debug("stats Agg: cardinality=" + Long.toString(this.cardinality));
    }

    private void updateplanNodeName() {
        StringBuilder sb = new StringBuilder();
        sb.append(VectorizedUtil.isVectorized() ? "VAGGREGATE" : "AGGREGATE");
        sb.append(" (");
        if (this.aggInfo.isMerge()) {
            sb.append("merge");
        } else {
            sb.append("update");
        }
        if (this.needsFinalize) {
            sb.append(" finalize");
        } else {
            sb.append(" serialize");
        }
        sb.append(")");
        this.setPlanNodeName(sb.toString());
    }

    @Override
    protected String debugString() {
        return MoreObjects.toStringHelper((Object)this).add("aggInfo", (Object)this.aggInfo.debugString()).addValue((Object)super.debugString()).toString();
    }

    @Override
    protected void toThrift(TPlanNode msg) {
        msg.node_type = TPlanNodeType.AGGREGATION_NODE;
        ArrayList aggregateFunctions = Lists.newArrayList();
        for (FunctionCallExpr e : this.aggInfo.getMaterializedAggregateExprs()) {
            aggregateFunctions.add(e.treeToThrift());
        }
        msg.agg_node = new TAggregationNode((List)aggregateFunctions, this.aggInfo.getIntermediateTupleId().asInt(), this.aggInfo.getOutputTupleId().asInt(), this.needsFinalize);
        msg.agg_node.setUseStreamingPreaggregation(this.useStreamingPreagg);
        msg.agg_node.setIsUpdateStage(!this.aggInfo.isMerge());
        msg.agg_node.setAggregateFunctionChangedFlags(this.aggInfo.getMaterializedAggregateExprChangedFlags());
        ArrayList<Expr> groupingExprs = this.aggInfo.getGroupingExprs();
        if (groupingExprs != null) {
            msg.agg_node.setGroupingExprs(Expr.treesToThrift(groupingExprs));
        }
    }

    protected String getDisplayLabelDetail() {
        if (this.useStreamingPreagg) {
            return "STREAMING";
        }
        return null;
    }

    @Override
    public String getNodeExplainString(String detailPrefix, TExplainLevel detailLevel) {
        StringBuilder output = new StringBuilder();
        String nameDetail = this.getDisplayLabelDetail();
        if (nameDetail != null) {
            output.append(detailPrefix + nameDetail + "\n");
        }
        if (detailLevel == TExplainLevel.BRIEF) {
            return output.toString();
        }
        if (this.aggInfo.getAggregateExprs() != null && this.aggInfo.getMaterializedAggregateExprs().size() > 0) {
            output.append(detailPrefix + "output: ").append(this.getExplainString(this.aggInfo.getAggregateExprs()) + "\n");
        }
        output.append(detailPrefix + "group by: ").append(this.getExplainString(this.aggInfo.getGroupingExprs()) + "\n");
        if (!this.conjuncts.isEmpty()) {
            output.append(detailPrefix + "having: ").append(this.getExplainString(this.conjuncts) + "\n");
        }
        output.append(detailPrefix).append(String.format("cardinality=%s", this.cardinality)).append("\n");
        return output.toString();
    }

    @Override
    public void getMaterializedIds(Analyzer analyzer, List<SlotId> ids) {
        super.getMaterializedIds(analyzer, ids);
        this.aggInfo.getRefdSlots(ids);
    }

    @Override
    public int getNumInstances() {
        return ((PlanNode)this.children.get(0)).getNumInstances();
    }

    @Override
    public Set<SlotId> computeInputSlotIds(Analyzer analyzer) throws NotImplementedException {
        TupleDescriptor tupleDesc;
        HashSet result = Sets.newHashSet();
        ArrayList<Expr> groupingExprs = this.aggInfo.getGroupingExprs();
        ArrayList groupingSlotIds = Lists.newArrayList();
        Expr.getIds(groupingExprs, null, groupingSlotIds);
        result.addAll(groupingSlotIds);
        ArrayList<FunctionCallExpr> aggregateExprs = this.aggInfo.getAggregateExprs();
        ArrayList aggregateSlotIds = Lists.newArrayList();
        Expr.getIds(aggregateExprs, null, aggregateSlotIds);
        result.addAll(aggregateSlotIds);
        if (result.isEmpty() && !(tupleDesc = analyzer.getTupleDesc(((PlanNode)this.getChild(0)).getOutputTupleIds().get(0))).getMaterializedSlots().isEmpty()) {
            result.add(tupleDesc.getMaterializedSlots().get(0).getId());
        }
        return result;
    }
}

