/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist.gson;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Table;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.alter.RollupJobV2;
import org.apache.doris.alter.SchemaChangeJobV2;
import org.apache.doris.catalog.ArrayType;
import org.apache.doris.catalog.DistributionInfo;
import org.apache.doris.catalog.HashDistributionInfo;
import org.apache.doris.catalog.MapType;
import org.apache.doris.catalog.OdbcCatalogResource;
import org.apache.doris.catalog.RandomDistributionInfo;
import org.apache.doris.catalog.Resource;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.SparkResource;
import org.apache.doris.catalog.StructType;
import org.apache.doris.load.loadv2.LoadJob;
import org.apache.doris.load.loadv2.SparkLoadJob;
import org.apache.doris.load.sync.SyncJob;
import org.apache.doris.load.sync.canal.CanalSyncJob;
import org.apache.doris.persist.gson.GsonPostProcessable;
import org.apache.doris.persist.gson.RuntimeTypeAdapterFactory;

public class GsonUtils {
    private static RuntimeTypeAdapterFactory<org.apache.doris.catalog.Type> columnTypeAdapterFactory = RuntimeTypeAdapterFactory.of(org.apache.doris.catalog.Type.class, "clazz").registerSubtype(ScalarType.class, ScalarType.class.getSimpleName()).registerSubtype(ArrayType.class, ArrayType.class.getSimpleName()).registerSubtype(MapType.class, MapType.class.getSimpleName()).registerSubtype(StructType.class, StructType.class.getSimpleName());
    private static RuntimeTypeAdapterFactory<DistributionInfo> distributionInfoTypeAdapterFactory = RuntimeTypeAdapterFactory.of(DistributionInfo.class, "clazz").registerSubtype(HashDistributionInfo.class, HashDistributionInfo.class.getSimpleName()).registerSubtype(RandomDistributionInfo.class, RandomDistributionInfo.class.getSimpleName());
    private static RuntimeTypeAdapterFactory<Resource> resourceTypeAdapterFactory = RuntimeTypeAdapterFactory.of(Resource.class, "clazz").registerSubtype(SparkResource.class, SparkResource.class.getSimpleName()).registerSubtype(OdbcCatalogResource.class, OdbcCatalogResource.class.getSimpleName());
    private static RuntimeTypeAdapterFactory<AlterJobV2> alterJobV2TypeAdapterFactory = RuntimeTypeAdapterFactory.of(AlterJobV2.class, "clazz").registerSubtype(RollupJobV2.class, RollupJobV2.class.getSimpleName()).registerSubtype(SchemaChangeJobV2.class, SchemaChangeJobV2.class.getSimpleName());
    private static RuntimeTypeAdapterFactory<SyncJob> syncJobTypeAdapterFactory = RuntimeTypeAdapterFactory.of(SyncJob.class, "clazz").registerSubtype(CanalSyncJob.class, CanalSyncJob.class.getSimpleName());
    private static RuntimeTypeAdapterFactory<LoadJob.LoadJobStateUpdateInfo> loadJobStateUpdateInfoTypeAdapterFactory = RuntimeTypeAdapterFactory.of(LoadJob.LoadJobStateUpdateInfo.class, "clazz").registerSubtype(SparkLoadJob.SparkLoadJobStateUpdateInfo.class, SparkLoadJob.SparkLoadJobStateUpdateInfo.class.getSimpleName());
    private static final GsonBuilder GSON_BUILDER = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new HiddenAnnotationExclusionStrategy()).enableComplexMapKeySerialization().registerTypeHierarchyAdapter(Table.class, new GuavaTableAdapter()).registerTypeHierarchyAdapter(Multimap.class, new GuavaMultimapAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new PostProcessTypeAdapterFactory()).registerTypeAdapterFactory(columnTypeAdapterFactory).registerTypeAdapterFactory(distributionInfoTypeAdapterFactory).registerTypeAdapterFactory(resourceTypeAdapterFactory).registerTypeAdapterFactory(alterJobV2TypeAdapterFactory).registerTypeAdapterFactory(syncJobTypeAdapterFactory).registerTypeAdapterFactory(loadJobStateUpdateInfoTypeAdapterFactory).registerTypeAdapter(ImmutableMap.class, (Object)new ImmutableMapDeserializer()).registerTypeAdapter(AtomicBoolean.class, (Object)new AtomicBooleanAdapter());
    private static final GsonBuilder GSON_BUILDER_PRETTY_PRINTING = GSON_BUILDER.setPrettyPrinting();
    public static final Gson GSON = GSON_BUILDER.create();
    public static final Gson GSON_PRETTY_PRINTING = GSON_BUILDER_PRETTY_PRINTING.create();

    public static class PostProcessTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
            return new TypeAdapter<T>(){

                public void write(JsonWriter out, T value) throws IOException {
                    delegate.write(out, value);
                }

                public T read(JsonReader reader) throws IOException {
                    Object obj = delegate.read(reader);
                    if (obj instanceof GsonPostProcessable) {
                        ((GsonPostProcessable)obj).gsonPostProcess();
                    }
                    return obj;
                }
            };
        }
    }

    public static final class ImmutableMapDeserializer
    implements JsonDeserializer<ImmutableMap<?, ?>> {
        public ImmutableMap<?, ?> deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            ParameterizedType type2 = TypeUtils.parameterize(Map.class, (Type[])((ParameterizedType)type).getActualTypeArguments());
            Map map = (Map)context.deserialize(json, (Type)type2);
            return ImmutableMap.copyOf((Map)map);
        }
    }

    private static class AtomicBooleanAdapter
    implements JsonSerializer<AtomicBoolean>,
    JsonDeserializer<AtomicBoolean> {
        private AtomicBooleanAdapter() {
        }

        public AtomicBoolean deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            boolean value = jsonObject.get("boolean").getAsBoolean();
            return new AtomicBoolean(value);
        }

        public JsonElement serialize(AtomicBoolean atomicBoolean, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("boolean", Boolean.valueOf(atomicBoolean.get()));
            return jsonObject;
        }
    }

    private static class GuavaMultimapAdapter<K, V>
    implements JsonSerializer<Multimap<K, V>>,
    JsonDeserializer<Multimap<K, V>> {
        private static final Type asMapReturnType = GuavaMultimapAdapter.getAsMapMethod().getGenericReturnType();

        private GuavaMultimapAdapter() {
        }

        private static Type asMapType(Type multimapType) {
            return com.google.common.reflect.TypeToken.of((Type)multimapType).resolveType(asMapReturnType).getType();
        }

        private static Method getAsMapMethod() {
            try {
                return Multimap.class.getDeclaredMethod("asMap", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }

        public JsonElement serialize(Multimap<K, V> map, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("clazz", map.getClass().getSimpleName());
            Map asMap = map.asMap();
            Type type = GuavaMultimapAdapter.asMapType(typeOfSrc);
            JsonElement jsonElement = context.serialize((Object)asMap, type);
            jsonObject.add("map", jsonElement);
            return jsonObject;
        }

        /*
         * WARNING - void declaration
         */
        public Multimap<K, V> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            void var10_15;
            JsonObject jsonObject = json.getAsJsonObject();
            String clazz = jsonObject.get("clazz").getAsString();
            JsonElement mapElement = jsonObject.get("map");
            Map asMap = (Map)context.deserialize(mapElement, GuavaMultimapAdapter.asMapType(typeOfT));
            ArrayListMultimap map = null;
            String string = clazz;
            int n = -1;
            switch (string.hashCode()) {
                case -1272940262: {
                    if (!string.equals("ArrayListMultimap")) break;
                    boolean bl = false;
                    break;
                }
                case -1204017967: {
                    if (!string.equals("HashMultimap")) break;
                    boolean bl = true;
                    break;
                }
                case -1519744742: {
                    if (!string.equals("LinkedListMultimap")) break;
                    int n2 = 2;
                    break;
                }
                case -330749558: {
                    if (!string.equals("LinkedHashMultimap")) break;
                    int n3 = 3;
                }
            }
            switch (var10_15) {
                case 0: {
                    map = ArrayListMultimap.create();
                    break;
                }
                case 1: {
                    map = HashMultimap.create();
                    break;
                }
                case 2: {
                    map = LinkedListMultimap.create();
                    break;
                }
                case 3: {
                    map = LinkedHashMultimap.create();
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)("unknown guava multi map class: " + clazz));
                }
            }
            for (Map.Entry entry : asMap.entrySet()) {
                map.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
            return map;
        }
    }

    private static class GuavaTableAdapter<R, C, V>
    implements JsonSerializer<Table<R, C, V>>,
    JsonDeserializer<Table<R, C, V>> {
        private GuavaTableAdapter() {
        }

        public JsonElement serialize(Table<R, C, V> src, Type typeOfSrc, JsonSerializationContext context) {
            JsonArray rowKeysJsonArray = new JsonArray();
            HashMap rowKeyToIndex = new HashMap();
            for (Object rowKey : src.rowKeySet()) {
                rowKeyToIndex.put(rowKey, rowKeyToIndex.size());
                rowKeysJsonArray.add(context.serialize(rowKey));
            }
            JsonArray columnKeysJsonArray = new JsonArray();
            HashMap columnKeyToIndex = new HashMap();
            for (Object columnKey : src.columnKeySet()) {
                columnKeyToIndex.put(columnKey, columnKeyToIndex.size());
                columnKeysJsonArray.add(context.serialize(columnKey));
            }
            JsonArray cellsJsonArray = new JsonArray();
            for (Table.Cell cell : src.cellSet()) {
                int rowIndex = (Integer)rowKeyToIndex.get(cell.getRowKey());
                int columnIndex = (Integer)columnKeyToIndex.get(cell.getColumnKey());
                cellsJsonArray.add((Number)rowIndex);
                cellsJsonArray.add((Number)columnIndex);
                cellsJsonArray.add(context.serialize(cell.getValue()));
            }
            JsonObject tableJsonObject = new JsonObject();
            tableJsonObject.addProperty("clazz", src.getClass().getSimpleName());
            tableJsonObject.add("rowKeys", (JsonElement)rowKeysJsonArray);
            tableJsonObject.add("columnKeys", (JsonElement)columnKeysJsonArray);
            tableJsonObject.add("cells", (JsonElement)cellsJsonArray);
            return tableJsonObject;
        }

        public Table<R, C, V> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
            ParameterizedType parameterizedType = (ParameterizedType)typeOfT;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            Type typeOfR = actualTypeArguments[0];
            Type typeOfC = actualTypeArguments[1];
            Type typeOfV = actualTypeArguments[2];
            JsonObject tableJsonObject = json.getAsJsonObject();
            String tableClazz = tableJsonObject.get("clazz").getAsString();
            JsonArray rowKeysJsonArray = tableJsonObject.getAsJsonArray("rowKeys");
            HashMap<Integer, Object> rowIndexToKey = new HashMap<Integer, Object>();
            for (JsonElement jsonElement : rowKeysJsonArray) {
                Object rowKey = context.deserialize(jsonElement, typeOfR);
                rowIndexToKey.put(rowIndexToKey.size(), rowKey);
            }
            JsonArray columnKeysJsonArray = tableJsonObject.getAsJsonArray("columnKeys");
            HashMap<Integer, Object> columnIndexToKey = new HashMap<Integer, Object>();
            for (JsonElement jsonElement : columnKeysJsonArray) {
                Object columnKey = context.deserialize(jsonElement, typeOfC);
                columnIndexToKey.put(columnIndexToKey.size(), columnKey);
            }
            JsonArray cellsJsonArray = tableJsonObject.getAsJsonArray("cells");
            HashBasedTable table = null;
            switch (tableClazz) {
                case "HashBasedTable": {
                    table = HashBasedTable.create();
                    break;
                }
                default: {
                    Preconditions.checkState((boolean)false, (Object)("unknown guava table class: " + tableClazz));
                }
            }
            for (int i = 0; i < cellsJsonArray.size(); i += 3) {
                int rowIndex = cellsJsonArray.get(i).getAsInt();
                int columnIndex = cellsJsonArray.get(i + 1).getAsInt();
                Object rowKey = rowIndexToKey.get(rowIndex);
                Object columnKey = columnIndexToKey.get(columnIndex);
                Object value = context.deserialize(cellsJsonArray.get(i + 2), typeOfV);
                table.put(rowKey, columnKey, value);
            }
            return table;
        }
    }

    public static class HiddenAnnotationExclusionStrategy
    implements ExclusionStrategy {
        public boolean shouldSkipField(FieldAttributes f) {
            return f.getAnnotation(SerializedName.class) == null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    }
}

