/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.catalog.Partition;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class TruncateTableInfo
implements Writable {
    @SerializedName(value="dbId")
    private long dbId;
    @SerializedName(value="tblId")
    private long tblId;
    @SerializedName(value="partitions")
    private List<Partition> partitions = Lists.newArrayList();
    @SerializedName(value="isEntireTable")
    private boolean isEntireTable = false;

    private TruncateTableInfo() {
    }

    public TruncateTableInfo(long dbId, long tblId, List<Partition> partitions, boolean isEntireTable) {
        this.dbId = dbId;
        this.tblId = tblId;
        this.partitions = partitions;
        this.isEntireTable = isEntireTable;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTblId() {
        return this.tblId;
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public boolean isEntireTable() {
        return this.isEntireTable;
    }

    public static TruncateTableInfo read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (TruncateTableInfo)GsonUtils.GSON.fromJson(json, TruncateTableInfo.class);
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    @Deprecated
    private void readFields(DataInput in) throws IOException {
        this.dbId = in.readLong();
        this.tblId = in.readLong();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Partition partition = Partition.read(in);
            this.partitions.add(partition);
        }
    }
}

