/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.doris.catalog.ColocateTableIndex;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class TablePropertyInfo
implements Writable {
    private long tableId;
    private Map<String, String> propertyMap;
    private ColocateTableIndex.GroupId groupId;

    public TablePropertyInfo() {
    }

    public TablePropertyInfo(long tableId, ColocateTableIndex.GroupId groupId, Map<String, String> propertyMap) {
        this.tableId = tableId;
        this.groupId = groupId;
        this.propertyMap = propertyMap;
    }

    public Map<String, String> getPropertyMap() {
        return this.propertyMap;
    }

    public long getTableId() {
        return this.tableId;
    }

    public ColocateTableIndex.GroupId getGroupId() {
        return this.groupId;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.tableId);
        if (this.groupId == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.groupId.write(out);
        }
        int size = this.propertyMap.size();
        out.writeInt(size);
        for (Map.Entry<String, String> kv : this.propertyMap.entrySet()) {
            Text.writeString((DataOutput)out, (String)kv.getKey());
            Text.writeString((DataOutput)out, (String)kv.getValue());
        }
    }

    public void readFields(DataInput in) throws IOException {
        long dbId = -1L;
        this.tableId = in.readLong();
        if (in.readBoolean()) {
            this.groupId = ColocateTableIndex.GroupId.read(in);
        }
        int size = in.readInt();
        this.propertyMap = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String value = Text.readString((DataInput)in);
            this.propertyMap.put(key, value);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TablePropertyInfo)) {
            return false;
        }
        TablePropertyInfo info = (TablePropertyInfo)obj;
        return this.tableId == info.tableId && this.groupId.equals(info.groupId) && this.propertyMap.equals(info.propertyMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" table id: ").append(this.tableId);
        sb.append(" group id: ").append(this.groupId);
        sb.append(" propertyMap: ").append(this.propertyMap);
        return sb.toString();
    }
}

