/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class TableInfo
implements Writable {
    private long dbId;
    private long tableId;
    private long indexId;
    private long partitionId;
    private String newTableName;
    private String newRollupName;
    private String newPartitionName;

    public TableInfo() {
    }

    private TableInfo(long dbId, long tableId, long indexId, long partitionId, String newTableName, String newRollupName, String newPartitionName) {
        this.dbId = dbId;
        this.tableId = tableId;
        this.indexId = indexId;
        this.partitionId = partitionId;
        this.newTableName = newTableName;
        this.newRollupName = newRollupName;
        this.newPartitionName = newPartitionName;
    }

    public static TableInfo createForTableRename(long dbId, long tableId, String newTableName) {
        return new TableInfo(dbId, tableId, -1L, -1L, newTableName, "", "");
    }

    public static TableInfo createForRollupRename(long dbId, long tableId, long indexId, String newRollupName) {
        return new TableInfo(dbId, tableId, indexId, -1L, "", newRollupName, "");
    }

    public static TableInfo createForPartitionRename(long dbId, long tableId, long partitionId, String newPartitionName) {
        return new TableInfo(dbId, tableId, -1L, partitionId, "", "", newPartitionName);
    }

    public static TableInfo createForModifyDistribution(long dbId, long tableId) {
        return new TableInfo(dbId, tableId, -1L, -1L, "", "", "");
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public String getNewRollupName() {
        return this.newRollupName;
    }

    public String getNewPartitionName() {
        return this.newPartitionName;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.dbId);
        out.writeLong(this.tableId);
        out.writeLong(this.indexId);
        out.writeLong(this.partitionId);
        Text.writeString((DataOutput)out, (String)this.newTableName);
        Text.writeString((DataOutput)out, (String)this.newRollupName);
        Text.writeString((DataOutput)out, (String)this.newPartitionName);
    }

    public void readFields(DataInput in) throws IOException {
        this.dbId = in.readLong();
        this.tableId = in.readLong();
        this.indexId = in.readLong();
        this.partitionId = in.readLong();
        this.newTableName = Text.readString((DataInput)in);
        this.newRollupName = Text.readString((DataInput)in);
        this.newPartitionName = Text.readString((DataInput)in);
    }

    public static TableInfo read(DataInput in) throws IOException {
        TableInfo info = new TableInfo();
        info.readFields(in);
        return info;
    }
}

