/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import org.apache.doris.ha.FrontendNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Storage {
    private static final Logger LOG = LogManager.getLogger(Storage.class);
    public static final String CLUSTER_ID = "clusterId";
    public static final String TOKEN = "token";
    public static final String FRONTEND_ROLE = "role";
    public static final String NODE_NAME = "name";
    public static final String EDITS = "edits";
    public static final String IMAGE = "image";
    public static final String IMAGE_NEW = "image.ckpt";
    public static final String VERSION_FILE = "VERSION";
    public static final String ROLE_FILE = "ROLE";
    private int clusterID = 0;
    private String token;
    private FrontendNodeType role = FrontendNodeType.UNKNOWN;
    private String nodeName;
    private long editsSeq;
    private long latestImageSeq;
    private long latestValidatedImageSeq;
    private String metaDir;
    private List<Long> editsFileSequenceNumbers;

    public Storage(int clusterID, String token, String metaDir) {
        this.clusterID = clusterID;
        this.token = token;
        this.metaDir = metaDir;
    }

    public Storage(int clusterID, String token, long latestImageSeq, long editsSeq, String metaDir) {
        this.clusterID = clusterID;
        this.token = token;
        this.editsSeq = editsSeq;
        this.latestImageSeq = latestImageSeq;
        this.metaDir = metaDir;
    }

    public Storage(String metaDir) throws IOException {
        this.editsFileSequenceNumbers = new ArrayList<Long>();
        this.metaDir = metaDir;
        this.reload();
    }

    public List<Long> getEditsFileSequenceNumbers() {
        Collections.sort(this.editsFileSequenceNumbers);
        return this.editsFileSequenceNumbers;
    }

    public void reload() throws IOException {
        File dir;
        File[] children;
        File roleFile;
        Properties prop = new Properties();
        File versionFile = this.getVersionFile();
        if (versionFile.isFile()) {
            FileInputStream in = new FileInputStream(versionFile);
            prop.load(in);
            in.close();
            this.clusterID = Integer.parseInt(prop.getProperty(CLUSTER_ID));
            if (prop.getProperty(TOKEN) != null) {
                this.token = prop.getProperty(TOKEN);
            }
        }
        if ((roleFile = this.getRoleFile()).isFile()) {
            FileInputStream in = new FileInputStream(roleFile);
            prop.load(in);
            in.close();
            this.role = FrontendNodeType.valueOf(prop.getProperty(FRONTEND_ROLE));
            this.nodeName = prop.getProperty(NODE_NAME, null);
        }
        if ((children = (dir = new File(this.metaDir)).listFiles()) == null) {
            return;
        }
        for (File child : children) {
            String name = child.getName();
            try {
                if (name.equals(EDITS) || name.equals(IMAGE_NEW) || name.endsWith(".part") || !name.contains(".")) continue;
                if (name.startsWith(IMAGE)) {
                    long fileSeq = Long.parseLong(name.substring(name.lastIndexOf(46) + 1));
                    if (this.latestImageSeq >= fileSeq) continue;
                    this.latestValidatedImageSeq = this.latestImageSeq;
                    this.latestImageSeq = fileSeq;
                    continue;
                }
                if (!name.startsWith(EDITS)) continue;
                this.editsFileSequenceNumbers.add(Long.parseLong(name.substring(name.lastIndexOf(46) + 1)));
                this.editsSeq = Math.max(Long.parseLong(name.substring(name.lastIndexOf(46) + 1)), this.editsSeq);
            }
            catch (Exception e) {
                LOG.warn(name + " is not a validate meta file, ignore it");
            }
        }
    }

    public int getClusterID() {
        return this.clusterID;
    }

    public void setClusterID(int clusterID) {
        this.clusterID = clusterID;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public FrontendNodeType getRole() {
        return this.role;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getMetaDir() {
        return this.metaDir;
    }

    public void setMetaDir(String metaDir) {
        this.metaDir = metaDir;
    }

    public long getLatestImageSeq() {
        return this.latestImageSeq;
    }

    public long getLatestValidatedImageSeq() {
        return this.latestValidatedImageSeq;
    }

    public void setLatestImageSeq(long latestImageSeq) {
        this.latestImageSeq = latestImageSeq;
    }

    public void setEditsSeq(long editsSeq) {
        this.editsSeq = editsSeq;
    }

    public long getEditsSeq() {
        return this.editsSeq;
    }

    public static int newClusterID() {
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        int newID = 0;
        while (newID == 0) {
            newID = random.nextInt(Integer.MAX_VALUE);
        }
        return newID;
    }

    public static String newToken() {
        return UUID.randomUUID().toString();
    }

    private void setFields(Properties properties) throws IOException {
        Preconditions.checkState((this.clusterID > 0 ? 1 : 0) != 0);
        properties.setProperty(CLUSTER_ID, String.valueOf(this.clusterID));
        if (!Strings.isNullOrEmpty((String)this.token)) {
            properties.setProperty(TOKEN, this.token);
        }
    }

    public void writeClusterIdAndToken() throws IOException {
        Properties properties = new Properties();
        this.setFields(properties);
        this.writePropertiesToFile(properties, VERSION_FILE);
    }

    public void writeFrontendRoleAndNodeName(FrontendNodeType role, String nameNode) throws IOException {
        Preconditions.checkState((!Strings.isNullOrEmpty((String)nameNode) ? 1 : 0) != 0);
        Properties properties = new Properties();
        properties.setProperty(FRONTEND_ROLE, role.name());
        properties.setProperty(NODE_NAME, nameNode);
        this.writePropertiesToFile(properties, ROLE_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePropertiesToFile(Properties properties, String fileName) throws IOException {
        RandomAccessFile file = new RandomAccessFile(new File(this.metaDir, fileName), "rws");
        FileOutputStream out = null;
        try {
            file.seek(0L);
            out = new FileOutputStream(file.getFD());
            properties.store(out, null);
            file.setLength(out.getChannel().position());
        }
        finally {
            if (out != null) {
                out.close();
            }
            file.close();
        }
    }

    public void clear() throws IOException {
        File metaFile = new File(this.metaDir);
        if (metaFile.exists()) {
            String[] children = metaFile.list();
            if (children != null) {
                for (String child : children) {
                    File file = new File(metaFile, child);
                    file.delete();
                }
            }
            metaFile.delete();
        }
        if (!metaFile.mkdirs()) {
            throw new IOException("Cannot create directory " + metaFile);
        }
    }

    public static void rename(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("Failed to rename  " + from.getCanonicalPath() + " to " + to.getCanonicalPath());
        }
    }

    public File getCurrentImageFile() {
        return this.getImageFile(this.latestImageSeq);
    }

    public File getImageFile(long version) {
        return Storage.getImageFile(new File(this.metaDir), version);
    }

    public static File getImageFile(File dir, long version) {
        return new File(dir, "image." + version);
    }

    public final File getVersionFile() {
        return new File(this.metaDir, VERSION_FILE);
    }

    public final File getRoleFile() {
        return new File(this.metaDir, ROLE_FILE);
    }

    public File getCurrentEditsFile() {
        return new File(this.metaDir, EDITS);
    }

    public static File getCurrentEditsFile(File dir) {
        return new File(dir, EDITS);
    }

    public File getEditsFile(long seq) {
        return Storage.getEditsFile(new File(this.metaDir), seq);
    }

    public static File getEditsFile(File dir, long seq) {
        return new File(dir, "edits." + seq);
    }

    public static long getMetaSeq(File file) {
        String filename = file.getName();
        return Long.parseLong(filename.substring(filename.lastIndexOf(46) + 1));
    }
}

