/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Writable;

public class ReplicaPersistInfo
implements Writable {
    private ReplicaOperationType opType;
    private long dbId;
    private long tableId;
    private long partitionId;
    private long indexId;
    private long tabletId;
    private long replicaId;
    private long backendId;
    private long version;
    @Deprecated
    private long versionHash = 0L;
    private int schemaHash = -1;
    private long dataSize;
    private long rowCount;
    private long lastFailedVersion = -1L;
    @Deprecated
    private long lastFailedVersionHash = 0L;
    private long lastSuccessVersion = -1L;
    @Deprecated
    private long lastSuccessVersionHash = 0L;

    public static ReplicaPersistInfo createForAdd(long dbId, long tableId, long partitionId, long indexId, long tabletId, long backendId, long replicaId, long version, int schemaHash, long dataSize, long rowCount, long lastFailedVersion, long lastSuccessVersion) {
        return new ReplicaPersistInfo(ReplicaOperationType.ADD, dbId, tableId, partitionId, indexId, tabletId, backendId, replicaId, version, schemaHash, dataSize, rowCount, lastFailedVersion, lastSuccessVersion);
    }

    public static ReplicaPersistInfo createForCondDelete(long indexId, long tabletId, long replicaId, long version, int schemaHash, long dataSize, long rowCount, long lastFailedVersion, long lastSuccessVersion) {
        return new ReplicaPersistInfo(ReplicaOperationType.CROND_DELETE, -1L, -1L, -1L, indexId, tabletId, -1L, replicaId, version, schemaHash, dataSize, rowCount, lastFailedVersion, lastSuccessVersion);
    }

    public static ReplicaPersistInfo createForDelete(long dbId, long tableId, long partitionId, long indexId, long tabletId, long backendId) {
        return new ReplicaPersistInfo(ReplicaOperationType.DELETE, dbId, tableId, partitionId, indexId, tabletId, backendId, -1L, -1L, -1, -1L, -1L, -1L, -1L);
    }

    public static ReplicaPersistInfo createForClone(long dbId, long tableId, long partitionId, long indexId, long tabletId, long backendId, long replicaId, long version, int schemaHash, long dataSize, long rowCount, long lastFailedVersion, long lastSuccessVersion) {
        return new ReplicaPersistInfo(ReplicaOperationType.CLONE, dbId, tableId, partitionId, indexId, tabletId, backendId, replicaId, version, schemaHash, dataSize, rowCount, lastFailedVersion, lastSuccessVersion);
    }

    public static ReplicaPersistInfo createForLoad(long tableId, long partitionId, long indexId, long tabletId, long replicaId, long version, int schemaHash, long dataSize, long rowCount) {
        return new ReplicaPersistInfo(ReplicaOperationType.LOAD, -1L, tableId, partitionId, indexId, tabletId, -1L, replicaId, version, schemaHash, dataSize, rowCount, -1L, version);
    }

    public static ReplicaPersistInfo createForRollup(long indexId, long tabletId, long backendId, long version, int schemaHash, long dataSize, long rowCount, long lastFailedVersion, long lastSuccessVersion) {
        return new ReplicaPersistInfo(ReplicaOperationType.ROLLUP, -1L, -1L, -1L, indexId, tabletId, backendId, -1L, version, schemaHash, dataSize, rowCount, lastFailedVersion, lastSuccessVersion);
    }

    public static ReplicaPersistInfo createForSchemaChange(long partitionId, long indexId, long tabletId, long backendId, long version, int schemaHash, long dataSize, long rowCount, long lastFailedVersion, long lastSuccessVersion) {
        return new ReplicaPersistInfo(ReplicaOperationType.SCHEMA_CHANGE, -1L, -1L, partitionId, indexId, tabletId, backendId, -1L, version, schemaHash, dataSize, rowCount, lastFailedVersion, lastSuccessVersion);
    }

    public static ReplicaPersistInfo createForClearRollupInfo(long dbId, long tableId, long partitionId, long indexId) {
        return new ReplicaPersistInfo(ReplicaOperationType.CLEAR_ROLLUPINFO, dbId, tableId, partitionId, indexId, -1L, -1L, -1L, -1L, -1, -1L, -1L, -1L, -1L);
    }

    public static ReplicaPersistInfo createForReport(long dbId, long tblId, long partitionId, long indexId, long tabletId, long backendId, long replicaId) {
        return new ReplicaPersistInfo(ReplicaOperationType.TABLET_INFO, dbId, tblId, partitionId, indexId, tabletId, backendId, replicaId, -1L, -1, -1L, -1L, -1L, -1L);
    }

    private ReplicaPersistInfo() {
    }

    private ReplicaPersistInfo(ReplicaOperationType opType, long dbId, long tableId, long partitionId, long indexId, long tabletId, long backendId, long replicaId, long version, int schemaHash, long dataSize, long rowCount, long lastFailedVersion, long lastSuccessVersion) {
        this.opType = opType;
        this.dbId = dbId;
        this.tableId = tableId;
        this.partitionId = partitionId;
        this.indexId = indexId;
        this.tabletId = tabletId;
        this.backendId = backendId;
        this.replicaId = replicaId;
        this.version = version;
        this.schemaHash = schemaHash;
        this.dataSize = dataSize;
        this.rowCount = rowCount;
        this.lastFailedVersion = lastFailedVersion;
        this.lastSuccessVersion = lastSuccessVersion;
    }

    public ReplicaOperationType getOpType() {
        return this.opType;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public long getTabletId() {
        return this.tabletId;
    }

    public long getReplicaId() {
        return this.replicaId;
    }

    public long getBackendId() {
        return this.backendId;
    }

    public long getVersion() {
        return this.version;
    }

    public int getSchemaHash() {
        return this.schemaHash;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public long getLastFailedVersion() {
        return this.lastFailedVersion;
    }

    public long getLastSuccessVersion() {
        return this.lastSuccessVersion;
    }

    public static ReplicaPersistInfo read(DataInput in) throws IOException {
        ReplicaPersistInfo replicaInfo = new ReplicaPersistInfo();
        replicaInfo.readFields(in);
        return replicaInfo;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.dbId);
        out.writeLong(this.tableId);
        out.writeLong(this.partitionId);
        out.writeLong(this.indexId);
        out.writeLong(this.tabletId);
        out.writeLong(this.backendId);
        out.writeLong(this.replicaId);
        out.writeLong(this.version);
        out.writeLong(this.versionHash);
        out.writeLong(this.dataSize);
        out.writeLong(this.rowCount);
        out.writeInt(this.opType.value);
        out.writeLong(this.lastFailedVersion);
        out.writeLong(this.lastFailedVersionHash);
        out.writeLong(this.lastSuccessVersion);
        out.writeLong(this.lastSuccessVersionHash);
        out.writeInt(this.schemaHash);
    }

    public void readFields(DataInput in) throws IOException {
        this.dbId = in.readLong();
        this.tableId = in.readLong();
        this.partitionId = in.readLong();
        this.indexId = in.readLong();
        this.tabletId = in.readLong();
        this.backendId = in.readLong();
        this.replicaId = in.readLong();
        this.version = in.readLong();
        this.versionHash = in.readLong();
        this.dataSize = in.readLong();
        this.rowCount = in.readLong();
        this.opType = ReplicaOperationType.DEFAULT_OP;
        this.opType = ReplicaOperationType.findByValue(in.readInt());
        if (this.opType == null) {
            throw new IOException("could not parse operation type from replica info");
        }
        this.lastFailedVersion = in.readLong();
        this.lastFailedVersionHash = in.readLong();
        this.lastSuccessVersion = in.readLong();
        this.lastSuccessVersionHash = in.readLong();
        this.schemaHash = in.readInt();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReplicaPersistInfo)) {
            return false;
        }
        ReplicaPersistInfo info = (ReplicaPersistInfo)obj;
        return this.backendId == info.backendId && this.replicaId == info.replicaId && this.tabletId == info.tabletId && this.indexId == info.indexId && this.partitionId == info.partitionId && this.tableId == info.tableId && this.dbId == info.dbId && this.version == info.version && this.dataSize == info.dataSize && this.rowCount == info.rowCount && this.lastFailedVersion == info.lastFailedVersion && this.lastSuccessVersion == info.lastSuccessVersion;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("table id: ").append(this.tableId);
        sb.append(" partition id: ").append(this.partitionId);
        sb.append(" index id: ").append(this.indexId);
        sb.append(" tablet id: ").append(this.tabletId);
        sb.append(" backend id: ").append(this.backendId);
        sb.append(" replica id: ").append(this.replicaId);
        sb.append(" version: ").append(this.version);
        sb.append(" schema hash: ").append(this.schemaHash);
        sb.append(" data size: ").append(this.dataSize);
        sb.append(" row count: ").append(this.rowCount);
        sb.append(" last failed version: ").append(this.lastFailedVersion);
        sb.append(" last success version: ").append(this.lastSuccessVersion);
        return sb.toString();
    }

    public static enum ReplicaOperationType {
        ADD(0),
        CROND_DELETE(1),
        DELETE(2),
        CLONE(3),
        LOAD(4),
        ROLLUP(5),
        SCHEMA_CHANGE(6),
        CLEAR_ROLLUPINFO(7),
        DEFAULT_OP(8),
        TABLET_INFO(9);

        private final int value;

        private ReplicaOperationType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ReplicaOperationType findByValue(int value) {
            switch (value) {
                case 0: {
                    return ADD;
                }
                case 1: {
                    return CROND_DELETE;
                }
                case 2: {
                    return DELETE;
                }
                case 3: {
                    return CLONE;
                }
                case 4: {
                    return LOAD;
                }
                case 5: {
                    return ROLLUP;
                }
                case 6: {
                    return SCHEMA_CHANGE;
                }
                case 7: {
                    return CLEAR_ROLLUPINFO;
                }
                case 8: {
                    return DEFAULT_OP;
                }
                case 9: {
                    return TABLET_INFO;
                }
            }
            return null;
        }
    }
}

