/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.catalog.Column;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshExternalTableInfo
implements Writable {
    public static final Logger LOG = LoggerFactory.getLogger(RefreshExternalTableInfo.class);
    @SerializedName(value="dbName")
    private String dbName;
    @SerializedName(value="tableName")
    private String tableName;
    @SerializedName(value="newSchema")
    private List<Column> newSchema;

    public RefreshExternalTableInfo() {
    }

    public RefreshExternalTableInfo(String dbName, String tableName, List<Column> newSchema) {
        this.dbName = dbName;
        this.tableName = tableName;
        this.newSchema = newSchema;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<Column> getNewSchema() {
        return this.newSchema;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static RefreshExternalTableInfo read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (RefreshExternalTableInfo)GsonUtils.GSON.fromJson(json, RefreshExternalTableInfo.class);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RefreshExternalTableInfo)) {
            return false;
        }
        RefreshExternalTableInfo info = (RefreshExternalTableInfo)obj;
        return this.dbName.equals(info.dbName) && this.tableName.equals(info.tableName) && this.newSchema.equals(this.newSchema);
    }
}

