/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.base.Strings;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.analysis.ResourcePattern;
import org.apache.doris.analysis.TablePattern;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.mysql.privilege.PrivBitSet;

public class PrivInfo
implements Writable {
    private UserIdentity userIdent;
    private TablePattern tblPattern;
    private ResourcePattern resourcePattern;
    private PrivBitSet privs;
    private byte[] passwd;
    private String role;

    private PrivInfo() {
    }

    public PrivInfo(UserIdentity userIdent, PrivBitSet privs, byte[] passwd, String role) {
        this.userIdent = userIdent;
        this.tblPattern = null;
        this.resourcePattern = null;
        this.privs = privs;
        this.passwd = passwd;
        this.role = role;
    }

    public PrivInfo(UserIdentity userIdent, TablePattern tablePattern, PrivBitSet privs, byte[] passwd, String role) {
        this.userIdent = userIdent;
        this.tblPattern = tablePattern;
        this.resourcePattern = null;
        this.privs = privs;
        this.passwd = passwd;
        this.role = role;
    }

    public PrivInfo(UserIdentity userIdent, ResourcePattern resourcePattern, PrivBitSet privs, byte[] passwd, String role) {
        this.userIdent = userIdent;
        this.tblPattern = null;
        this.resourcePattern = resourcePattern;
        this.privs = privs;
        this.passwd = passwd;
        this.role = role;
    }

    public UserIdentity getUserIdent() {
        return this.userIdent;
    }

    public TablePattern getTblPattern() {
        return this.tblPattern;
    }

    public ResourcePattern getResourcePattern() {
        return this.resourcePattern;
    }

    public PrivBitSet getPrivs() {
        return this.privs;
    }

    public byte[] getPasswd() {
        return this.passwd;
    }

    public String getRole() {
        return this.role;
    }

    public static PrivInfo read(DataInput in) throws IOException {
        PrivInfo info = new PrivInfo();
        info.readFields(in);
        return info;
    }

    public void write(DataOutput out) throws IOException {
        if (this.userIdent != null) {
            out.writeBoolean(true);
            this.userIdent.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.tblPattern != null) {
            out.writeBoolean(true);
            this.tblPattern.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.resourcePattern != null) {
            out.writeBoolean(true);
            this.resourcePattern.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.privs != null) {
            out.writeBoolean(true);
            this.privs.write(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.passwd != null) {
            out.writeBoolean(true);
            out.writeInt(this.passwd.length);
            out.write(this.passwd);
        } else {
            out.writeBoolean(false);
        }
        if (!Strings.isNullOrEmpty((String)this.role)) {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.role);
        } else {
            out.writeBoolean(false);
        }
    }

    public void readFields(DataInput in) throws IOException {
        if (in.readBoolean()) {
            this.userIdent = UserIdentity.read(in);
        }
        if (in.readBoolean()) {
            this.tblPattern = TablePattern.read(in);
        }
        if (in.readBoolean()) {
            this.resourcePattern = ResourcePattern.read(in);
        }
        if (in.readBoolean()) {
            this.privs = PrivBitSet.read(in);
        }
        if (in.readBoolean()) {
            int passwordLen = in.readInt();
            this.passwd = new byte[passwordLen];
            in.readFully(this.passwd);
        }
        if (in.readBoolean()) {
            this.role = Text.readString((DataInput)in);
        }
    }
}

