/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.collect.Range;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.DataProperty;
import org.apache.doris.catalog.ListPartitionItem;
import org.apache.doris.catalog.Partition;
import org.apache.doris.catalog.PartitionItem;
import org.apache.doris.catalog.PartitionKey;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.RangeUtils;

public class PartitionPersistInfo
implements Writable {
    private Long dbId;
    private Long tableId;
    private Partition partition;
    private Range<PartitionKey> range;
    private PartitionItem listPartitionItem;
    private DataProperty dataProperty;
    private ReplicaAllocation replicaAlloc;
    private boolean isInMemory = false;
    private boolean isTempPartition = false;

    public PartitionPersistInfo() {
    }

    public PartitionPersistInfo(long dbId, long tableId, Partition partition, Range<PartitionKey> range, PartitionItem listPartitionItem, DataProperty dataProperty, ReplicaAllocation replicaAlloc, boolean isInMemory, boolean isTempPartition) {
        this.dbId = dbId;
        this.tableId = tableId;
        this.partition = partition;
        this.range = range;
        this.listPartitionItem = listPartitionItem;
        this.dataProperty = dataProperty;
        this.replicaAlloc = replicaAlloc;
        this.isInMemory = isInMemory;
        this.isTempPartition = isTempPartition;
    }

    public Long getDbId() {
        return this.dbId;
    }

    public Long getTableId() {
        return this.tableId;
    }

    public Partition getPartition() {
        return this.partition;
    }

    public Range<PartitionKey> getRange() {
        return this.range;
    }

    public PartitionItem getListPartitionItem() {
        return this.listPartitionItem;
    }

    public DataProperty getDataProperty() {
        return this.dataProperty;
    }

    public ReplicaAllocation getReplicaAlloc() {
        return this.replicaAlloc;
    }

    public boolean isInMemory() {
        return this.isInMemory;
    }

    public boolean isTempPartition() {
        return this.isTempPartition;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.dbId);
        out.writeLong(this.tableId);
        this.partition.write(out);
        RangeUtils.writeRange(out, this.range);
        this.listPartitionItem.write(out);
        this.dataProperty.write(out);
        this.replicaAlloc.write(out);
        out.writeBoolean(this.isInMemory);
        out.writeBoolean(this.isTempPartition);
    }

    public void readFields(DataInput in) throws IOException {
        this.dbId = in.readLong();
        this.tableId = in.readLong();
        this.partition = Partition.read(in);
        this.range = RangeUtils.readRange(in);
        this.listPartitionItem = ListPartitionItem.read(in);
        this.dataProperty = DataProperty.read(in);
        this.replicaAlloc = Catalog.getCurrentCatalogJournalVersion() < 105 ? new ReplicaAllocation(in.readShort()) : ReplicaAllocation.read(in);
        this.isInMemory = in.readBoolean();
        this.isTempPartition = in.readBoolean();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PartitionPersistInfo)) {
            return false;
        }
        PartitionPersistInfo info = (PartitionPersistInfo)obj;
        return this.dbId.equals(info.dbId) && this.tableId.equals(info.tableId) && this.partition.equals(info.partition);
    }
}

