/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.DataProperty;
import org.apache.doris.catalog.ReplicaAllocation;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class ModifyPartitionInfo
implements Writable {
    @SerializedName(value="dbId")
    private long dbId;
    @SerializedName(value="tableId")
    private long tableId;
    @SerializedName(value="partitionId")
    private long partitionId;
    @SerializedName(value="dataProperty")
    private DataProperty dataProperty;
    @Deprecated
    private short replicationNum;
    @SerializedName(value="isInMemory")
    private boolean isInMemory;
    @SerializedName(value="replicaAlloc")
    private ReplicaAllocation replicaAlloc;

    public ModifyPartitionInfo() {
    }

    public ModifyPartitionInfo(long dbId, long tableId, long partitionId, DataProperty dataProperty, ReplicaAllocation replicaAlloc, boolean isInMemory) {
        this.dbId = dbId;
        this.tableId = tableId;
        this.partitionId = partitionId;
        this.dataProperty = dataProperty;
        this.replicaAlloc = replicaAlloc;
        this.isInMemory = isInMemory;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public DataProperty getDataProperty() {
        return this.dataProperty;
    }

    public ReplicaAllocation getReplicaAlloc() {
        return this.replicaAlloc;
    }

    public boolean isInMemory() {
        return this.isInMemory;
    }

    public static ModifyPartitionInfo read(DataInput in) throws IOException {
        if (Catalog.getCurrentCatalogJournalVersion() < 105) {
            ModifyPartitionInfo info = new ModifyPartitionInfo();
            info.readFields(in);
            return info;
        }
        String json = Text.readString((DataInput)in);
        return (ModifyPartitionInfo)GsonUtils.GSON.fromJson(json, ModifyPartitionInfo.class);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModifyPartitionInfo)) {
            return false;
        }
        ModifyPartitionInfo otherInfo = (ModifyPartitionInfo)other;
        return this.dbId == otherInfo.getDbId() && this.tableId == otherInfo.getTableId() && this.dataProperty.equals(otherInfo.getDataProperty()) && this.replicaAlloc.equals(otherInfo.replicaAlloc) && this.isInMemory == otherInfo.isInMemory();
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    @Deprecated
    private void readFields(DataInput in) throws IOException {
        this.dbId = in.readLong();
        this.tableId = in.readLong();
        this.partitionId = in.readLong();
        boolean hasDataProperty = in.readBoolean();
        this.dataProperty = hasDataProperty ? DataProperty.read(in) : null;
        this.replicationNum = in.readShort();
        this.replicaAlloc = this.replicationNum > 0 ? new ReplicaAllocation(this.replicationNum) : ReplicaAllocation.NOT_SET;
        this.isInMemory = in.readBoolean();
    }
}

