/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class ModifyCommentOperationLog
implements Writable {
    @SerializedName(value="type")
    private Type type;
    @SerializedName(value="dbId")
    private long dbId;
    @SerializedName(value="tblId")
    private long tblId;
    @SerializedName(value="colToComment")
    private Map<String, String> colToComment;
    @SerializedName(value="tblComment")
    private String tblComment;

    private ModifyCommentOperationLog(Type type, long dbId, long tblId, Map<String, String> colToComment, String tblComment) {
        this.type = type;
        this.dbId = dbId;
        this.tblId = tblId;
        this.colToComment = colToComment;
        this.tblComment = tblComment;
    }

    public static ModifyCommentOperationLog forColumn(long dbId, long tblId, Map<String, String> colToComment) {
        return new ModifyCommentOperationLog(Type.COLUMN, dbId, tblId, colToComment, null);
    }

    public static ModifyCommentOperationLog forTable(long dbId, long tblId, String comment) {
        return new ModifyCommentOperationLog(Type.TABLE, dbId, tblId, null, comment);
    }

    public Type getType() {
        return this.type;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTblId() {
        return this.tblId;
    }

    public Map<String, String> getColToComment() {
        return this.colToComment;
    }

    public String getTblComment() {
        return this.tblComment;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static ModifyCommentOperationLog read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (ModifyCommentOperationLog)GsonUtils.GSON.fromJson(json, ModifyCommentOperationLog.class);
    }

    public static enum Type {
        COLUMN,
        TABLE;

    }
}

