/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import java.io.File;
import java.io.IOException;
import org.apache.doris.persist.Storage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetaCleaner {
    private static final Logger LOG = LogManager.getLogger(MetaCleaner.class);
    private String imageDir;

    public MetaCleaner(String imageDir) {
        this.imageDir = imageDir;
    }

    public void clean() throws IOException {
        Storage storage = new Storage(this.imageDir);
        long currentVersion = storage.getLatestValidatedImageSeq();
        long imageDeleteVersion = currentVersion - 1L;
        File currentImage = storage.getImageFile(currentVersion);
        if (currentImage.exists()) {
            File[] children;
            File metaDir = new File(this.imageDir);
            for (File file : children = metaDir.listFiles()) {
                long version;
                String type = this.fileType(file);
                if (type == null) continue;
                String filename = file.getName();
                if (!type.equalsIgnoreCase("image")) continue;
                if (filename.endsWith(".part")) {
                    filename = filename.substring(0, filename.length() - ".part".length());
                }
                if ((version = Long.parseLong(filename.substring(filename.lastIndexOf(46) + 1))) >= imageDeleteVersion) continue;
                if (file.delete()) {
                    LOG.info(file.getAbsoluteFile() + " deleted.");
                    continue;
                }
                LOG.warn(file.getAbsoluteFile() + " delete failed.");
            }
        }
    }

    public void cleanTheLatestInvalidImageFile(String path) throws IOException {
        File latestInvalidImage = new File(path);
        if (latestInvalidImage.exists()) {
            if (latestInvalidImage.delete()) {
                LOG.info(latestInvalidImage.getAbsoluteFile() + " deleted.");
            } else {
                LOG.warn(latestInvalidImage.getAbsoluteFile() + " delete failed.");
            }
        }
    }

    private String fileType(File file) throws IOException {
        String type = null;
        String filename = file.getName();
        if (filename.equals("image.ckpt")) {
            type = "image.ckpt";
        } else {
            if (filename.endsWith(".part")) {
                filename = filename.substring(0, filename.length() - ".part".length());
            }
            if (filename.contains(".")) {
                if (filename.startsWith("image")) {
                    type = "image";
                }
                if (filename.startsWith("edits")) {
                    type = "edits";
                }
            }
        }
        return type;
    }
}

