/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.SymmetricEncryption;
import org.apache.doris.persist.gson.GsonUtils;

public class LdapInfo
implements Writable {
    @SerializedName(value="ldapPasswd")
    private String ldapPasswdEncrypted;
    @SerializedName(value="secretKey")
    private byte[] secretKey;
    @SerializedName(value="iv")
    private byte[] iv;

    public LdapInfo() {
    }

    public LdapInfo(String ldapPasswd) {
        this.secretKey = SymmetricEncryption.generateKey();
        this.iv = SymmetricEncryption.generateIv();
        this.ldapPasswdEncrypted = SymmetricEncryption.encrypt(ldapPasswd, this.secretKey, this.iv);
    }

    public boolean isValid() {
        return this.ldapPasswdEncrypted != null && this.secretKey != null && this.iv != null;
    }

    public String getLdapPasswdEncrypted() {
        return this.ldapPasswdEncrypted;
    }

    public byte[] getSecretKey() {
        return this.secretKey;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static LdapInfo read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (LdapInfo)GsonUtils.GSON.fromJson(json, LdapInfo.class);
    }
}

