/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.common.io.Writable;
import org.apache.doris.system.HeartbeatResponse;

public class HbPackage
implements Writable {
    private List<HeartbeatResponse> hbResults = Lists.newArrayList();

    public void addHbResponse(HeartbeatResponse result) {
        this.hbResults.add(result);
    }

    public List<HeartbeatResponse> getHbResults() {
        return this.hbResults;
    }

    public static HbPackage read(DataInput in) throws IOException {
        HbPackage hbPackage = new HbPackage();
        hbPackage.readFields(in);
        return hbPackage;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.hbResults.size());
        for (HeartbeatResponse heartbeatResult : this.hbResults) {
            heartbeatResult.write(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            HeartbeatResponse result = HeartbeatResponse.read(in);
            this.hbResults.add(result);
        }
    }
}

