/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.qe.GlobalVariable;
import org.apache.doris.qe.SessionVariable;
import org.apache.doris.qe.VariableMgr;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.simple.JSONObject;

public class GlobalVarPersistInfo
implements Writable {
    private static final Logger LOG = LogManager.getLogger(GlobalVarPersistInfo.class);
    private SessionVariable defaultSessionVariable;
    private List<String> varNames;
    private String persistJsonString;

    private GlobalVarPersistInfo() {
    }

    public GlobalVarPersistInfo(SessionVariable defaultSessionVariable, List<String> varNames) {
        this.defaultSessionVariable = defaultSessionVariable;
        this.varNames = varNames;
    }

    public String getPersistJsonString() {
        return this.persistJsonString;
    }

    public void write(DataOutput out) throws IOException {
        try {
            JSONObject root = new JSONObject();
            block18: for (String varName : this.varNames) {
                VariableMgr.VarAttr attr;
                SessionVariable varInstance = null;
                Field theField = null;
                boolean found = false;
                for (Field field : SessionVariable.class.getDeclaredFields()) {
                    attr = field.getAnnotation(VariableMgr.VarAttr.class);
                    if (attr == null || !attr.name().equalsIgnoreCase(varName)) continue;
                    varInstance = this.defaultSessionVariable;
                    theField = field;
                    found = true;
                    break;
                }
                if (!found) {
                    for (Field field : GlobalVariable.class.getDeclaredFields()) {
                        attr = field.getAnnotation(VariableMgr.VarAttr.class);
                        if (attr == null || !attr.name().equalsIgnoreCase(varName)) continue;
                        found = true;
                        varInstance = null;
                        theField = field;
                        break;
                    }
                }
                Preconditions.checkState((boolean)found, (Object)varName);
                theField.setAccessible(true);
                String fieldName = theField.getAnnotation(VariableMgr.VarAttr.class).name();
                switch (theField.getType().getSimpleName()) {
                    case "boolean": {
                        root.put((Object)fieldName, (Object)((Boolean)theField.get(varInstance)));
                        continue block18;
                    }
                    case "int": {
                        root.put((Object)fieldName, (Object)((Integer)theField.get(varInstance)));
                        continue block18;
                    }
                    case "long": {
                        root.put((Object)fieldName, (Object)((Long)theField.get(varInstance)));
                        continue block18;
                    }
                    case "float": {
                        root.put((Object)fieldName, (Object)((Float)theField.get(varInstance)));
                        continue block18;
                    }
                    case "double": {
                        root.put((Object)fieldName, (Object)((Double)theField.get(varInstance)));
                        continue block18;
                    }
                    case "String": {
                        root.put((Object)fieldName, (Object)((String)theField.get(varInstance)));
                        continue block18;
                    }
                }
                throw new IOException("invalid type: " + theField.getType().getSimpleName());
            }
            Text.writeString((DataOutput)out, (String)root.toString());
        }
        catch (Exception e) {
            throw new IOException("failed to write session variable: " + e.getMessage());
        }
    }

    public static GlobalVarPersistInfo read(DataInput in) throws IOException {
        GlobalVarPersistInfo info = new GlobalVarPersistInfo();
        info.persistJsonString = Text.readString((DataInput)in);
        return info;
    }
}

