/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.doris.common.io.Writable;

public abstract class EditLogOutputStream
extends OutputStream {
    private long numSync = 0L;
    private long totalTimeSync = 0L;

    EditLogOutputStream() throws IOException {
    }

    abstract String getName();

    @Override
    public abstract void write(int var1) throws IOException;

    public abstract void write(short var1, Writable var2) throws IOException;

    abstract void create() throws IOException;

    @Override
    public abstract void close() throws IOException;

    public abstract void setReadyToFlush() throws IOException;

    protected abstract void flushAndSync() throws IOException;

    @Override
    public void flush() throws IOException {
        ++this.numSync;
        long start = System.currentTimeMillis();
        this.flushAndSync();
        long end = System.currentTimeMillis();
        this.totalTimeSync += end - start;
    }

    abstract long length() throws IOException;

    long getTotalSyncTime() {
        return this.totalTimeSync;
    }

    long getNumSync() {
        return this.numSync;
    }
}

