/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import java.io.DataOutput;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.doris.common.io.DataOutputBuffer;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.EditLogOutputStream;

public class EditLogFileOutputStream
extends EditLogOutputStream {
    private File file;
    private FileOutputStream fp;
    private FileChannel fc;
    private DataOutputBuffer bufCurrent;
    private DataOutputBuffer bufReady;
    static ByteBuffer fill = ByteBuffer.allocateDirect(512);
    private static int sizeFlushBuffer = 524288;

    public EditLogFileOutputStream(File name) throws IOException {
        this.file = name;
        this.bufCurrent = new DataOutputBuffer(sizeFlushBuffer);
        this.bufReady = new DataOutputBuffer(sizeFlushBuffer);
        RandomAccessFile rp = new RandomAccessFile(name, "rw");
        this.fp = new FileOutputStream(rp.getFD());
        this.fc = rp.getChannel();
        this.fc.position(this.fc.size());
    }

    @Override
    String getName() {
        return this.file.getPath();
    }

    @Override
    public void write(int b) throws IOException {
        this.bufCurrent.write(b);
    }

    @Override
    public void write(short op, Writable writable) throws IOException {
        this.write(op);
        writable.write((DataOutput)this.bufCurrent);
    }

    @Override
    void create() throws IOException {
        this.fc.truncate(0L);
        this.fc.position(0L);
        this.setReadyToFlush();
        this.flush();
    }

    @Override
    public void close() throws IOException {
        int bufSize = this.bufCurrent.size();
        if (bufSize != 0) {
            throw new IOException("EditStream has " + bufSize + " bytes still to be flushed and cannot be closed.");
        }
        this.bufCurrent.close();
        this.bufReady.close();
        this.fc.truncate(this.fc.position());
        this.fp.close();
        this.bufCurrent = null;
        this.bufReady = null;
    }

    @Override
    public void setReadyToFlush() throws IOException {
        assert (this.bufReady.size() == 0) : "previous data is not flushed yet";
        this.write(-1);
        DataOutputBuffer tmp = this.bufReady;
        this.bufReady = this.bufCurrent;
        this.bufCurrent = tmp;
    }

    @Override
    protected void flushAndSync() throws IOException {
        this.preallocate();
        this.bufReady.writeTo((OutputStream)this.fp);
        this.bufReady.reset();
        this.fc.force(false);
        this.fc.position(this.fc.position() - 1L);
    }

    @Override
    long length() throws IOException {
        return this.fc.size() + (long)this.bufReady.size() + (long)this.bufCurrent.size();
    }

    private void preallocate() throws IOException {
        long position = this.fc.position();
        if (position + 4096L >= this.fc.size()) {
            long newSize = position + 0x100000L;
            fill.position(0);
            this.fc.write(fill, newSize);
        }
    }

    File getFile() {
        return this.file;
    }
}

