/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.doris.alter.AlterJobV2;
import org.apache.doris.alter.BatchAlterJobPersistInfo;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.backup.BackupJob;
import org.apache.doris.backup.Repository;
import org.apache.doris.backup.RestoreJob;
import org.apache.doris.blockrule.SqlBlockRule;
import org.apache.doris.catalog.BrokerMgr;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.Database;
import org.apache.doris.catalog.EncryptKey;
import org.apache.doris.catalog.EncryptKeyHelper;
import org.apache.doris.catalog.EncryptKeySearchDesc;
import org.apache.doris.catalog.Function;
import org.apache.doris.catalog.FunctionSearchDesc;
import org.apache.doris.catalog.Resource;
import org.apache.doris.cluster.BaseParam;
import org.apache.doris.cluster.Cluster;
import org.apache.doris.common.Config;
import org.apache.doris.common.FeConstants;
import org.apache.doris.common.MetaNotFoundException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.common.util.SmallFileMgr;
import org.apache.doris.ha.MasterInfo;
import org.apache.doris.journal.Journal;
import org.apache.doris.journal.JournalCursor;
import org.apache.doris.journal.JournalEntity;
import org.apache.doris.journal.bdbje.BDBJEJournal;
import org.apache.doris.journal.bdbje.Timestamp;
import org.apache.doris.load.DeleteHandler;
import org.apache.doris.load.DeleteInfo;
import org.apache.doris.load.ExportJob;
import org.apache.doris.load.ExportMgr;
import org.apache.doris.load.Load;
import org.apache.doris.load.LoadErrorHub;
import org.apache.doris.load.StreamLoadRecordMgr;
import org.apache.doris.load.loadv2.LoadJob;
import org.apache.doris.load.loadv2.LoadJobFinalOperation;
import org.apache.doris.load.routineload.RoutineLoadJob;
import org.apache.doris.load.sync.SyncJob;
import org.apache.doris.meta.MetaContext;
import org.apache.doris.metric.MetricRepo;
import org.apache.doris.mysql.privilege.UserPropertyInfo;
import org.apache.doris.persist.AlterRoutineLoadJobOperationLog;
import org.apache.doris.persist.AlterViewInfo;
import org.apache.doris.persist.BackendIdsUpdateInfo;
import org.apache.doris.persist.BackendReplicasInfo;
import org.apache.doris.persist.BackendTabletsInfo;
import org.apache.doris.persist.BatchDropInfo;
import org.apache.doris.persist.BatchModifyPartitionsInfo;
import org.apache.doris.persist.BatchRemoveTransactionsOperation;
import org.apache.doris.persist.ClusterInfo;
import org.apache.doris.persist.ColocatePersistInfo;
import org.apache.doris.persist.ConsistencyCheckInfo;
import org.apache.doris.persist.CreateTableInfo;
import org.apache.doris.persist.DatabaseInfo;
import org.apache.doris.persist.DropDbInfo;
import org.apache.doris.persist.DropInfo;
import org.apache.doris.persist.DropLinkDbAndUpdateDbInfo;
import org.apache.doris.persist.DropPartitionInfo;
import org.apache.doris.persist.DropResourceOperationLog;
import org.apache.doris.persist.DropSqlBlockRuleOperationLog;
import org.apache.doris.persist.EditLogFileOutputStream;
import org.apache.doris.persist.EditLogOutputStream;
import org.apache.doris.persist.GlobalVarPersistInfo;
import org.apache.doris.persist.HbPackage;
import org.apache.doris.persist.LdapInfo;
import org.apache.doris.persist.ModifyCommentOperationLog;
import org.apache.doris.persist.ModifyPartitionInfo;
import org.apache.doris.persist.ModifyTableDefaultDistributionBucketNumOperationLog;
import org.apache.doris.persist.ModifyTableEngineOperationLog;
import org.apache.doris.persist.ModifyTablePropertyOperationLog;
import org.apache.doris.persist.PartitionPersistInfo;
import org.apache.doris.persist.PrivInfo;
import org.apache.doris.persist.RecoverInfo;
import org.apache.doris.persist.RefreshExternalTableInfo;
import org.apache.doris.persist.RemoveAlterJobV2OperationLog;
import org.apache.doris.persist.ReplacePartitionOperationLog;
import org.apache.doris.persist.ReplaceTableOperationLog;
import org.apache.doris.persist.ReplicaPersistInfo;
import org.apache.doris.persist.RoutineLoadOperation;
import org.apache.doris.persist.SetReplicaStatusOperationLog;
import org.apache.doris.persist.TableInfo;
import org.apache.doris.persist.TablePropertyInfo;
import org.apache.doris.persist.TruncateTableInfo;
import org.apache.doris.plugin.PluginInfo;
import org.apache.doris.system.Backend;
import org.apache.doris.system.Frontend;
import org.apache.doris.transaction.TransactionState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EditLog {
    public static final Logger LOG = LogManager.getLogger(EditLog.class);
    private EditLogOutputStream editStream = null;
    private long txId = 0L;
    private long numTransactions;
    private long totalTimeTransactions;
    private Journal journal;

    public EditLog(String nodeName) {
        this.journal = new BDBJEJournal(nodeName);
    }

    public long getMaxJournalId() {
        return this.journal.getMaxJournalId();
    }

    public long getMinJournalId() {
        return this.journal.getMinJournalId();
    }

    public JournalCursor read(long fromId, long toId) {
        return this.journal.read(fromId, toId);
    }

    public long getFinalizedJournalId() {
        return this.journal.getFinalizedJournalId();
    }

    public void deleteJournals(long deleteToJournalId) {
        this.journal.deleteJournals(deleteToJournalId);
    }

    public List<Long> getDatabaseNames() {
        return this.journal.getDatabaseNames();
    }

    public synchronized int getNumEditStreams() {
        return this.journal == null ? 0 : 1;
    }

    public static void loadJournal(Catalog catalog, JournalEntity journal) {
        short opCode = journal.getOpCode();
        if (opCode != 0 && opCode != 70) {
            LOG.debug("replay journal op code: {}", (Object)opCode);
        }
        try {
            block1 : switch (opCode) {
                case 0: {
                    String idString = ((Text)journal.getData()).toString();
                    long id = Long.parseLong(idString);
                    catalog.setNextId(id + 1L);
                    break;
                }
                case 104: {
                    String idString = ((Text)journal.getData()).toString();
                    long id = Long.parseLong(idString);
                    Catalog.getCurrentGlobalTransactionMgr().getTransactionIDGenerator().initTransactionId(id + 1L);
                    break;
                }
                case 1: {
                    Database db = (Database)journal.getData();
                    catalog.replayCreateDb(db);
                    break;
                }
                case 2: {
                    DropDbInfo dropDbInfo = (DropDbInfo)journal.getData();
                    catalog.replayDropDb(dropDbInfo.getDbName(), dropDbInfo.isForceDrop());
                    break;
                }
                case 3: {
                    DatabaseInfo dbInfo = (DatabaseInfo)journal.getData();
                    String dbName = dbInfo.getDbName();
                    LOG.info("Begin to unprotect alter db info {}", (Object)dbName);
                    catalog.replayAlterDatabaseQuota(dbName, dbInfo.getQuota(), dbInfo.getQuotaType());
                    break;
                }
                case 4: {
                    Text dbId = (Text)journal.getData();
                    catalog.replayEraseDatabase(Long.parseLong(dbId.toString()));
                    break;
                }
                case 5: {
                    RecoverInfo info = (RecoverInfo)journal.getData();
                    catalog.replayRecoverDatabase(info);
                    break;
                }
                case 6: {
                    DatabaseInfo dbInfo = (DatabaseInfo)journal.getData();
                    String dbName = dbInfo.getDbName();
                    LOG.info("Begin to unprotect rename db {}", (Object)dbName);
                    catalog.replayRenameDatabase(dbName, dbInfo.getNewDbName());
                    break;
                }
                case 10: {
                    CreateTableInfo info = (CreateTableInfo)journal.getData();
                    LOG.info("Begin to unprotect create table. db = " + info.getDbName() + " table = " + info.getTable().getId());
                    catalog.replayCreateTable(info.getDbName(), info.getTable());
                    break;
                }
                case 280: {
                    RefreshExternalTableInfo info = (RefreshExternalTableInfo)journal.getData();
                    LOG.info("Begin to unprotect alter external table schema. db = " + info.getDbName() + " table = " + info.getTableName());
                    catalog.replayAlterExternalTableSchema(info.getDbName(), info.getTableName(), info.getNewSchema());
                    break;
                }
                case 11: {
                    DropInfo info = (DropInfo)journal.getData();
                    Database db = Catalog.getCurrentCatalog().getDbOrMetaException(info.getDbId());
                    LOG.info("Begin to unprotect drop table. db = " + db.getFullName() + " table = " + info.getTableId());
                    catalog.replayDropTable(db, info.getTableId(), info.isForceDrop());
                    break;
                }
                case 12: {
                    PartitionPersistInfo info = (PartitionPersistInfo)journal.getData();
                    LOG.info("Begin to unprotect add partition. db = " + info.getDbId() + " table = " + info.getTableId() + " partitionName = " + info.getPartition().getName());
                    catalog.replayAddPartition(info);
                    break;
                }
                case 13: {
                    DropPartitionInfo info = (DropPartitionInfo)journal.getData();
                    LOG.info("Begin to unprotect drop partition. db = " + info.getDbId() + " table = " + info.getTableId() + " partitionName = " + info.getPartitionName());
                    catalog.replayDropPartition(info);
                    break;
                }
                case 14: {
                    ModifyPartitionInfo info = (ModifyPartitionInfo)journal.getData();
                    LOG.info("Begin to unprotect modify partition. db = " + info.getDbId() + " table = " + info.getTableId() + " partitionId = " + info.getPartitionId());
                    catalog.getAlterInstance().replayModifyPartition(info);
                    break;
                }
                case 211: {
                    BatchModifyPartitionsInfo info = (BatchModifyPartitionsInfo)journal.getData();
                    for (ModifyPartitionInfo modifyPartitionInfo : info.getModifyPartitionInfos()) {
                        catalog.getAlterInstance().replayModifyPartition(modifyPartitionInfo);
                    }
                    break;
                }
                case 15: {
                    Text tableId = (Text)journal.getData();
                    catalog.replayEraseTable(Long.parseLong(tableId.toString()));
                    break;
                }
                case 16: {
                    Text partitionId = (Text)journal.getData();
                    catalog.replayErasePartition(Long.parseLong(partitionId.toString()));
                    break;
                }
                case 17: {
                    RecoverInfo info = (RecoverInfo)journal.getData();
                    catalog.replayRecoverTable(info);
                    break;
                }
                case 18: {
                    RecoverInfo info = (RecoverInfo)journal.getData();
                    catalog.replayRecoverPartition(info);
                    break;
                }
                case 19: {
                    TableInfo info = (TableInfo)journal.getData();
                    catalog.replayRenameTable(info);
                    break;
                }
                case 119: {
                    AlterViewInfo info = (AlterViewInfo)journal.getData();
                    catalog.getAlterInstance().replayModifyViewDef(info);
                    break;
                }
                case 110: {
                    TableInfo info = (TableInfo)journal.getData();
                    catalog.replayRenamePartition(info);
                    break;
                }
                case 116: {
                    BackupJob job = (BackupJob)journal.getData();
                    catalog.getBackupHandler().replayAddJob(job);
                    break;
                }
                case 117: {
                    RestoreJob job = (RestoreJob)journal.getData();
                    job.setCatalog(catalog);
                    catalog.getBackupHandler().replayAddJob(job);
                    break;
                }
                case 24: {
                    DropInfo info = (DropInfo)journal.getData();
                    catalog.getMaterializedViewHandler().replayDropRollup(info, catalog);
                    break;
                }
                case 124: {
                    BatchDropInfo batchDropInfo = (BatchDropInfo)journal.getData();
                    for (long indexId : batchDropInfo.getIndexIdSet()) {
                        catalog.getMaterializedViewHandler().replayDropRollup(new DropInfo(batchDropInfo.getDbId(), batchDropInfo.getTableId(), indexId, false), catalog);
                    }
                    break;
                }
                case 29: {
                    ConsistencyCheckInfo info = (ConsistencyCheckInfo)journal.getData();
                    catalog.getConsistencyChecker().replayFinishConsistencyCheck(info, catalog);
                    break;
                }
                case 28: {
                    ReplicaPersistInfo info = (ReplicaPersistInfo)journal.getData();
                    catalog.getLoadInstance().replayClearRollupInfo(info, catalog);
                    break;
                }
                case 120: {
                    TableInfo info = (TableInfo)journal.getData();
                    catalog.replayRenameRollup(info);
                    break;
                }
                case 30: {
                    org.apache.doris.load.LoadJob job = (org.apache.doris.load.LoadJob)journal.getData();
                    catalog.getLoadInstance().replayAddLoadJob(job);
                    break;
                }
                case 31: {
                    org.apache.doris.load.LoadJob job = (org.apache.doris.load.LoadJob)journal.getData();
                    catalog.getLoadInstance().replayEtlLoadJob(job);
                    break;
                }
                case 32: {
                    org.apache.doris.load.LoadJob job = (org.apache.doris.load.LoadJob)journal.getData();
                    catalog.getLoadInstance().replayLoadingLoadJob(job);
                    break;
                }
                case 33: {
                    org.apache.doris.load.LoadJob job = (org.apache.doris.load.LoadJob)journal.getData();
                    Load load = catalog.getLoadInstance();
                    load.replayQuorumLoadJob(job, catalog);
                    break;
                }
                case 34: {
                    org.apache.doris.load.LoadJob job = (org.apache.doris.load.LoadJob)journal.getData();
                    Load load = catalog.getLoadInstance();
                    load.replayFinishLoadJob(job, catalog);
                    break;
                }
                case 35: {
                    org.apache.doris.load.LoadJob job = (org.apache.doris.load.LoadJob)journal.getData();
                    Load load = catalog.getLoadInstance();
                    load.replayCancelLoadJob(job);
                    break;
                }
                case 36: {
                    ExportJob job = (ExportJob)journal.getData();
                    ExportMgr exportMgr = catalog.getExportMgr();
                    exportMgr.replayCreateExportJob(job);
                    break;
                }
                case 37: {
                    ExportJob.StateTransfer op = (ExportJob.StateTransfer)journal.getData();
                    ExportMgr exportMgr = catalog.getExportMgr();
                    exportMgr.replayUpdateJobState(op.getJobId(), op.getState());
                    break;
                }
                case 41: {
                    DeleteInfo info = (DeleteInfo)journal.getData();
                    DeleteHandler deleteHandler = catalog.getDeleteHandler();
                    deleteHandler.replayDelete(info, catalog);
                    break;
                }
                case 42: {
                    ReplicaPersistInfo info = (ReplicaPersistInfo)journal.getData();
                    catalog.replayAddReplica(info);
                    break;
                }
                case 45: {
                    ReplicaPersistInfo info = (ReplicaPersistInfo)journal.getData();
                    catalog.replayUpdateReplica(info);
                    break;
                }
                case 43: {
                    ReplicaPersistInfo info = (ReplicaPersistInfo)journal.getData();
                    catalog.replayDeleteReplica(info);
                    break;
                }
                case 50: {
                    Backend be = (Backend)journal.getData();
                    Catalog.getCurrentSystemInfo().replayAddBackend(be);
                    break;
                }
                case 51: {
                    Backend be = (Backend)journal.getData();
                    Catalog.getCurrentSystemInfo().replayDropBackend(be);
                    break;
                }
                case 91: {
                    Backend be = (Backend)journal.getData();
                    Catalog.getCurrentSystemInfo().replayModifyBackend(be);
                    break;
                }
                case 52: {
                    Backend be = (Backend)journal.getData();
                    Catalog.getCurrentSystemInfo().updateBackendState(be);
                    break;
                }
                case 55: 
                case 56: {
                    Frontend fe = (Frontend)journal.getData();
                    catalog.replayAddFrontend(fe);
                    break;
                }
                case 57: {
                    Frontend fe = (Frontend)journal.getData();
                    catalog.replayDropFrontend(fe);
                    if (fe.getNodeName().equals(Catalog.getCurrentCatalog().getNodeName())) {
                        System.out.println("current fe " + fe + " is removed. will exit");
                        LOG.info("current fe " + fe + " is removed. will exit");
                        System.exit(-1);
                    }
                    break;
                }
                case 62: {
                    PrivInfo privInfo = (PrivInfo)journal.getData();
                    catalog.getAuth().replayCreateUser(privInfo);
                    break;
                }
                case 63: {
                    UserIdentity userIdent = (UserIdentity)journal.getData();
                    catalog.getAuth().replayDropUser(userIdent);
                    break;
                }
                case 64: {
                    PrivInfo privInfo = (PrivInfo)journal.getData();
                    catalog.getAuth().replayGrant(privInfo);
                    break;
                }
                case 65: {
                    PrivInfo privInfo = (PrivInfo)journal.getData();
                    catalog.getAuth().replayRevoke(privInfo);
                    break;
                }
                case 66: {
                    PrivInfo privInfo = (PrivInfo)journal.getData();
                    catalog.getAuth().replaySetPassword(privInfo);
                    break;
                }
                case 290: {
                    LdapInfo ldapInfo = (LdapInfo)journal.getData();
                    catalog.getAuth().replaySetLdapPassword(ldapInfo);
                    break;
                }
                case 67: {
                    PrivInfo privInfo = (PrivInfo)journal.getData();
                    catalog.getAuth().replayCreateRole(privInfo);
                    break;
                }
                case 68: {
                    PrivInfo privInfo = (PrivInfo)journal.getData();
                    catalog.getAuth().replayDropRole(privInfo);
                    break;
                }
                case 69: {
                    UserPropertyInfo propertyInfo = (UserPropertyInfo)journal.getData();
                    catalog.getAuth().replayUpdateUserProperty(propertyInfo);
                    break;
                }
                case 70: {
                    Timestamp stamp = (Timestamp)journal.getData();
                    catalog.setSynchronizedTime(stamp.getTimestamp());
                    break;
                }
                case 71: {
                    MasterInfo info = (MasterInfo)journal.getData();
                    catalog.setMaster(info);
                    break;
                }
                case 72: {
                    String versionString = ((Text)journal.getData()).toString();
                    int version = Integer.parseInt(versionString);
                    if (version > FeConstants.meta_version) {
                        LOG.error("meta data version is out of date, image: {}. meta: {}.please update FeConstants.meta_version and restart.", (Object)MetaContext.get().getMetaVersion(), (Object)FeConstants.meta_version);
                        System.exit(-1);
                    }
                    MetaContext.get().setMetaVersion(version);
                    break;
                }
                case 74: {
                    Cluster value = (Cluster)journal.getData();
                    catalog.replayCreateCluster(value);
                    break;
                }
                case 75: {
                    ClusterInfo value = (ClusterInfo)journal.getData();
                    catalog.replayDropCluster(value);
                    break;
                }
                case 76: {
                    ClusterInfo info = (ClusterInfo)journal.getData();
                    catalog.replayExpandCluster(info);
                    break;
                }
                case 78: {
                    BaseParam param = (BaseParam)journal.getData();
                    catalog.replayLinkDb(param);
                    break;
                }
                case 77: {
                    BaseParam param = (BaseParam)journal.getData();
                    catalog.replayMigrateDb(param);
                    break;
                }
                case 82: {
                    DatabaseInfo param = (DatabaseInfo)journal.getData();
                    catalog.replayUpdateDb(param);
                    break;
                }
                case 83: {
                    DropLinkDbAndUpdateDbInfo param = (DropLinkDbAndUpdateDbInfo)journal.getData();
                    catalog.replayDropLinkDb(param);
                    break;
                }
                case 85: {
                    BrokerMgr.ModifyBrokerInfo param = (BrokerMgr.ModifyBrokerInfo)journal.getData();
                    catalog.getBrokerMgr().replayAddBrokers(param.brokerName, param.brokerAddresses);
                    break;
                }
                case 86: {
                    BrokerMgr.ModifyBrokerInfo param = (BrokerMgr.ModifyBrokerInfo)journal.getData();
                    catalog.getBrokerMgr().replayDropBrokers(param.brokerName, param.brokerAddresses);
                    break;
                }
                case 87: {
                    String param = journal.getData().toString();
                    catalog.getBrokerMgr().replayDropAllBroker(param);
                    break;
                }
                case 58: {
                    LoadErrorHub.Param param = (LoadErrorHub.Param)journal.getData();
                    catalog.getLoadInstance().setLoadErrorHubInfo(param);
                    break;
                }
                case 88: {
                    BackendIdsUpdateInfo info = (BackendIdsUpdateInfo)journal.getData();
                    catalog.replayUpdateClusterAndBackends(info);
                    break;
                }
                case 100: {
                    TransactionState state = (TransactionState)journal.getData();
                    Catalog.getCurrentGlobalTransactionMgr().replayUpsertTransactionState(state);
                    LOG.debug("opcode: {}, tid: {}", (Object)opCode, (Object)state.getTransactionId());
                    break;
                }
                case 101: {
                    TransactionState state = (TransactionState)journal.getData();
                    Catalog.getCurrentGlobalTransactionMgr().replayDeleteTransactionState(state);
                    LOG.debug("opcode: {}, tid: {}", (Object)opCode, (Object)state.getTransactionId());
                    break;
                }
                case 105: {
                    BatchRemoveTransactionsOperation operation = (BatchRemoveTransactionsOperation)journal.getData();
                    Catalog.getCurrentGlobalTransactionMgr().replayBatchRemoveTransactions(operation);
                    break;
                }
                case 89: {
                    Repository repository = (Repository)journal.getData();
                    catalog.getBackupHandler().getRepoMgr().addAndInitRepoIfNotExist(repository, true);
                    break;
                }
                case 90: {
                    String repoName = ((Text)journal.getData()).toString();
                    catalog.getBackupHandler().getRepoMgr().removeRepo(repoName, true);
                    break;
                }
                case 118: {
                    TruncateTableInfo info = (TruncateTableInfo)journal.getData();
                    catalog.replayTruncateTable(info);
                    break;
                }
                case 94: {
                    ColocatePersistInfo info = (ColocatePersistInfo)journal.getData();
                    catalog.getColocateTableIndex().replayAddTableToGroup(info);
                    break;
                }
                case 95: {
                    ColocatePersistInfo info = (ColocatePersistInfo)journal.getData();
                    catalog.getColocateTableIndex().replayRemoveTable(info);
                    break;
                }
                case 96: {
                    ColocatePersistInfo info = (ColocatePersistInfo)journal.getData();
                    catalog.getColocateTableIndex().replayAddBackendsPerBucketSeq(info);
                    break;
                }
                case 97: {
                    ColocatePersistInfo info = (ColocatePersistInfo)journal.getData();
                    catalog.getColocateTableIndex().replayMarkGroupUnstable(info);
                    break;
                }
                case 98: {
                    ColocatePersistInfo info = (ColocatePersistInfo)journal.getData();
                    catalog.getColocateTableIndex().replayMarkGroupStable(info);
                    break;
                }
                case 99: {
                    TablePropertyInfo info = (TablePropertyInfo)journal.getData();
                    catalog.replayModifyTableColocate(info);
                    break;
                }
                case 59: {
                    HbPackage hbPackage = (HbPackage)journal.getData();
                    Catalog.getCurrentHeartbeatMgr().replayHearbeat(hbPackage);
                    break;
                }
                case 130: {
                    Function function = (Function)journal.getData();
                    Catalog.getCurrentCatalog().replayCreateFunction(function);
                    break;
                }
                case 131: {
                    FunctionSearchDesc function = (FunctionSearchDesc)journal.getData();
                    Catalog.getCurrentCatalog().replayDropFunction(function);
                    break;
                }
                case 253: {
                    EncryptKey encryptKey = (EncryptKey)journal.getData();
                    EncryptKeyHelper.replayCreateEncryptKey(encryptKey);
                    break;
                }
                case 254: {
                    EncryptKeySearchDesc encryptKeySearchDesc = (EncryptKeySearchDesc)journal.getData();
                    EncryptKeyHelper.replayDropEncryptKey(encryptKeySearchDesc);
                    break;
                }
                case 46: {
                    BackendTabletsInfo backendTabletsInfo = (BackendTabletsInfo)journal.getData();
                    Catalog.getCurrentCatalog().replayBackendTabletsInfo(backendTabletsInfo);
                    break;
                }
                case 48: {
                    BackendReplicasInfo backendReplicasInfo = (BackendReplicasInfo)journal.getData();
                    Catalog.getCurrentCatalog().replayBackendReplicasInfo(backendReplicasInfo);
                    break;
                }
                case 200: {
                    RoutineLoadJob routineLoadJob = (RoutineLoadJob)journal.getData();
                    Catalog.getCurrentCatalog().getRoutineLoadManager().replayCreateRoutineLoadJob(routineLoadJob);
                    break;
                }
                case 201: {
                    RoutineLoadOperation operation = (RoutineLoadOperation)journal.getData();
                    Catalog.getCurrentCatalog().getRoutineLoadManager().replayChangeRoutineLoadJob(operation);
                    break;
                }
                case 202: {
                    RoutineLoadOperation operation = (RoutineLoadOperation)journal.getData();
                    catalog.getRoutineLoadManager().replayRemoveOldRoutineLoad(operation);
                    break;
                }
                case 230: {
                    LoadJob loadJob = (LoadJob)journal.getData();
                    catalog.getLoadManager().replayCreateLoadJob(loadJob);
                    break;
                }
                case 231: {
                    LoadJobFinalOperation operation = (LoadJobFinalOperation)journal.getData();
                    catalog.getLoadManager().replayEndLoadJob(operation);
                    break;
                }
                case 232: {
                    LoadJob.LoadJobStateUpdateInfo info = (LoadJob.LoadJobStateUpdateInfo)journal.getData();
                    catalog.getLoadManager().replayUpdateLoadJobStateInfo(info);
                    break;
                }
                case 234: {
                    SyncJob syncJob = (SyncJob)journal.getData();
                    catalog.getSyncJobManager().replayAddSyncJob(syncJob);
                    break;
                }
                case 235: {
                    SyncJob.SyncJobUpdateStateInfo info = (SyncJob.SyncJobUpdateStateInfo)journal.getData();
                    catalog.getSyncJobManager().replayUpdateSyncJobState(info);
                    break;
                }
                case 233: {
                    StreamLoadRecordMgr.FetchStreamLoadRecord fetchStreamLoadRecord = (StreamLoadRecordMgr.FetchStreamLoadRecord)journal.getData();
                    catalog.getStreamLoadRecordMgr().replayFetchStreamLoadRecord(fetchStreamLoadRecord);
                    break;
                }
                case 276: {
                    Resource resource = (Resource)journal.getData();
                    catalog.getResourceMgr().replayCreateResource(resource);
                    break;
                }
                case 277: {
                    DropResourceOperationLog operationLog = (DropResourceOperationLog)journal.getData();
                    catalog.getResourceMgr().replayDropResource(operationLog);
                    break;
                }
                case 251: {
                    SmallFileMgr.SmallFile smallFile = (SmallFileMgr.SmallFile)journal.getData();
                    catalog.getSmallFileMgr().replayCreateFile(smallFile);
                    break;
                }
                case 252: {
                    SmallFileMgr.SmallFile smallFile = (SmallFileMgr.SmallFile)journal.getData();
                    catalog.getSmallFileMgr().replayRemoveFile(smallFile);
                    break;
                }
                case 121: {
                    AlterJobV2 alterJob = (AlterJobV2)journal.getData();
                    switch (alterJob.getType()) {
                        case ROLLUP: {
                            catalog.getMaterializedViewHandler().replayAlterJobV2(alterJob);
                            break block1;
                        }
                        case SCHEMA_CHANGE: {
                            catalog.getSchemaChangeHandler().replayAlterJobV2(alterJob);
                            break block1;
                        }
                    }
                    break;
                }
                case 123: {
                    BatchAlterJobPersistInfo batchAlterJobV2 = (BatchAlterJobPersistInfo)journal.getData();
                    for (AlterJobV2 alterJobV2 : batchAlterJobV2.getAlterJobV2List()) {
                        catalog.getMaterializedViewHandler().replayAlterJobV2(alterJobV2);
                    }
                    break;
                }
                case 122: {
                    TableInfo tableInfo = (TableInfo)journal.getData();
                    catalog.replayConvertDistributionType(tableInfo);
                    break;
                }
                case 261: 
                case 266: 
                case 267: {
                    ModifyTablePropertyOperationLog modifyTablePropertyOperationLog = (ModifyTablePropertyOperationLog)journal.getData();
                    catalog.replayModifyTableProperty(opCode, modifyTablePropertyOperationLog);
                    break;
                }
                case 268: {
                    ModifyTableDefaultDistributionBucketNumOperationLog modifyTableDefaultDistributionBucketNumOperationLog = (ModifyTableDefaultDistributionBucketNumOperationLog)journal.getData();
                    catalog.replayModifyTableDefaultDistributionBucketNum(modifyTableDefaultDistributionBucketNumOperationLog);
                    break;
                }
                case 210: {
                    ReplacePartitionOperationLog replaceTempPartitionLog = (ReplacePartitionOperationLog)journal.getData();
                    catalog.replayReplaceTempPartition(replaceTempPartitionLog);
                    break;
                }
                case 270: {
                    PluginInfo pluginInfo = (PluginInfo)journal.getData();
                    catalog.replayInstallPlugin(pluginInfo);
                    break;
                }
                case 271: {
                    PluginInfo pluginInfo = (PluginInfo)journal.getData();
                    catalog.replayUninstallPlugin(pluginInfo);
                    break;
                }
                case 47: {
                    SetReplicaStatusOperationLog log = (SetReplicaStatusOperationLog)journal.getData();
                    catalog.replaySetReplicaStatus(log);
                    break;
                }
                case 125: {
                    RemoveAlterJobV2OperationLog log = (RemoveAlterJobV2OperationLog)journal.getData();
                    switch (log.getType()) {
                        case ROLLUP: {
                            catalog.getMaterializedViewHandler().replayRemoveAlterJobV2(log);
                            break block1;
                        }
                        case SCHEMA_CHANGE: {
                            catalog.getSchemaChangeHandler().replayRemoveAlterJobV2(log);
                            break block1;
                        }
                    }
                    break;
                }
                case 126: {
                    ModifyCommentOperationLog operation = (ModifyCommentOperationLog)journal.getData();
                    catalog.getAlterInstance().replayModifyComment(operation);
                    break;
                }
                case 111: {
                    AlterRoutineLoadJobOperationLog log = (AlterRoutineLoadJobOperationLog)journal.getData();
                    catalog.getRoutineLoadManager().replayAlterRoutineLoadJob(log);
                    break;
                }
                case 84: {
                    GlobalVarPersistInfo info = (GlobalVarPersistInfo)journal.getData();
                    catalog.replayGlobalVariableV2(info);
                    break;
                }
                case 212: {
                    ReplaceTableOperationLog log = (ReplaceTableOperationLog)journal.getData();
                    catalog.getAlterInstance().replayReplaceTable(log);
                    break;
                }
                case 300: {
                    SqlBlockRule rule = (SqlBlockRule)journal.getData();
                    catalog.getSqlBlockRuleMgr().replayCreate(rule);
                    break;
                }
                case 301: {
                    SqlBlockRule rule = (SqlBlockRule)journal.getData();
                    catalog.getSqlBlockRuleMgr().replayAlter(rule);
                    break;
                }
                case 302: {
                    DropSqlBlockRuleOperationLog log = (DropSqlBlockRuleOperationLog)journal.getData();
                    catalog.getSqlBlockRuleMgr().replayDrop(log.getRuleNames());
                    break;
                }
                case 127: {
                    ModifyTableEngineOperationLog log = (ModifyTableEngineOperationLog)journal.getData();
                    catalog.getAlterInstance().replayProcessModifyEngine(log);
                    break;
                }
                default: {
                    IOException e = new IOException();
                    LOG.error("UNKNOWN Operation Type {}", (Object)opCode, (Object)e);
                    throw e;
                }
            }
        }
        catch (MetaNotFoundException e) {
            LOG.warn("[INCONSISTENT META] replay failed {}: {}", (Object)journal, (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            LOG.error("Operation Type {}", (Object)opCode, (Object)e);
            System.exit(-1);
        }
    }

    public synchronized void close() throws IOException {
        this.journal.close();
    }

    public synchronized void createEditLogFile(File name) throws IOException {
        EditLogFileOutputStream editLogOutputStream = new EditLogFileOutputStream(name);
        ((EditLogOutputStream)editLogOutputStream).create();
        ((EditLogOutputStream)editLogOutputStream).close();
    }

    public void open() {
        this.journal.open();
    }

    public void rollEditLog() {
        this.journal.rollJournal();
    }

    private synchronized void logEdit(short op, Writable writable) {
        if (this.getNumEditStreams() == 0) {
            LOG.error("Fatal Error : no editLog stream", (Throwable)new Exception());
            throw new Error("Fatal Error : no editLog stream");
        }
        long start = System.currentTimeMillis();
        try {
            this.journal.write(op, writable);
        }
        catch (Throwable t) {
            LOG.error("Fatal Error : write stream Exception", t);
            System.exit(-1);
        }
        ++this.txId;
        long end = System.currentTimeMillis();
        ++this.numTransactions;
        this.totalTimeTransactions += end - start;
        if (MetricRepo.isInit) {
            MetricRepo.HISTO_EDIT_LOG_WRITE_LATENCY.update(end - start);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("nextId = {}, numTransactions = {}, totalTimeTransactions = {}, op = {}", (Object)this.txId, (Object)this.numTransactions, (Object)this.totalTimeTransactions, (Object)op);
        }
        if (this.txId >= (long)Config.edit_log_roll_num) {
            LOG.info("txId {} is equal to or larger than edit_log_roll_num {}, will roll edit.", (Object)this.txId, (Object)Config.edit_log_roll_num);
            this.rollEditLog();
            this.txId = 0L;
        }
        if (MetricRepo.isInit) {
            MetricRepo.COUNTER_EDIT_LOG_WRITE.increase(1L);
        }
    }

    synchronized long getEditLogSize() throws IOException {
        return this.editStream.length();
    }

    public synchronized long getTxId() {
        return this.txId;
    }

    public void logSaveNextId(long nextId) {
        this.logEdit((short)0, (Writable)new Text(Long.toString(nextId)));
    }

    public void logSaveTransactionId(long transactionId) {
        this.logEdit((short)104, (Writable)new Text(Long.toString(transactionId)));
    }

    public void logCreateDb(Database db) {
        this.logEdit((short)1, db);
    }

    public void logDropDb(DropDbInfo dropDbInfo) {
        this.logEdit((short)2, dropDbInfo);
    }

    public void logEraseDb(long dbId) {
        this.logEdit((short)4, (Writable)new Text(Long.toString(dbId)));
    }

    public void logRecoverDb(RecoverInfo info) {
        this.logEdit((short)5, info);
    }

    public void logAlterDb(DatabaseInfo dbInfo) {
        this.logEdit((short)3, dbInfo);
    }

    public void logCreateTable(CreateTableInfo info) {
        this.logEdit((short)10, info);
    }

    public void logRefreshExternalTableSchema(RefreshExternalTableInfo info) {
        this.logEdit((short)280, info);
    }

    public void logAddPartition(PartitionPersistInfo info) {
        this.logEdit((short)12, info);
    }

    public void logDropPartition(DropPartitionInfo info) {
        this.logEdit((short)13, info);
    }

    public void logErasePartition(long partitionId) {
        this.logEdit((short)16, (Writable)new Text(Long.toString(partitionId)));
    }

    public void logRecoverPartition(RecoverInfo info) {
        this.logEdit((short)18, info);
    }

    public void logModifyPartition(ModifyPartitionInfo info) {
        this.logEdit((short)14, info);
    }

    public void logBatchModifyPartition(BatchModifyPartitionsInfo info) {
        this.logEdit((short)211, info);
    }

    public void logDropTable(DropInfo info) {
        this.logEdit((short)11, info);
    }

    public void logEraseTable(long tableId) {
        this.logEdit((short)15, (Writable)new Text(Long.toString(tableId)));
    }

    public void logRecoverTable(RecoverInfo info) {
        this.logEdit((short)17, info);
    }

    public void logLoadStart(org.apache.doris.load.LoadJob job) {
        this.logEdit((short)30, job);
    }

    public void logLoadEtl(org.apache.doris.load.LoadJob job) {
        this.logEdit((short)31, job);
    }

    public void logLoadLoading(org.apache.doris.load.LoadJob job) {
        this.logEdit((short)32, job);
    }

    public void logLoadQuorum(org.apache.doris.load.LoadJob job) {
        this.logEdit((short)33, job);
    }

    public void logLoadCancel(org.apache.doris.load.LoadJob job) {
        this.logEdit((short)35, job);
    }

    public void logLoadDone(org.apache.doris.load.LoadJob job) {
        this.logEdit((short)34, job);
    }

    public void logDropRollup(DropInfo info) {
        this.logEdit((short)24, info);
    }

    public void logBatchDropRollup(BatchDropInfo batchDropInfo) {
        this.logEdit((short)124, batchDropInfo);
    }

    public void logFinishConsistencyCheck(ConsistencyCheckInfo info) {
        this.logEdit((short)29, info);
    }

    public void logAddBackend(Backend be) {
        this.logEdit((short)50, be);
    }

    public void logDropBackend(Backend be) {
        this.logEdit((short)51, be);
    }

    public void logModifyBackend(Backend be) {
        this.logEdit((short)91, be);
    }

    public void logAddFrontend(Frontend fe) {
        this.logEdit((short)55, fe);
    }

    public void logAddFirstFrontend(Frontend fe) {
        this.logEdit((short)56, fe);
    }

    public void logRemoveFrontend(Frontend fe) {
        this.logEdit((short)57, fe);
    }

    public void logFinishDelete(DeleteInfo info) {
        this.logEdit((short)41, info);
    }

    public void logAddReplica(ReplicaPersistInfo info) {
        this.logEdit((short)42, info);
    }

    public void logUpdateReplica(ReplicaPersistInfo info) {
        this.logEdit((short)45, info);
    }

    public void logDeleteReplica(ReplicaPersistInfo info) {
        this.logEdit((short)43, info);
    }

    public void logTimestamp(Timestamp stamp) {
        this.logEdit((short)70, stamp);
    }

    public void logMasterInfo(MasterInfo info) {
        this.logEdit((short)71, info);
    }

    public void logMetaVersion(int version) {
        this.logEdit((short)72, (Writable)new Text(Integer.toString(version)));
    }

    public void logBackendStateChange(Backend be) {
        this.logEdit((short)52, be);
    }

    public void logCreateUser(PrivInfo info) {
        this.logEdit((short)62, info);
    }

    public void logNewDropUser(UserIdentity userIdent) {
        this.logEdit((short)63, userIdent);
    }

    public void logGrantPriv(PrivInfo info) {
        this.logEdit((short)64, info);
    }

    public void logRevokePriv(PrivInfo info) {
        this.logEdit((short)65, info);
    }

    public void logSetPassword(PrivInfo info) {
        this.logEdit((short)66, info);
    }

    public void logSetLdapPassword(LdapInfo info) {
        this.logEdit((short)290, info);
    }

    public void logCreateRole(PrivInfo info) {
        this.logEdit((short)67, info);
    }

    public void logDropRole(PrivInfo info) {
        this.logEdit((short)68, info);
    }

    public void logDatabaseRename(DatabaseInfo databaseInfo) {
        this.logEdit((short)6, databaseInfo);
    }

    public void logUpdateDatabase(DatabaseInfo databaseInfo) {
        this.logEdit((short)82, databaseInfo);
    }

    public void logTableRename(TableInfo tableInfo) {
        this.logEdit((short)19, tableInfo);
    }

    public void logModifyViewDef(AlterViewInfo alterViewInfo) {
        this.logEdit((short)119, alterViewInfo);
    }

    public void logRollupRename(TableInfo tableInfo) {
        this.logEdit((short)120, tableInfo);
    }

    public void logPartitionRename(TableInfo tableInfo) {
        this.logEdit((short)110, tableInfo);
    }

    public void logCreateCluster(Cluster cluster) {
        this.logEdit((short)74, cluster);
    }

    public void logDropCluster(ClusterInfo info) {
        this.logEdit((short)75, info);
    }

    public void logExpandCluster(ClusterInfo ci) {
        this.logEdit((short)76, ci);
    }

    public void logLinkCluster(BaseParam param) {
        this.logEdit((short)78, param);
    }

    public void logMigrateCluster(BaseParam param) {
        this.logEdit((short)77, param);
    }

    public void logDropLinkDb(DropLinkDbAndUpdateDbInfo info) {
        this.logEdit((short)83, info);
    }

    public void logAddBroker(BrokerMgr.ModifyBrokerInfo info) {
        this.logEdit((short)85, info);
    }

    public void logDropBroker(BrokerMgr.ModifyBrokerInfo info) {
        this.logEdit((short)86, info);
    }

    public void logDropAllBroker(String brokerName) {
        this.logEdit((short)87, (Writable)new Text(brokerName));
    }

    public void logSetLoadErrorHub(LoadErrorHub.Param param) {
        this.logEdit((short)58, param);
    }

    public void logExportCreate(ExportJob job) {
        this.logEdit((short)36, job);
    }

    public void logExportUpdateState(long jobId, ExportJob.JobState newState) {
        ExportJob.StateTransfer transfer = new ExportJob.StateTransfer(jobId, newState);
        this.logEdit((short)37, transfer);
    }

    public void logUpdateClusterAndBackendState(BackendIdsUpdateInfo info) {
        this.logEdit((short)88, info);
    }

    public void logInsertTransactionState(TransactionState transactionState) {
        this.logEdit((short)100, transactionState);
    }

    public void logBackupJob(BackupJob job) {
        this.logEdit((short)116, job);
    }

    public void logCreateRepository(Repository repo) {
        this.logEdit((short)89, repo);
    }

    public void logDropRepository(String repoName) {
        this.logEdit((short)90, (Writable)new Text(repoName));
    }

    public void logRestoreJob(RestoreJob job) {
        this.logEdit((short)117, job);
    }

    public void logUpdateUserProperty(UserPropertyInfo propertyInfo) {
        this.logEdit((short)69, propertyInfo);
    }

    public void logTruncateTable(TruncateTableInfo info) {
        this.logEdit((short)118, info);
    }

    public void logColocateAddTable(ColocatePersistInfo info) {
        this.logEdit((short)94, info);
    }

    public void logColocateRemoveTable(ColocatePersistInfo info) {
        this.logEdit((short)95, info);
    }

    public void logColocateBackendsPerBucketSeq(ColocatePersistInfo info) {
        this.logEdit((short)96, info);
    }

    public void logColocateMarkUnstable(ColocatePersistInfo info) {
        this.logEdit((short)97, info);
    }

    public void logColocateMarkStable(ColocatePersistInfo info) {
        this.logEdit((short)98, info);
    }

    public void logModifyTableColocate(TablePropertyInfo info) {
        this.logEdit((short)99, info);
    }

    public void logHeartbeat(HbPackage hbPackage) {
        this.logEdit((short)59, hbPackage);
    }

    public void logAddFunction(Function function) {
        this.logEdit((short)130, function);
    }

    public void logDropFunction(FunctionSearchDesc function) {
        this.logEdit((short)131, function);
    }

    public void logAddEncryptKey(EncryptKey encryptKey) {
        this.logEdit((short)253, encryptKey);
    }

    public void logDropEncryptKey(EncryptKeySearchDesc desc) {
        this.logEdit((short)254, desc);
    }

    @Deprecated
    public void logBackendTabletsInfo(BackendTabletsInfo backendTabletsInfo) {
        this.logEdit((short)46, backendTabletsInfo);
    }

    public void logBackendReplicasInfo(BackendReplicasInfo backendReplicasInfo) {
        this.logEdit((short)48, backendReplicasInfo);
    }

    public void logCreateRoutineLoadJob(RoutineLoadJob routineLoadJob) {
        this.logEdit((short)200, routineLoadJob);
    }

    public void logOpRoutineLoadJob(RoutineLoadOperation routineLoadOperation) {
        this.logEdit((short)201, routineLoadOperation);
    }

    public void logRemoveRoutineLoadJob(RoutineLoadOperation operation) {
        this.logEdit((short)202, operation);
    }

    public void logCreateLoadJob(LoadJob loadJob) {
        this.logEdit((short)230, loadJob);
    }

    public void logEndLoadJob(LoadJobFinalOperation loadJobFinalOperation) {
        this.logEdit((short)231, loadJobFinalOperation);
    }

    public void logUpdateLoadJob(LoadJob.LoadJobStateUpdateInfo info) {
        this.logEdit((short)232, info);
    }

    public void logCreateSyncJob(SyncJob syncJob) {
        this.logEdit((short)234, syncJob);
    }

    public void logUpdateSyncJobState(SyncJob.SyncJobUpdateStateInfo info) {
        this.logEdit((short)235, info);
    }

    public void logFetchStreamLoadRecord(StreamLoadRecordMgr.FetchStreamLoadRecord fetchStreamLoadRecord) {
        this.logEdit((short)233, fetchStreamLoadRecord);
    }

    public void logCreateResource(Resource resource) {
        this.logEdit((short)276, resource);
    }

    public void logDropResource(DropResourceOperationLog operationLog) {
        this.logEdit((short)277, operationLog);
    }

    public void logCreateSmallFile(SmallFileMgr.SmallFile info) {
        this.logEdit((short)251, info);
    }

    public void logDropSmallFile(SmallFileMgr.SmallFile info) {
        this.logEdit((short)252, info);
    }

    public void logAlterJob(AlterJobV2 alterJob) {
        this.logEdit((short)121, alterJob);
    }

    public void logBatchAlterJob(BatchAlterJobPersistInfo batchAlterJobV2) {
        this.logEdit((short)123, batchAlterJobV2);
    }

    public void logModifyDistributionType(TableInfo tableInfo) {
        this.logEdit((short)122, tableInfo);
    }

    public void logDynamicPartition(ModifyTablePropertyOperationLog info) {
        this.logEdit((short)261, info);
    }

    public void logModifyReplicationNum(ModifyTablePropertyOperationLog info) {
        this.logEdit((short)266, info);
    }

    public void logModifyDefaultDistributionBucketNum(ModifyTableDefaultDistributionBucketNumOperationLog info) {
        this.logEdit((short)268, info);
    }

    public void logModifyInMemory(ModifyTablePropertyOperationLog info) {
        this.logEdit((short)267, info);
    }

    public void logReplaceTempPartition(ReplacePartitionOperationLog info) {
        this.logEdit((short)210, info);
    }

    public void logInstallPlugin(PluginInfo plugin) {
        this.logEdit((short)270, plugin);
    }

    public void logUninstallPlugin(PluginInfo plugin) {
        this.logEdit((short)271, plugin);
    }

    public void logSetReplicaStatus(SetReplicaStatusOperationLog log) {
        this.logEdit((short)47, log);
    }

    public void logRemoveExpiredAlterJobV2(RemoveAlterJobV2OperationLog log) {
        this.logEdit((short)125, log);
    }

    public void logAlterRoutineLoadJob(AlterRoutineLoadJobOperationLog log) {
        this.logEdit((short)111, log);
    }

    public void logGlobalVariableV2(GlobalVarPersistInfo info) {
        this.logEdit((short)84, info);
    }

    public void logReplaceTable(ReplaceTableOperationLog log) {
        this.logEdit((short)212, log);
    }

    public void logBatchRemoveTransactions(BatchRemoveTransactionsOperation op) {
        this.logEdit((short)105, op);
    }

    public void logModifyComment(ModifyCommentOperationLog op) {
        this.logEdit((short)126, op);
    }

    public void logCreateSqlBlockRule(SqlBlockRule rule) {
        this.logEdit((short)300, rule);
    }

    public void logAlterSqlBlockRule(SqlBlockRule rule) {
        this.logEdit((short)301, rule);
    }

    public void logDropSqlBlockRule(List<String> ruleNames) {
        this.logEdit((short)302, new DropSqlBlockRuleOperationLog(ruleNames));
    }

    public void logModifyTableEngine(ModifyTableEngineOperationLog log) {
        this.logEdit((short)127, log);
    }
}

