/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class DropPartitionInfo
implements Writable {
    @SerializedName(value="dbId")
    private Long dbId;
    @SerializedName(value="tableId")
    private Long tableId;
    @SerializedName(value="partitionName")
    private String partitionName;
    @SerializedName(value="isTempPartition")
    private boolean isTempPartition = false;
    @SerializedName(value="forceDrop")
    private boolean forceDrop = false;

    private DropPartitionInfo() {
    }

    public DropPartitionInfo(Long dbId, Long tableId, String partitionName, boolean isTempPartition, boolean forceDrop) {
        this.dbId = dbId;
        this.tableId = tableId;
        this.partitionName = partitionName;
        this.isTempPartition = isTempPartition;
        this.forceDrop = forceDrop;
    }

    public Long getDbId() {
        return this.dbId;
    }

    public Long getTableId() {
        return this.tableId;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public boolean isTempPartition() {
        return this.isTempPartition;
    }

    public boolean isForceDrop() {
        return this.forceDrop;
    }

    @Deprecated
    private void readFields(DataInput in) throws IOException {
        this.dbId = in.readLong();
        this.tableId = in.readLong();
        this.partitionName = Text.readString((DataInput)in);
    }

    public static DropPartitionInfo read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (DropPartitionInfo)GsonUtils.GSON.fromJson(json, DropPartitionInfo.class);
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DropPartitionInfo)) {
            return false;
        }
        DropPartitionInfo info = (DropPartitionInfo)obj;
        return this.dbId.equals(info.dbId) && this.tableId.equals(info.tableId) && this.partitionName.equals(info.partitionName) && this.isTempPartition == info.isTempPartition && this.forceDrop == info.forceDrop;
    }
}

