/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Writable;

public class DropInfo
implements Writable {
    private long dbId;
    private long tableId;
    private long indexId;
    private boolean forceDrop = false;

    public DropInfo() {
    }

    public DropInfo(long dbId, long tableId, long indexId, boolean forceDrop) {
        this.dbId = dbId;
        this.tableId = tableId;
        this.indexId = indexId;
        this.forceDrop = forceDrop;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public boolean isForceDrop() {
        return this.forceDrop;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.dbId);
        out.writeLong(this.tableId);
        out.writeBoolean(this.forceDrop);
        if (this.indexId == -1L) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeLong(this.indexId);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.dbId = in.readLong();
        this.tableId = in.readLong();
        this.forceDrop = in.readBoolean();
        boolean hasIndexId = in.readBoolean();
        this.indexId = hasIndexId ? in.readLong() : -1L;
    }

    public static DropInfo read(DataInput in) throws IOException {
        DropInfo dropInfo = new DropInfo();
        dropInfo.readFields(in);
        return dropInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DropInfo)) {
            return false;
        }
        DropInfo info = (DropInfo)obj;
        return this.dbId == info.dbId && this.tableId == info.tableId && this.indexId == info.indexId && this.forceDrop == info.forceDrop;
    }
}

