/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.analysis.AlterDatabaseQuotaStmt;
import org.apache.doris.catalog.Database;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class DatabaseInfo
implements Writable {
    private String dbName;
    private String newDbName;
    private long quota;
    private String clusterName;
    private Database.DbState dbState;
    private AlterDatabaseQuotaStmt.QuotaType quotaType;

    public DatabaseInfo() {
        this.dbName = "";
        this.newDbName = "";
        this.quota = 0L;
        this.clusterName = "";
        this.dbState = Database.DbState.NORMAL;
        this.quotaType = AlterDatabaseQuotaStmt.QuotaType.DATA;
    }

    public DatabaseInfo(String dbName, String newDbName, long quota, AlterDatabaseQuotaStmt.QuotaType quotaType) {
        this.dbName = dbName;
        this.newDbName = newDbName;
        this.quota = quota;
        this.clusterName = "";
        this.dbState = Database.DbState.NORMAL;
        this.quotaType = quotaType;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getNewDbName() {
        return this.newDbName;
    }

    public long getQuota() {
        return this.quota;
    }

    public static DatabaseInfo read(DataInput in) throws IOException {
        DatabaseInfo dbInfo = new DatabaseInfo();
        dbInfo.readFields(in);
        return dbInfo;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.dbName);
        Text.writeString((DataOutput)out, (String)this.newDbName);
        out.writeLong(this.quota);
        Text.writeString((DataOutput)out, (String)this.clusterName);
        Text.writeString((DataOutput)out, (String)this.dbState.name());
        Text.writeString((DataOutput)out, (String)this.quotaType.name());
    }

    public void readFields(DataInput in) throws IOException {
        this.dbName = Text.readString((DataInput)in);
        this.newDbName = Text.readString((DataInput)in);
        this.quota = in.readLong();
        this.clusterName = Text.readString((DataInput)in);
        this.dbState = Database.DbState.valueOf(Text.readString((DataInput)in));
        this.quotaType = AlterDatabaseQuotaStmt.QuotaType.valueOf(Text.readString((DataInput)in));
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public Database.DbState getDbState() {
        return this.dbState;
    }

    public AlterDatabaseQuotaStmt.QuotaType getQuotaType() {
        return this.quotaType;
    }
}

