/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.catalog.Table;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableInfo
implements Writable {
    public static final Logger LOG = LoggerFactory.getLogger(CreateTableInfo.class);
    private String dbName;
    private Table table;

    public CreateTableInfo() {
    }

    public CreateTableInfo(String dbName, Table table) {
        this.dbName = dbName;
        this.table = table;
    }

    public String getDbName() {
        return this.dbName;
    }

    public Table getTable() {
        return this.table;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.dbName);
        this.table.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.dbName = Text.readString((DataInput)in);
        this.table = Table.read(in);
    }

    public static CreateTableInfo read(DataInput in) throws IOException {
        CreateTableInfo createTableInfo = new CreateTableInfo();
        createTableInfo.readFields(in);
        return createTableInfo;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CreateTableInfo)) {
            return false;
        }
        CreateTableInfo info = (CreateTableInfo)obj;
        return this.dbName.equals(info.dbName) && this.table.equals(info.table);
    }
}

