/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.io.Writable;

public class ConsistencyCheckInfo
implements Writable {
    private long dbId;
    private long tableId;
    private long partitionId;
    private long indexId;
    private long tabletId;
    private long lastCheckTime;
    private long checkedVersion;
    @Deprecated
    private long checkedVersionHash;
    private boolean isConsistent;

    public ConsistencyCheckInfo() {
    }

    public ConsistencyCheckInfo(long dbId, long tableId, long partitionId, long indexId, long tabletId, long lastCheckTime, long checkedVersion, boolean isConsistent) {
        this.dbId = dbId;
        this.tableId = tableId;
        this.partitionId = partitionId;
        this.indexId = indexId;
        this.tabletId = tabletId;
        this.lastCheckTime = lastCheckTime;
        this.checkedVersion = checkedVersion;
        this.isConsistent = isConsistent;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public long getPartitionId() {
        return this.partitionId;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public long getTabletId() {
        return this.tabletId;
    }

    public long getLastCheckTime() {
        return this.lastCheckTime;
    }

    public long getCheckedVersion() {
        return this.checkedVersion;
    }

    public boolean isConsistent() {
        return this.isConsistent;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.dbId);
        out.writeLong(this.tableId);
        out.writeLong(this.partitionId);
        out.writeLong(this.indexId);
        out.writeLong(this.tabletId);
        out.writeLong(this.lastCheckTime);
        out.writeLong(this.checkedVersion);
        out.writeLong(this.checkedVersionHash);
        out.writeBoolean(this.isConsistent);
    }

    public void readFields(DataInput in) throws IOException {
        this.dbId = in.readLong();
        this.tableId = in.readLong();
        this.partitionId = in.readLong();
        this.indexId = in.readLong();
        this.tabletId = in.readLong();
        this.lastCheckTime = in.readLong();
        this.checkedVersion = in.readLong();
        this.checkedVersionHash = in.readLong();
        this.isConsistent = in.readBoolean();
    }

    public static ConsistencyCheckInfo read(DataInput in) throws IOException {
        ConsistencyCheckInfo info = new ConsistencyCheckInfo();
        info.readFields(in);
        return info;
    }
}

