/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.clearspring.analytics.util.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.ColocateTableIndex;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;
import org.apache.doris.resource.Tag;

public class ColocatePersistInfo
implements Writable {
    @SerializedName(value="groupId")
    private ColocateTableIndex.GroupId groupId;
    @SerializedName(value="tableId")
    private long tableId;
    @SerializedName(value="backendsPerBucketSeq")
    private Map<Tag, List<List<Long>>> backendsPerBucketSeq = Maps.newHashMap();

    public ColocatePersistInfo() {
    }

    public static ColocatePersistInfo createForAddTable(ColocateTableIndex.GroupId groupId, long tableId, Map<Tag, List<List<Long>>> backendsPerBucketSeq) {
        return new ColocatePersistInfo(groupId, tableId, backendsPerBucketSeq);
    }

    public static ColocatePersistInfo createForBackendsPerBucketSeq(ColocateTableIndex.GroupId groupId, Map<Tag, List<List<Long>>> backendsPerBucketSeq) {
        return new ColocatePersistInfo(groupId, -1L, backendsPerBucketSeq);
    }

    public static ColocatePersistInfo createForMarkUnstable(ColocateTableIndex.GroupId groupId) {
        return new ColocatePersistInfo(groupId, -1L, Maps.newHashMap());
    }

    public static ColocatePersistInfo createForMarkStable(ColocateTableIndex.GroupId groupId) {
        return new ColocatePersistInfo(groupId, -1L, Maps.newHashMap());
    }

    public static ColocatePersistInfo createForRemoveTable(long tableId) {
        return new ColocatePersistInfo(new ColocateTableIndex.GroupId(-1L, -1L), tableId, Maps.newHashMap());
    }

    private ColocatePersistInfo(ColocateTableIndex.GroupId groupId, long tableId, Map<Tag, List<List<Long>>> backendsPerBucketSeq) {
        this.groupId = groupId;
        this.tableId = tableId;
        this.backendsPerBucketSeq = backendsPerBucketSeq;
    }

    public long getTableId() {
        return this.tableId;
    }

    public ColocateTableIndex.GroupId getGroupId() {
        return this.groupId;
    }

    public Map<Tag, List<List<Long>>> getBackendsPerBucketSeq() {
        return this.backendsPerBucketSeq;
    }

    public static ColocatePersistInfo read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (ColocatePersistInfo)GsonUtils.GSON.fromJson(json, ColocatePersistInfo.class);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    @Deprecated
    private void readFields(DataInput in) throws IOException {
        this.tableId = in.readLong();
        this.groupId = ColocateTableIndex.GroupId.read(in);
        int size = in.readInt();
        this.backendsPerBucketSeq = Maps.newHashMap();
        List backendsPerBucketSeqList = Lists.newArrayList();
        this.backendsPerBucketSeq.put(Tag.DEFAULT_BACKEND_TAG, backendsPerBucketSeqList);
        for (int i = 0; i < size; ++i) {
            int beListSize = in.readInt();
            ArrayList<Long> beLists = new ArrayList<Long>();
            for (int j = 0; j < beListSize; ++j) {
                beLists.add(in.readLong());
            }
            backendsPerBucketSeqList.add(beLists);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ColocatePersistInfo)) {
            return false;
        }
        ColocatePersistInfo info = (ColocatePersistInfo)obj;
        return this.tableId == info.tableId && this.groupId.equals(info.groupId) && this.backendsPerBucketSeq.equals(info.backendsPerBucketSeq);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("table id: ").append(this.tableId);
        sb.append(" group id: ").append(this.groupId);
        sb.append(" backendsPerBucketSeq: ").append(this.backendsPerBucketSeq);
        return sb.toString();
    }
}

