/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class ClusterInfo
implements Writable {
    private String clusterName;
    private long clusterId;
    private int instanceNum;
    private String newClusterName;
    private long newClusterId;
    private int newInstanceNum;
    private List<Long> expandBackendIds = Lists.newArrayList();

    public ClusterInfo() {
        this.clusterName = "";
        this.clusterId = 0L;
        this.instanceNum = 0;
        this.newClusterName = "";
        this.newClusterId = 0L;
        this.newInstanceNum = 0;
    }

    public ClusterInfo(String clusterName, long clusterId) {
        this.clusterName = clusterName;
        this.clusterId = clusterId;
        this.instanceNum = 0;
        this.newClusterName = "";
        this.newClusterId = 0L;
        this.newInstanceNum = 0;
    }

    public ClusterInfo(String clusterName, long clusterId, List<Long> expandBackendIds) {
        this.clusterName = clusterName;
        this.clusterId = clusterId;
        this.expandBackendIds = expandBackendIds;
        this.instanceNum = 0;
        this.newClusterName = "";
        this.newClusterId = 0L;
        this.newInstanceNum = 0;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.clusterName);
        out.writeLong(this.clusterId);
        out.writeInt(this.instanceNum);
        out.writeInt(this.expandBackendIds.size());
        for (long id : this.expandBackendIds) {
            out.writeLong(id);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.clusterName = Text.readString((DataInput)in);
        this.clusterId = in.readLong();
        this.instanceNum = in.readInt();
        int count = in.readInt();
        while (count-- > 0) {
            this.expandBackendIds.add(in.readLong());
        }
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public long getClusterId() {
        return this.clusterId;
    }

    public int getInstanceNum() {
        return this.instanceNum;
    }

    public String getNewClusterName() {
        return this.newClusterName;
    }

    public int getNewInstanceNum() {
        return this.newInstanceNum;
    }

    public List<Long> getBackendIdList() {
        return this.expandBackendIds;
    }
}

