/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class BatchDropInfo
implements Writable {
    @SerializedName(value="dbId")
    private long dbId;
    @SerializedName(value="tableId")
    private long tableId;
    @SerializedName(value="indexIdSet")
    private Set<Long> indexIdSet;

    public BatchDropInfo(long dbId, long tableId, Set<Long> indexIdSet) {
        this.dbId = dbId;
        this.tableId = tableId;
        this.indexIdSet = indexIdSet;
    }

    public int hashCode() {
        return Objects.hash(this.dbId, this.tableId, this.indexIdSet);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BatchDropInfo)) {
            return false;
        }
        BatchDropInfo otherBatchDropInfo = (BatchDropInfo)other;
        return this.dbId == otherBatchDropInfo.dbId && this.tableId == otherBatchDropInfo.tableId && this.indexIdSet.equals(otherBatchDropInfo.indexIdSet);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)GsonUtils.GSON.toJson((Object)this));
    }

    public static BatchDropInfo read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (BatchDropInfo)GsonUtils.GSON.fromJson(json, BatchDropInfo.class);
    }

    public Set<Long> getIndexIdSet() {
        return this.indexIdSet;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }
}

