/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.common.Pair;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.ReplicaPersistInfo;

@Deprecated
public class BackendTabletsInfo
implements Writable {
    private long backendId;
    @Deprecated
    private List<Pair<Long, Integer>> tabletSchemaHash = Lists.newArrayList();
    private boolean bad;
    private List<ReplicaPersistInfo> replicaPersistInfos = Lists.newArrayList();

    private BackendTabletsInfo() {
    }

    public BackendTabletsInfo(long backendId) {
        this.backendId = backendId;
    }

    public void addReplicaInfo(ReplicaPersistInfo info) {
        this.replicaPersistInfos.add(info);
    }

    public List<ReplicaPersistInfo> getReplicaPersistInfos() {
        return this.replicaPersistInfos;
    }

    public long getBackendId() {
        return this.backendId;
    }

    public List<Pair<Long, Integer>> getTabletSchemaHash() {
        return this.tabletSchemaHash;
    }

    public void setBad(boolean bad) {
        this.bad = bad;
    }

    public boolean isBad() {
        return this.bad;
    }

    public boolean isEmpty() {
        return this.tabletSchemaHash.isEmpty() && this.replicaPersistInfos.isEmpty();
    }

    public static BackendTabletsInfo read(DataInput in) throws IOException {
        BackendTabletsInfo backendTabletsInfo = new BackendTabletsInfo();
        backendTabletsInfo.readFields(in);
        return backendTabletsInfo;
    }

    public void write(DataOutput out) throws IOException {
        out.writeLong(this.backendId);
        out.writeInt(this.tabletSchemaHash.size());
        for (Pair<Long, Integer> pair : this.tabletSchemaHash) {
            out.writeLong((Long)pair.first);
            out.writeInt((Integer)pair.second);
        }
        out.writeBoolean(this.bad);
        out.writeBoolean(true);
        out.writeInt(this.replicaPersistInfos.size());
        for (ReplicaPersistInfo info : this.replicaPersistInfos) {
            info.write(out);
        }
        out.writeBoolean(false);
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        this.backendId = in.readLong();
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            long tabletId = in.readLong();
            int schemaHash = in.readInt();
            this.tabletSchemaHash.add(Pair.create(tabletId, schemaHash));
        }
        this.bad = in.readBoolean();
        if (in.readBoolean()) {
            size = in.readInt();
            for (i = 0; i < size; ++i) {
                ReplicaPersistInfo replicaPersistInfo = ReplicaPersistInfo.read(in);
                this.replicaPersistInfos.add(replicaPersistInfo);
            }
        } else {
            this.replicaPersistInfos = Lists.newArrayList();
        }
        if (in.readBoolean()) {
            // empty if block
        }
    }
}

