/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class BackendReplicasInfo
implements Writable {
    @SerializedName(value="backendId")
    private long backendId;
    @SerializedName(value="replicaReportInfos")
    private List<ReplicaReportInfo> replicaReportInfos = Lists.newArrayList();

    public BackendReplicasInfo(long backendId) {
        this.backendId = backendId;
    }

    public void addBadReplica(long tabletId) {
        this.replicaReportInfos.add(new ReplicaReportInfo(tabletId, -1L, ReportInfoType.BAD));
    }

    public void addMissingVersionReplica(long tabletId, long lastFailedVersion) {
        this.replicaReportInfos.add(new ReplicaReportInfo(tabletId, lastFailedVersion, ReportInfoType.MISSING_VERSION));
    }

    public long getBackendId() {
        return this.backendId;
    }

    public List<ReplicaReportInfo> getReplicaReportInfos() {
        return this.replicaReportInfos;
    }

    public boolean isEmpty() {
        return this.replicaReportInfos.isEmpty();
    }

    public static BackendReplicasInfo read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (BackendReplicasInfo)GsonUtils.GSON.fromJson(json, BackendReplicasInfo.class);
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static class ReplicaReportInfo
    implements Writable {
        @SerializedName(value="tabletId")
        public long tabletId;
        @SerializedName(value="type")
        public ReportInfoType type;
        @SerializedName(value="lastFailedVersion")
        public long lastFailedVersion;

        public ReplicaReportInfo(long tabletId, long lastFailedVersion, ReportInfoType type) {
            this.tabletId = tabletId;
            this.lastFailedVersion = lastFailedVersion;
            this.type = type;
        }

        public void write(DataOutput out) throws IOException {
            String json = GsonUtils.GSON.toJson((Object)this);
            Text.writeString((DataOutput)out, (String)json);
        }

        public static ReplicaReportInfo read(DataInput in) throws IOException {
            String json = Text.readString((DataInput)in);
            ReplicaReportInfo info = (ReplicaReportInfo)GsonUtils.GSON.fromJson(json, ReplicaReportInfo.class);
            if (info.type == ReportInfoType.MISSING_VERSION && info.lastFailedVersion <= 0L) {
                info.lastFailedVersion = 1L;
            }
            return info;
        }
    }

    public static enum ReportInfoType {
        BAD,
        MISSING_VERSION;

    }
}

