/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.common.io.Writable;

public class BackendIdsUpdateInfo
implements Writable {
    private List<Long> backendIds;

    public BackendIdsUpdateInfo() {
        this.backendIds = Lists.newArrayList();
    }

    public BackendIdsUpdateInfo(List<Long> backends) {
        this.backendIds = backends;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.backendIds.size());
        for (Long id : this.backendIds) {
            out.writeLong(id);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int backendCount = in.readInt();
        while (backendCount-- > 0) {
            this.backendIds.add(in.readLong());
        }
    }

    public List<Long> getBackendList() {
        return this.backendIds;
    }

    public void setBackendList(List<Long> backendList) {
        this.backendIds = backendList;
    }
}

