/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.persist;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.doris.catalog.Column;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.persist.gson.GsonUtils;

public class AlterViewInfo
implements Writable {
    @SerializedName(value="dbId")
    private long dbId;
    @SerializedName(value="tableId")
    private long tableId;
    @SerializedName(value="inlineViewDef")
    private String inlineViewDef;
    @SerializedName(value="sqlMode")
    private long sqlMode;
    @SerializedName(value="newFullSchema")
    private List<Column> newFullSchema;

    public AlterViewInfo() {
        this.newFullSchema = Lists.newArrayList();
    }

    public AlterViewInfo(long dbId, long tableId, String inlineViewDef, List<Column> newFullSchema, long sqlMode) {
        this.dbId = dbId;
        this.tableId = tableId;
        this.inlineViewDef = inlineViewDef;
        this.newFullSchema = newFullSchema;
        this.sqlMode = sqlMode;
    }

    public long getDbId() {
        return this.dbId;
    }

    public long getTableId() {
        return this.tableId;
    }

    public String getInlineViewDef() {
        return this.inlineViewDef;
    }

    public List<Column> getNewFullSchema() {
        return this.newFullSchema;
    }

    public long getSqlMode() {
        return this.sqlMode;
    }

    public int hashCode() {
        return Objects.hash(this.dbId, this.tableId, this.inlineViewDef, this.sqlMode, this.newFullSchema);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof AlterViewInfo)) {
            return false;
        }
        AlterViewInfo otherInfo = (AlterViewInfo)other;
        return this.dbId == otherInfo.getDbId() && this.tableId == otherInfo.getTableId() && this.inlineViewDef.equalsIgnoreCase(otherInfo.getInlineViewDef()) && this.sqlMode == otherInfo.getSqlMode() && this.newFullSchema.equals(otherInfo.getNewFullSchema());
    }

    public void write(DataOutput out) throws IOException {
        String json = GsonUtils.GSON.toJson((Object)this);
        Text.writeString((DataOutput)out, (String)json);
    }

    public static AlterViewInfo read(DataInput in) throws IOException {
        String json = Text.readString((DataInput)in);
        return (AlterViewInfo)GsonUtils.GSON.fromJson(json, AlterViewInfo.class);
    }
}

