/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.doris.analysis.TablePattern;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WhiteList
implements Writable {
    private static final Logger LOG = LogManager.getLogger(WhiteList.class);
    private Map<String, byte[]> passwordMap = Maps.newConcurrentMap();
    private Map<String, Set<String>> resolvedIPsMap = Maps.newConcurrentMap();
    @Deprecated
    private Map<String, Map<TablePattern, PrivBitSet>> oldDomainPrivsMap = Maps.newHashMap();
    @Deprecated
    private byte[] oldPassword;

    public void removeDomain(String domain) {
        this.passwordMap.remove(domain);
        this.resolvedIPsMap.remove(domain);
    }

    public void setPassword(String domain, byte[] password) {
        this.passwordMap.put(domain, password);
    }

    public void addUserPrivEntriesByResolvedIPs(String user, Map<String, Set<String>> resolvedIPsMap) {
        HashMap newResolvedIPsMap = Maps.newHashMap();
        for (Map.Entry<String, Set<String>> entry : resolvedIPsMap.entrySet()) {
            if (!this.containsDomain(entry.getKey())) continue;
            newResolvedIPsMap.put(entry.getKey(), entry.getValue());
            UserIdentity domainUserIdent = UserIdentity.createAnalyzedUserIdentWithDomain(user, entry.getKey());
            for (String newIP : entry.getValue()) {
                UserIdentity userIdent = UserIdentity.createAnalyzedUserIdentWithIp(user, newIP);
                byte[] password = this.passwordMap.get(entry.getKey());
                Preconditions.checkNotNull((Object)password, (Object)entry.getKey());
                try {
                    Catalog.getCurrentCatalog().getAuth().setPasswordInternal(userIdent, password, domainUserIdent, false, true, true);
                }
                catch (DdlException e) {
                    LOG.debug("failed to set password for user ident: {}, {}", (Object)userIdent, (Object)e.getMessage());
                }
            }
        }
        this.resolvedIPsMap = newResolvedIPsMap;
    }

    public Map<String, Set<String>> getResolvedIPs() {
        return this.resolvedIPsMap;
    }

    public boolean containsDomain(String domain) {
        return this.passwordMap.containsKey(domain);
    }

    public Set<String> getAllDomains() {
        return Sets.newHashSet(this.passwordMap.keySet());
    }

    public boolean hasPassword(String domain) {
        return this.passwordMap.containsKey(domain) && this.passwordMap.get(domain).length > 0;
    }

    public String toString() {
        return Joiner.on((String)", ").join(this.passwordMap.keySet());
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.passwordMap.size());
        for (Map.Entry<String, byte[]> entry : this.passwordMap.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            byte[] password = entry.getValue();
            out.writeInt(password.length);
            out.write(password);
        }
    }

    public void readFields(DataInput in) throws IOException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String domain = Text.readString((DataInput)in);
            int passLen = in.readInt();
            byte[] password = new byte[passLen];
            in.readFully(password);
            this.passwordMap.put(domain, password);
        }
    }
}

