/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.collect.ImmutableSortedMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.doris.catalog.ResourceGroup;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.thrift.TUserResource;

public class UserResource
implements Writable {
    public static final String LOW = "low";
    public static final String NORMAL = "normal";
    public static final String HIGH = "high";
    private static int defaultLowShare = 100;
    private static int defaultNormalShare = 400;
    private static int defaultHighShare = 800;
    private ResourceGroup resource;
    private ImmutableSortedMap<String, AtomicInteger> shareByGroup;

    private UserResource() {
    }

    public UserResource(int cpuShare) {
        this.resource = ResourceGroup.builder().cpuShare(cpuShare).build();
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
        builder.put((Object)LOW, (Object)new AtomicInteger(defaultLowShare));
        builder.put((Object)NORMAL, (Object)new AtomicInteger(defaultNormalShare));
        builder.put((Object)HIGH, (Object)new AtomicInteger(defaultHighShare));
        this.shareByGroup = builder.build();
    }

    public UserResource getCopiedUserResource() {
        UserResource userResource = new UserResource();
        userResource.resource = this.resource.getCopiedResourceGroup();
        userResource.shareByGroup = ImmutableSortedMap.copyOf(this.shareByGroup);
        return userResource;
    }

    public static boolean isValidGroup(String group) {
        return group.equalsIgnoreCase(LOW) || group.equalsIgnoreCase(NORMAL) || group.equalsIgnoreCase(HIGH);
    }

    public void updateResource(String desc, int quota) throws DdlException {
        this.resource.updateByDesc(desc, quota);
    }

    public void updateGroupShare(String groupName, int newShare) throws DdlException {
        AtomicInteger share = (AtomicInteger)this.shareByGroup.get((Object)groupName);
        if (share == null) {
            throw new DdlException("Unknown resource(" + groupName + ")");
        }
        share.set(newShare);
    }

    public ResourceGroup getResource() {
        return this.resource;
    }

    public Map<String, AtomicInteger> getShareByGroup() {
        return this.shareByGroup;
    }

    public TUserResource toThrift() {
        TUserResource tResource = new TUserResource();
        tResource.setResource(this.resource.toThrift());
        for (Map.Entry entry : this.shareByGroup.entrySet()) {
            tResource.putToShareByGroup((String)entry.getKey(), ((AtomicInteger)entry.getValue()).get());
        }
        return tResource;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TotalQuota(").append(this.resource.toString()).append(")\n");
        int idx = 0;
        for (Map.Entry entry : this.shareByGroup.entrySet()) {
            if (idx++ != 0) {
                sb.append(", ");
            }
            sb.append((String)entry.getKey()).append("(").append(entry.getValue()).append(")");
        }
        return sb.toString();
    }

    public void write(DataOutput out) throws IOException {
        this.resource.write(out);
        out.writeInt(this.shareByGroup.size());
        for (Map.Entry entry : this.shareByGroup.entrySet()) {
            Text.writeString((DataOutput)out, (String)((String)entry.getKey()));
            out.writeInt(((AtomicInteger)entry.getValue()).get());
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.resource = ResourceGroup.readIn(in);
        ImmutableSortedMap.Builder builder = ImmutableSortedMap.orderedBy((Comparator)String.CASE_INSENSITIVE_ORDER);
        int numGroup = in.readInt();
        for (int i = 0; i < numGroup; ++i) {
            String name = Text.readString((DataInput)in);
            AtomicInteger value = new AtomicInteger(in.readInt());
            builder.put((Object)name, (Object)value);
        }
        this.shareByGroup = builder.build();
    }

    public static UserResource readIn(DataInput in) throws IOException {
        UserResource userResource = new UserResource();
        userResource.readFields(in);
        return userResource;
    }
}

