/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.common.Pair;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;

public class UserPropertyInfo
implements Writable {
    private String user;
    private List<Pair<String, String>> properties = Lists.newArrayList();

    private UserPropertyInfo() {
    }

    public UserPropertyInfo(String user, List<Pair<String, String>> properties) {
        this.user = user;
        this.properties = properties;
    }

    public String getUser() {
        return this.user;
    }

    public List<Pair<String, String>> getProperties() {
        return this.properties;
    }

    public static UserPropertyInfo read(DataInput in) throws IOException {
        UserPropertyInfo info = new UserPropertyInfo();
        info.readFields(in);
        return info;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.user);
        out.writeInt(this.properties.size());
        for (Pair<String, String> entry : this.properties) {
            Text.writeString((DataOutput)out, (String)((String)entry.first));
            Text.writeString((DataOutput)out, (String)((String)entry.second));
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.user = Text.readString((DataInput)in);
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = Text.readString((DataInput)in);
            String val = Text.readString((DataInput)in);
            this.properties.add(Pair.create(key, val));
        }
    }
}

