/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.doris.catalog.Catalog;
import org.apache.doris.catalog.ResourceGroup;
import org.apache.doris.catalog.ResourceType;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.LoadException;
import org.apache.doris.common.Pair;
import org.apache.doris.common.UserException;
import org.apache.doris.common.io.Text;
import org.apache.doris.common.io.Writable;
import org.apache.doris.load.DppConfig;
import org.apache.doris.mysql.privilege.CommonUserProperties;
import org.apache.doris.mysql.privilege.UserResource;
import org.apache.doris.mysql.privilege.WhiteList;
import org.apache.doris.resource.Tag;

public class UserProperty
implements Writable {
    private static final String PROP_MAX_USER_CONNECTIONS = "max_user_connections";
    private static final String PROP_MAX_QUERY_INSTANCES = "max_query_instances";
    private static final String PROP_RESOURCE_TAGS = "resource_tags";
    private static final String PROP_RESOURCE = "resource";
    private static final String PROP_SQL_BLOCK_RULES = "sql_block_rules";
    private static final String PROP_CPU_RESOURCE_LIMIT = "cpu_resource_limit";
    private static final String PROP_EXEC_MEM_LIMIT = "exec_mem_limit";
    private static final String PROP_LOAD_MEM_LIMIT = "load_mem_limit";
    private static final String PROP_LOAD_CLUSTER = "load_cluster";
    private static final String PROP_QUOTA = "quota";
    private static final String PROP_DEFAULT_LOAD_CLUSTER = "default_load_cluster";
    public static final Set<Pattern> ADVANCED_PROPERTIES = Sets.newHashSet();
    public static final Set<Pattern> COMMON_PROPERTIES = Sets.newHashSet();
    private String qualifiedUser;
    private CommonUserProperties commonProperties = new CommonUserProperties();
    private UserResource resource = new UserResource(1000);
    private String defaultLoadCluster = null;
    private Map<String, DppConfig> clusterToDppConfig = Maps.newHashMap();
    private WhiteList whiteList = new WhiteList();
    public static final Set<Tag> INVALID_RESOURCE_TAGS = Sets.newHashSet();

    public UserProperty() {
    }

    public UserProperty(String qualifiedUser) {
        this.qualifiedUser = qualifiedUser;
    }

    public String getQualifiedUser() {
        return this.qualifiedUser;
    }

    public long getMaxConn() {
        return this.commonProperties.getMaxConn();
    }

    public long getMaxQueryInstances() {
        return this.commonProperties.getMaxQueryInstances();
    }

    public String[] getSqlBlockRules() {
        return this.commonProperties.getSqlBlockRulesSplit();
    }

    public int getCpuResourceLimit() {
        return this.commonProperties.getCpuResourceLimit();
    }

    public WhiteList getWhiteList() {
        return this.whiteList;
    }

    public Set<Tag> getCopiedResourceTags() {
        return Sets.newHashSet(this.commonProperties.getResourceTags());
    }

    public long getExecMemLimit() {
        return this.commonProperties.getExecMemLimit();
    }

    public long getLoadMemLimit() {
        return this.commonProperties.getLoadMemLimit();
    }

    public void setPasswordForDomain(String domain, byte[] password, boolean errOnExist) throws DdlException {
        if (errOnExist && this.whiteList.containsDomain(domain)) {
            throw new DdlException("Domain " + domain + " of user " + this.qualifiedUser + " already exists");
        }
        if (password != null) {
            this.whiteList.setPassword(domain, password);
        }
    }

    public void removeDomain(String domain) {
        this.whiteList.removeDomain(domain);
    }

    public void update(List<Pair<String, String>> properties) throws UserException {
        long newMaxConn = this.commonProperties.getMaxConn();
        long newMaxQueryInstances = this.commonProperties.getMaxQueryInstances();
        String sqlBlockRules = this.commonProperties.getSqlBlockRules();
        int cpuResourceLimit = this.commonProperties.getCpuResourceLimit();
        Set<Object> resourceTags = this.commonProperties.getResourceTags();
        long execMemLimit = this.commonProperties.getExecMemLimit();
        long loadMemLimit = this.commonProperties.getLoadMemLimit();
        UserResource newResource = this.resource.getCopiedUserResource();
        String newDefaultLoadCluster = this.defaultLoadCluster;
        HashMap newDppConfigs = Maps.newHashMap(this.clusterToDppConfig);
        for (Pair<String, String> entry : properties) {
            String key = (String)entry.first;
            String value = (String)entry.second;
            String[] keyArr = key.split("\\.");
            if (keyArr[0].equalsIgnoreCase(PROP_MAX_USER_CONNECTIONS)) {
                if (keyArr.length != 1) {
                    throw new DdlException("max_user_connections format error");
                }
                try {
                    newMaxConn = Long.parseLong(value);
                }
                catch (NumberFormatException e) {
                    throw new DdlException("max_user_connections is not number");
                }
                if (newMaxConn > 0L && newMaxConn <= 10000L) continue;
                throw new DdlException("max_user_connections is not valid, must between 1 and 10000");
            }
            if (keyArr[0].equalsIgnoreCase(PROP_RESOURCE)) {
                if (keyArr.length != 2) {
                    throw new DdlException("resource format error");
                }
                int resource = 0;
                try {
                    resource = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new DdlException(key + " is not number");
                }
                if (resource <= 0) {
                    throw new DdlException(key + " is not valid");
                }
                newResource.updateResource(keyArr[1], resource);
                continue;
            }
            if (keyArr[0].equalsIgnoreCase(PROP_QUOTA)) {
                if (keyArr.length != 2) {
                    throw new DdlException("quota format error");
                }
                int quota = 0;
                try {
                    quota = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new DdlException(key + " is not number");
                }
                if (quota <= 0) {
                    throw new DdlException(key + " is not valid");
                }
                newResource.updateGroupShare(keyArr[1], quota);
                continue;
            }
            if (keyArr[0].equalsIgnoreCase(PROP_LOAD_CLUSTER)) {
                this.updateLoadCluster(keyArr, value, newDppConfigs);
                continue;
            }
            if (keyArr[0].equalsIgnoreCase(PROP_DEFAULT_LOAD_CLUSTER)) {
                if (keyArr.length != 1) {
                    throw new DdlException("default_load_cluster format error");
                }
                if (value != null && !newDppConfigs.containsKey(value)) {
                    throw new DdlException("Load cluster[" + value + "] does not exist");
                }
                newDefaultLoadCluster = value;
                continue;
            }
            if (keyArr[0].equalsIgnoreCase(PROP_MAX_QUERY_INSTANCES)) {
                if (keyArr.length != 1) {
                    throw new DdlException("max_query_instances format error");
                }
                try {
                    newMaxQueryInstances = Long.parseLong(value);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new DdlException("max_query_instances is not number");
                }
            }
            if (keyArr[0].equalsIgnoreCase(PROP_SQL_BLOCK_RULES)) {
                if (keyArr.length != 1) {
                    throw new DdlException("sql_block_rules format error");
                }
                for (String ruleName : value.replaceAll(" ", "").split(",")) {
                    if (ruleName.equals("") || Catalog.getCurrentCatalog().getSqlBlockRuleMgr().existRule(ruleName)) continue;
                    throw new DdlException("the sql block rule " + ruleName + " not exist");
                }
                sqlBlockRules = value;
                continue;
            }
            if (keyArr[0].equalsIgnoreCase(PROP_CPU_RESOURCE_LIMIT)) {
                if (keyArr.length != 1) {
                    throw new DdlException("cpu_resource_limit format error");
                }
                int limit = -1;
                try {
                    limit = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    throw new DdlException(key + " is not number");
                }
                if (limit <= 0 && limit != -1) {
                    throw new DdlException(key + " is not valid. Should not larger than 0 or equal to -1");
                }
                cpuResourceLimit = limit;
                continue;
            }
            if (keyArr[0].equalsIgnoreCase(PROP_RESOURCE_TAGS)) {
                if (keyArr.length != 2) {
                    throw new DdlException("resource_tags format error");
                }
                if (!keyArr[1].equals("location")) {
                    throw new DdlException("Only support location tag now");
                }
                if (Strings.isNullOrEmpty((String)value)) {
                    resourceTags = Sets.newHashSet();
                    continue;
                }
                try {
                    resourceTags = this.parseLocationResoureTags(value);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new DdlException("resource_tags parse failed: " + e.getMessage());
                }
            }
            if (keyArr[0].equalsIgnoreCase(PROP_EXEC_MEM_LIMIT)) {
                execMemLimit = this.getLongProperty(key, value, keyArr, PROP_EXEC_MEM_LIMIT);
                continue;
            }
            if (keyArr[0].equalsIgnoreCase(PROP_LOAD_MEM_LIMIT)) {
                loadMemLimit = this.getLongProperty(key, value, keyArr, PROP_LOAD_MEM_LIMIT);
                continue;
            }
            throw new DdlException("Unknown user property(" + key + ")");
        }
        this.commonProperties.setMaxConn(newMaxConn);
        this.commonProperties.setMaxQueryInstances(newMaxQueryInstances);
        this.commonProperties.setSqlBlockRules(sqlBlockRules);
        this.commonProperties.setCpuResourceLimit(cpuResourceLimit);
        this.commonProperties.setResourceTags(resourceTags);
        this.commonProperties.setExecMemLimit(execMemLimit);
        this.commonProperties.setLoadMemLimit(loadMemLimit);
        this.resource = newResource;
        this.defaultLoadCluster = newDppConfigs.containsKey(newDefaultLoadCluster) ? newDefaultLoadCluster : null;
        this.clusterToDppConfig = newDppConfigs;
    }

    private long getLongProperty(String key, String value, String[] keyArr, String propName) throws DdlException {
        if (keyArr.length != 1) {
            throw new DdlException(propName + " format error");
        }
        long limit = -1L;
        try {
            limit = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            throw new DdlException(key + " is not number");
        }
        if (limit <= 0L && limit != -1L) {
            throw new DdlException(key + " is not valid. Should not larger than 0 or equal to -1");
        }
        return limit;
    }

    private Set<Tag> parseLocationResoureTags(String value) throws AnalysisException {
        String[] parts;
        HashSet tags = Sets.newHashSet();
        for (String part : parts = value.replaceAll(" ", "").split(",")) {
            Tag tag = Tag.create("location", part);
            tags.add(tag);
        }
        return tags;
    }

    private void updateLoadCluster(String[] keyArr, String value, Map<String, DppConfig> newDppConfigs) throws DdlException {
        if (keyArr.length == 1 && Strings.isNullOrEmpty((String)value)) {
            newDppConfigs.clear();
        } else if (keyArr.length == 2 && Strings.isNullOrEmpty((String)value)) {
            String cluster = keyArr[1];
            newDppConfigs.remove(cluster);
        } else if (keyArr.length == 3 && Strings.isNullOrEmpty((String)value)) {
            String cluster = keyArr[1];
            if (!newDppConfigs.containsKey(cluster)) {
                throw new DdlException("Load cluster[" + value + "] does not exist");
            }
            try {
                newDppConfigs.get(cluster).resetConfigByKey(keyArr[2]);
            }
            catch (LoadException e) {
                throw new DdlException(e.getMessage());
            }
        } else if (keyArr.length == 3 && value != null) {
            String cluster = keyArr[1];
            HashMap configMap = Maps.newHashMap();
            configMap.put(keyArr[2], value);
            try {
                DppConfig newDppConfig = DppConfig.create(configMap);
                if (newDppConfigs.containsKey(cluster)) {
                    newDppConfigs.get(cluster).update(newDppConfig, true);
                }
                newDppConfigs.put(cluster, newDppConfig);
            }
            catch (LoadException e) {
                throw new DdlException(e.getMessage());
            }
        } else {
            throw new DdlException("load_cluster format error");
        }
    }

    public UserResource getResource() {
        return this.resource;
    }

    public String getDefaultLoadCluster() {
        return this.defaultLoadCluster;
    }

    public Pair<String, DppConfig> getLoadClusterInfo(String cluster) {
        String tmpCluster = cluster;
        if (tmpCluster == null) {
            tmpCluster = this.defaultLoadCluster;
        }
        DppConfig dppConfig = null;
        if (tmpCluster != null && (dppConfig = this.clusterToDppConfig.get(tmpCluster)) != null) {
            dppConfig = dppConfig.getCopiedDppConfig();
        }
        return Pair.create(tmpCluster, dppConfig);
    }

    public List<List<String>> fetchProperty() {
        ArrayList result = Lists.newArrayList();
        String dot = ".";
        result.add(Lists.newArrayList((Object[])new String[]{PROP_MAX_USER_CONNECTIONS, String.valueOf(this.commonProperties.getMaxConn())}));
        result.add(Lists.newArrayList((Object[])new String[]{PROP_MAX_QUERY_INSTANCES, String.valueOf(this.commonProperties.getMaxQueryInstances())}));
        result.add(Lists.newArrayList((Object[])new String[]{PROP_SQL_BLOCK_RULES, this.commonProperties.getSqlBlockRules()}));
        result.add(Lists.newArrayList((Object[])new String[]{PROP_CPU_RESOURCE_LIMIT, String.valueOf(this.commonProperties.getCpuResourceLimit())}));
        result.add(Lists.newArrayList((Object[])new String[]{PROP_EXEC_MEM_LIMIT, String.valueOf(this.commonProperties.getExecMemLimit())}));
        result.add(Lists.newArrayList((Object[])new String[]{PROP_LOAD_MEM_LIMIT, String.valueOf(this.commonProperties.getLoadMemLimit())}));
        result.add(Lists.newArrayList((Object[])new String[]{PROP_RESOURCE_TAGS, Joiner.on((String)", ").join(this.commonProperties.getResourceTags())}));
        ResourceGroup group = this.resource.getResource();
        for (Map.Entry<ResourceType, Integer> entry : group.getQuotaMap().entrySet()) {
            result.add(Lists.newArrayList((Object[])new String[]{PROP_RESOURCE + dot + entry.getKey().getDesc().toLowerCase(), entry.getValue().toString()}));
        }
        Map<String, AtomicInteger> groups = this.resource.getShareByGroup();
        for (Map.Entry<String, AtomicInteger> entry : groups.entrySet()) {
            result.add(Lists.newArrayList((Object[])new String[]{PROP_QUOTA + dot + entry.getKey(), entry.getValue().toString()}));
        }
        if (this.defaultLoadCluster != null) {
            result.add(Lists.newArrayList((Object[])new String[]{PROP_DEFAULT_LOAD_CLUSTER, this.defaultLoadCluster}));
        } else {
            result.add(Lists.newArrayList((Object[])new String[]{PROP_DEFAULT_LOAD_CLUSTER, ""}));
        }
        for (Map.Entry<String, DppConfig> entry : this.clusterToDppConfig.entrySet()) {
            String cluster = entry.getKey();
            DppConfig dppConfig = entry.getValue();
            String clusterPrefix = PROP_LOAD_CLUSTER + dot + cluster + dot;
            if (dppConfig.getPaloPath() != null) {
                result.add(Lists.newArrayList((Object[])new String[]{clusterPrefix + DppConfig.getPaloPathKey(), dppConfig.getPaloPath()}));
            }
            result.add(Lists.newArrayList((Object[])new String[]{clusterPrefix + DppConfig.getHttpPortKey(), String.valueOf(dppConfig.getHttpPort())}));
            if (dppConfig.getHadoopConfigs() != null) {
                ArrayList configs = Lists.newArrayList();
                for (Map.Entry<String, String> configEntry : dppConfig.getHadoopConfigs().entrySet()) {
                    configs.add(String.format("%s=%s", configEntry.getKey(), configEntry.getValue()));
                }
                result.add(Lists.newArrayList((Object[])new String[]{clusterPrefix + DppConfig.getHadoopConfigsKey(), StringUtils.join((Collection)configs, (String)";")}));
            }
            result.add(Lists.newArrayList((Object[])new String[]{clusterPrefix + DppConfig.getPriorityKey(), String.valueOf(dppConfig.getPriority())}));
        }
        Map<String, Set<String>> map = this.whiteList.getResolvedIPs();
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            arrayList.add(entry.getKey() + ":" + Joiner.on((String)",").join((Iterable)entry.getValue()));
        }
        if (!arrayList.isEmpty()) {
            result.add(Lists.newArrayList((Object[])new String[]{"resolved IPs", Joiner.on((String)";").join((Iterable)arrayList)}));
        }
        Collections.sort(result, new Comparator<List<String>>(){

            @Override
            public int compare(List<String> o1, List<String> o2) {
                return o1.get(0).compareTo(o2.get(0));
            }
        });
        return result;
    }

    public static UserProperty read(DataInput in) throws IOException {
        UserProperty userProperty = new UserProperty();
        userProperty.readFields(in);
        return userProperty;
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.qualifiedUser);
        this.resource.write(out);
        if (this.defaultLoadCluster == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            Text.writeString((DataOutput)out, (String)this.defaultLoadCluster);
        }
        out.writeInt(this.clusterToDppConfig.size());
        for (Map.Entry<String, DppConfig> entry : this.clusterToDppConfig.entrySet()) {
            Text.writeString((DataOutput)out, (String)entry.getKey());
            entry.getValue().write(out);
        }
        this.whiteList.write(out);
        this.commonProperties.write(out);
    }

    public void readFields(DataInput in) throws IOException {
        this.qualifiedUser = Text.readString((DataInput)in);
        if (Catalog.getCurrentCatalogJournalVersion() < 100) {
            long maxConn = in.readLong();
            this.commonProperties.setMaxConn(maxConn);
        }
        this.resource = UserResource.readIn(in);
        if (in.readBoolean()) {
            this.defaultLoadCluster = Text.readString((DataInput)in);
        }
        int clusterNum = in.readInt();
        for (int i = 0; i < clusterNum; ++i) {
            String cluster = Text.readString((DataInput)in);
            DppConfig dppConfig = new DppConfig();
            dppConfig.readFields(in);
            this.clusterToDppConfig.put(cluster, dppConfig);
        }
        this.whiteList.readFields(in);
        if (Catalog.getCurrentCatalogJournalVersion() >= 100) {
            this.commonProperties = CommonUserProperties.read(in);
        }
    }

    static {
        INVALID_RESOURCE_TAGS.add(Tag.INVALID_TAG);
        ADVANCED_PROPERTIES.add(Pattern.compile("^max_user_connections$", 2));
        ADVANCED_PROPERTIES.add(Pattern.compile("^resource.", 2));
        ADVANCED_PROPERTIES.add(Pattern.compile("^load_cluster.[a-z][a-z0-9-_]{0,63}.priority$", 2));
        ADVANCED_PROPERTIES.add(Pattern.compile("^max_query_instances$", 2));
        ADVANCED_PROPERTIES.add(Pattern.compile("^sql_block_rules$", 2));
        ADVANCED_PROPERTIES.add(Pattern.compile("^cpu_resource_limit$", 2));
        ADVANCED_PROPERTIES.add(Pattern.compile("^resource_tags$", 2));
        ADVANCED_PROPERTIES.add(Pattern.compile("^exec_mem_limit$", 2));
        ADVANCED_PROPERTIES.add(Pattern.compile("^load_mem_limit$", 2));
        COMMON_PROPERTIES.add(Pattern.compile("^quota.", 2));
        COMMON_PROPERTIES.add(Pattern.compile("^default_load_cluster$", 2));
        COMMON_PROPERTIES.add(Pattern.compile("^load_cluster.[a-z][a-z0-9-_]{0,63}.", 2));
    }
}

