/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.common.DdlException;
import org.apache.doris.common.io.Text;
import org.apache.doris.mysql.MysqlPassword;
import org.apache.doris.mysql.privilege.GlobalPrivEntry;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivEntry;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.mysql.privilege.PrivTable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserPrivTable
extends PrivTable {
    private static final Logger LOG = LogManager.getLogger(UserPrivTable.class);

    public void getPrivs(UserIdentity currentUser, PrivBitSet savedPrivs) {
        PrivEntry matchedEntry = null;
        for (PrivEntry entry : this.entries) {
            GlobalPrivEntry globalPrivEntry = (GlobalPrivEntry)entry;
            if (!globalPrivEntry.match(currentUser, true)) continue;
            matchedEntry = globalPrivEntry;
            break;
        }
        if (matchedEntry == null) {
            return;
        }
        savedPrivs.or(matchedEntry.getPrivSet());
    }

    public boolean hasPriv(String host, String user, PrivPredicate wanted) {
        for (PrivEntry entry : this.entries) {
            GlobalPrivEntry globalPrivEntry = (GlobalPrivEntry)entry;
            if (!globalPrivEntry.isAnyHost() && !globalPrivEntry.getHostPattern().match(host) || !globalPrivEntry.isAnyUser() && !globalPrivEntry.getUserPattern().match(user) || !globalPrivEntry.getPrivSet().satisfy(wanted)) continue;
            return true;
        }
        return false;
    }

    public boolean checkPassword(String remoteUser, String remoteHost, byte[] remotePasswd, byte[] randomString, List<UserIdentity> currentUser) {
        LOG.debug("check password for user: {} from {}, password: {}, random string: {}", (Object)remoteUser, (Object)remoteHost, (Object)remotePasswd, (Object)randomString);
        for (PrivEntry entry : this.entries) {
            GlobalPrivEntry globalPrivEntry = (GlobalPrivEntry)entry;
            if (!globalPrivEntry.isAnyHost() && !globalPrivEntry.getHostPattern().match(remoteHost) || !globalPrivEntry.isAnyUser() && !globalPrivEntry.getUserPattern().match(remoteUser)) continue;
            byte[] saltPassword = MysqlPassword.getSaltFromPassword(globalPrivEntry.getPassword());
            if (remotePasswd.length == saltPassword.length && (remotePasswd.length == 0 || MysqlPassword.checkScramble(remotePasswd, randomString, saltPassword))) {
                if (currentUser != null) {
                    currentUser.add(globalPrivEntry.getDomainUserIdent());
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean checkPlainPassword(String remoteUser, String remoteHost, String remotePasswd, List<UserIdentity> currentUser) {
        for (PrivEntry entry : this.entries) {
            GlobalPrivEntry globalPrivEntry = (GlobalPrivEntry)entry;
            if (!globalPrivEntry.isAnyHost() && !globalPrivEntry.getHostPattern().match(remoteHost) || !globalPrivEntry.isAnyUser() && !globalPrivEntry.getUserPattern().match(remoteUser)) continue;
            if (MysqlPassword.checkPlainPass(globalPrivEntry.getPassword(), remotePasswd)) {
                if (currentUser != null) {
                    currentUser.add(globalPrivEntry.getDomainUserIdent());
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void setPassword(GlobalPrivEntry passwdEntry, boolean errOnNonExist) throws DdlException {
        GlobalPrivEntry addedEntry = (GlobalPrivEntry)this.addEntry(passwdEntry, false, errOnNonExist);
        addedEntry.setPassword(passwdEntry.getPassword());
    }

    public boolean doesUserExist(UserIdentity userIdent) {
        for (PrivEntry privEntry : this.entries) {
            if (!privEntry.match(userIdent, true) || privEntry.isSetByDomainResolver()) continue;
            return true;
        }
        return false;
    }

    public UserIdentity getCurrentUserIdentity(UserIdentity userIdent) {
        for (PrivEntry privEntry : this.entries) {
            GlobalPrivEntry globalPrivEntry = (GlobalPrivEntry)privEntry;
            if (!globalPrivEntry.match(userIdent, false)) continue;
            return globalPrivEntry.getDomainUserIdent();
        }
        return null;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (!this.isClassNameWrote) {
            String className = UserPrivTable.class.getCanonicalName();
            Text.writeString((DataOutput)out, (String)className);
            this.isClassNameWrote = true;
        }
        super.write(out);
    }
}

