/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import com.google.common.base.Preconditions;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.analysis.UserIdentity;
import org.apache.doris.common.io.Text;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivEntry;
import org.apache.doris.mysql.privilege.PrivPredicate;
import org.apache.doris.mysql.privilege.PrivTable;
import org.apache.doris.mysql.privilege.TablePrivEntry;
import org.apache.doris.qe.ConnectContext;

public class TablePrivTable
extends PrivTable {
    public void getPrivs(UserIdentity currentUser, String db, String tbl, PrivBitSet savedPrivs) {
        PrivEntry matchedEntry = null;
        for (PrivEntry entry : this.entries) {
            TablePrivEntry tblPrivEntry = (TablePrivEntry)entry;
            if (!tblPrivEntry.match(currentUser, true)) continue;
            Preconditions.checkState((!tblPrivEntry.isAnyDb() ? 1 : 0) != 0);
            if (!tblPrivEntry.getDbPattern().match(db) || !tblPrivEntry.getTblPattern().match(tbl)) continue;
            matchedEntry = tblPrivEntry;
            break;
        }
        if (matchedEntry == null) {
            return;
        }
        savedPrivs.or(matchedEntry.getPrivSet());
    }

    public boolean hasPriv(String host, String user, PrivPredicate wanted) {
        for (PrivEntry entry : this.entries) {
            TablePrivEntry tblPrivEntry = (TablePrivEntry)entry;
            if (!tblPrivEntry.isAnyHost() && !tblPrivEntry.getHostPattern().match(host) || !tblPrivEntry.isAnyUser() && !tblPrivEntry.getUserPattern().match(user) || !tblPrivEntry.privSet.satisfy(wanted)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrivsOfDb(UserIdentity currentUser, String db) {
        for (PrivEntry entry : this.entries) {
            TablePrivEntry tblPrivEntry = (TablePrivEntry)entry;
            if (!tblPrivEntry.match(currentUser, true)) continue;
            Preconditions.checkState((!tblPrivEntry.isAnyDb() ? 1 : 0) != 0);
            if (!tblPrivEntry.getDbPattern().match(db)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (!this.isClassNameWrote) {
            String className = TablePrivTable.class.getCanonicalName();
            Text.writeString((DataOutput)out, (String)className);
            this.isClassNameWrote = true;
        }
        super.write(out);
    }

    public boolean hasClusterPriv(ConnectContext ctx, String clusterName) {
        for (PrivEntry entry : this.entries) {
            TablePrivEntry tblPrivEntry = (TablePrivEntry)entry;
            if (!tblPrivEntry.getOrigDb().startsWith(clusterName)) continue;
            return true;
        }
        return false;
    }
}

