/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.mysql.privilege;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.doris.common.AnalysisException;
import org.apache.doris.common.CaseSensibility;
import org.apache.doris.common.PatternMatcher;
import org.apache.doris.common.io.Text;
import org.apache.doris.mysql.privilege.DbPrivEntry;
import org.apache.doris.mysql.privilege.PrivBitSet;
import org.apache.doris.mysql.privilege.PrivEntry;

public class TablePrivEntry
extends DbPrivEntry {
    private static final String ANY_TBL = "*";
    private PatternMatcher tblPattern;
    private String origTbl;
    private boolean isAnyTbl;

    protected TablePrivEntry() {
    }

    private TablePrivEntry(PatternMatcher hostPattern, String origHost, PatternMatcher dbPattern, String origDb, PatternMatcher userPattern, String user, PatternMatcher tblPattern, String origTbl, boolean isDomain, PrivBitSet privSet) {
        super(hostPattern, origHost, dbPattern, origDb, userPattern, user, isDomain, privSet);
        this.tblPattern = tblPattern;
        this.origTbl = origTbl;
        if (origTbl.equals(ANY_TBL)) {
            this.isAnyTbl = true;
        }
    }

    public static TablePrivEntry create(String host, String db, String user, String tbl, boolean isDomain, PrivBitSet privs) throws AnalysisException {
        PatternMatcher hostPattern = PatternMatcher.createMysqlPattern(host, CaseSensibility.HOST.getCaseSensibility());
        PatternMatcher dbPattern = PatternMatcher.createMysqlPattern(db.equals(ANY_TBL) ? "%" : db, CaseSensibility.DATABASE.getCaseSensibility());
        PatternMatcher userPattern = PatternMatcher.createMysqlPattern(user, CaseSensibility.USER.getCaseSensibility());
        PatternMatcher tblPattern = PatternMatcher.createMysqlPattern(tbl.equals(ANY_TBL) ? "%" : tbl, CaseSensibility.TABLE.getCaseSensibility());
        if (privs.containsNodePriv() || privs.containsResourcePriv()) {
            throw new AnalysisException("Table privilege can not contains global or resource privileges: " + privs);
        }
        return new TablePrivEntry(hostPattern, host, dbPattern, db, userPattern, user, tblPattern, tbl, isDomain, privs);
    }

    public PatternMatcher getTblPattern() {
        return this.tblPattern;
    }

    public String getOrigTbl() {
        return this.origTbl;
    }

    public boolean isAnyTbl() {
        return this.isAnyTbl;
    }

    @Override
    public int compareTo(PrivEntry other) {
        if (!(other instanceof TablePrivEntry)) {
            throw new ClassCastException("cannot cast " + other.getClass().toString() + " to " + this.getClass());
        }
        TablePrivEntry otherEntry = (TablePrivEntry)other;
        int res = this.origHost.compareTo(otherEntry.origHost);
        if (res != 0) {
            return -res;
        }
        res = this.origDb.compareTo(otherEntry.origDb);
        if (res != 0) {
            return -res;
        }
        res = this.origUser.compareTo(otherEntry.origUser);
        if (res != 0) {
            return -res;
        }
        return -this.origTbl.compareTo(otherEntry.origTbl);
    }

    @Override
    public boolean keyMatch(PrivEntry other) {
        if (!(other instanceof TablePrivEntry)) {
            return false;
        }
        TablePrivEntry otherEntry = (TablePrivEntry)other;
        return this.origHost.equals(otherEntry.origHost) && this.origUser.equals(otherEntry.origUser) && this.origDb.equals(otherEntry.origDb) && this.origTbl.equals(otherEntry.origTbl) && this.isDomain == otherEntry.isDomain;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("db priv. host: ").append(this.origHost).append(", db: ").append(this.origDb);
        sb.append(", user: ").append(this.origUser).append(", tbl: ").append(this.origTbl);
        sb.append(", priv: ").append(this.privSet).append(", set by resolver: ").append(this.isSetByDomainResolver);
        return sb.toString();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        if (!this.isClassNameWrote) {
            String className = TablePrivEntry.class.getCanonicalName();
            Text.writeString((DataOutput)out, (String)className);
            this.isClassNameWrote = true;
        }
        super.write(out);
        Text.writeString((DataOutput)out, (String)this.origTbl);
        this.isClassNameWrote = false;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.origTbl = Text.readString((DataInput)in);
        try {
            this.tblPattern = PatternMatcher.createMysqlPattern(this.origTbl, CaseSensibility.TABLE.getCaseSensibility());
        }
        catch (AnalysisException e) {
            throw new IOException(e);
        }
        this.isAnyTbl = this.origTbl.equals(ANY_TBL);
    }
}

